/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials;

import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsDeserializer;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsProviderKt;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsRetryPolicy;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsSerializer;
import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.config.AwsSdkSetting;
import aws.smithy.kotlin.runtime.auth.awscredentials.CloseableCredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderException;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.config.EnvironmentSettingKt;
import aws.smithy.kotlin.runtime.http.SdkHttpClient;
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngineKt;
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine;
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperationBuilder;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperationKt;
import aws.smithy.kotlin.runtime.io.CloseableKt;
import aws.smithy.kotlin.runtime.io.Handler;
import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider;", "Laws/smithy/kotlin/runtime/auth/awscredentials/CloseableCredentialsProvider;", "platformProvider", "Laws/smithy/kotlin/runtime/util/PlatformProvider;", "httpClient", "Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;", "(Laws/smithy/kotlin/runtime/util/PlatformProvider;Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;)V", "manageEngine", "", "getPlatformProvider", "()Laws/smithy/kotlin/runtime/util/PlatformProvider;", "close", "", "loadAuthToken", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAuthTokenFromFile", "path", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "(Laws/smithy/kotlin/runtime/collections/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateFullUri", "Laws/smithy/kotlin/runtime/net/url/Url;", "uri", "validateRelativeUri", "relativeUri", "aws-config"})
@SourceDebugExtension(value={"SMAP\nEcsCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SdkHttpOperation.kt\naws/smithy/kotlin/runtime/http/operation/SdkHttpOperation$Companion\n*L\n1#1,263:1\n258#2:264\n259#2:266\n1#3:265\n1#3:271\n65#4,4:267\n*S KotlinDebug\n*F\n+ 1 EcsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider\n*L\n74#1:264\n74#1:266\n74#1:265\n85#1:267,4\n*E\n"})
public final class EcsCredentialsProvider
implements CloseableCredentialsProvider {
    @NotNull
    private final PlatformProvider platformProvider;
    private final boolean manageEngine;
    @NotNull
    private final HttpClientEngine httpClient;

    public EcsCredentialsProvider(@NotNull PlatformProvider platformProvider, @Nullable HttpClientEngine httpClient) {
        Intrinsics.checkNotNullParameter((Object)platformProvider, (String)"platformProvider");
        this.platformProvider = platformProvider;
        this.manageEngine = httpClient == null;
        HttpClientEngine httpClientEngine = httpClient;
        if (httpClientEngine == null) {
            httpClientEngine = (HttpClientEngine)DefaultHttpEngineKt.DefaultHttpEngine$default(null, (int)1, null);
        }
        this.httpClient = httpClientEngine;
    }

    public /* synthetic */ EcsCredentialsProvider(PlatformProvider platformProvider, HttpClientEngine httpClientEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            platformProvider = PlatformProvider.Companion.getSystem();
        }
        if ((n & 2) != 0) {
            httpClientEngine = null;
        }
        this(platformProvider, httpClientEngine);
    }

    @NotNull
    public final PlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object resolve(@NotNull Attributes var1_1, @NotNull Continuation<? super Credentials> var2_2) {
        block15: {
            if (!(var2_2 instanceof resolve.1)) ** GOTO lbl-1000
            var15_3 = var2_2;
            if ((var15_3.label & -2147483648) != 0) {
                var15_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ EcsCredentialsProvider this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.resolve(null, (Continuation<? super Credentials>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$logger$iv = $continuation.getContext();
                    $i$f$logger = false;
                    v0 = Reflection.getOrCreateKotlinClass(EcsCredentialsProvider.class).getQualifiedName();
                    if (v0 == null) {
                        $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv = false;
                        $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv = "logger<T> cannot be used on an anonymous object";
                        throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv.toString());
                    }
                    sourceComponent$iv = v0;
                    logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                    $continuation.L$0 = this;
                    $continuation.L$1 = logger;
                    $continuation.label = 1;
                    v1 = this.loadAuthToken((Continuation<? super String>)$continuation);
                    if (v1 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    logger = (Logger)$continuation.L$1;
                    this = (EcsCredentialsProvider)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl33:
                    // 2 sources

                    authToken = (String)v1;
                    relativeUri = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerCredentialsRelativeUri(), (PlatformEnvironProvider)((PlatformEnvironProvider)this.platformProvider));
                    fullUri = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerCredentialsFullUri(), (PlatformEnvironProvider)((PlatformEnvironProvider)this.platformProvider));
                    v2 = relativeUri;
                    v3 = v2 != null ? !StringsKt.isBlank((CharSequence)v2) : false;
                    if (!v3) ** GOTO lbl42
                    v4 = this.validateRelativeUri(relativeUri);
                    break block15;
lbl42:
                    // 1 sources

                    v5 = fullUri;
                    v6 = v5 != null ? !StringsKt.isBlank((CharSequence)v5) : false;
                    if (!v6) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = logger;
                    $continuation.L$2 = authToken;
                    $continuation.label = 2;
                    v7 = this.validateFullUri(fullUri, (Continuation<? super Url>)$continuation);
                    if (v7 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl59
                }
                case 2: {
                    authToken = (String)$continuation.L$2;
                    logger = (Logger)$continuation.L$1;
                    this = (EcsCredentialsProvider)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl59:
                    // 2 sources

                    v4 = (Url)v7;
                    break block15;
                }
            }
            throw new ProviderConfigurationException("Container credentials URI not set", null, 2, null);
        }
        url = v4;
        $i$f$build = false;
        $this$resolve_u24lambda_u240 = var11_16 = new SdkHttpOperationBuilder(Reflection.getOrCreateKotlinClass(Unit.class), Reflection.getOrCreateKotlinClass(Credentials.class));
        $i$a$-build-EcsCredentialsProvider$resolve$op$1 = false;
        $this$resolve_u24lambda_u240.setSerializer((HttpSerialize)new EcsCredentialsSerializer(authToken));
        $this$resolve_u24lambda_u240.setDeserializer((HttpDeserialize)new EcsCredentialsDeserializer());
        $this$resolve_u24lambda_u240.setOperationName("EcsCredentialsProvider");
        $this$resolve_u24lambda_u240.setServiceName("EcsContainerMetadata");
        $this$resolve_u24lambda_u240.getExecution().setEndpointResolver(new EndpointResolver(url){
            final /* synthetic */ Url $url;
            {
                this.$url = $url;
            }

            @Nullable
            public final Object resolve(@NotNull ResolveEndpointRequest it, @NotNull Continuation<? super Endpoint> $completion) {
                return new Endpoint(this.$url, null, 2, null);
            }
        });
        op = var11_16.build();
        op.getExecution().setRetryPolicy((RetryPolicy)new EcsCredentialsRetryPolicy());
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)resolve.2.INSTANCE, (int)1, null);
        client = new SdkHttpClient(this.httpClient);
        $continuation.L$0 = logger;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 3;
        v8 = SdkHttpOperationKt.roundTrip((SdkHttpOperation)op, (Handler)((Handler)client), (Object)Unit.INSTANCE, (Continuation)$continuation);
        ** if (v8 != var16_5) goto lbl87
lbl86:
        // 1 sources

        return var16_5;
lbl87:
        // 1 sources

        ** GOTO lbl94
        {
            case 3: {
                logger = (Logger)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl94:
                    // 2 sources

                    var11_16 = (Credentials)v8;
                }
                catch (Exception ex) {
                    Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)resolve.creds.1.INSTANCE, (int)1, null);
                    throw ex instanceof CredentialsProviderException != false ? (Throwable)ex : (Throwable)new CredentialsProviderException("Failed to get credentials from container metadata service", (Throwable)ex);
                }
                creds = var11_16;
                Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(creds){
                    final /* synthetic */ Credentials $creds;
                    {
                        this.$creds = $creds;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        Instant instant = this.$creds.getExpiration();
                        return "obtained credentials from container metadata service; expiration=" + (instant != null ? instant.format(TimestampFormat.ISO_8601) : null);
                    }
                }), (int)1, null);
                return creds;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadAuthToken(Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof loadAuthToken.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ EcsCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EcsCredentialsProvider.access$loadAuthToken(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerAuthorizationTokenFile(), (PlatformEnvironProvider)((PlatformEnvironProvider)this.platformProvider));
                if (v0 == null) ** GOTO lbl31
                it = v0;
                $i$a$-let-EcsCredentialsProvider$loadAuthToken$token$1 = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.loadAuthTokenFromFile(it, (Continuation<? super String>)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$a$-let-EcsCredentialsProvider$loadAuthToken$token$1 = false;
                this = (EcsCredentialsProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                v2 = (String)v1;
                v0 = v2;
                if (v2 != null) ** GOTO lbl33
lbl31:
                // 2 sources

                if ((v0 = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerAuthorizationToken(), (PlatformEnvironProvider)((PlatformEnvironProvider)this.platformProvider))) == null) {
                    return null;
                }
lbl33:
                // 3 sources

                if (StringsKt.contains$default((CharSequence)(token = v0), (CharSequence)"\r\n", (boolean)false, (int)2, null)) {
                    throw new CredentialsProviderException("Token contains illegal line break sequence.", null, 2, null);
                }
                return token;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object loadAuthTokenFromFile(String var1_1, Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof loadAuthTokenFromFile.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ EcsCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EcsCredentialsProvider.access$loadAuthTokenFromFile(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.platformProvider.readFileOrNull((String)path, (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if ((v1 /* !! */  = (byte[])v0) == null) ** GOTO lbl24
                v2 = StringsKt.decodeToString((byte[])v1 /* !! */ );
                v1 /* !! */  = (byte[])v2;
                if (v2 != null) ** GOTO lbl25
lbl24:
                // 2 sources

                throw new CredentialsProviderException("Could not read token file.", null, 2, null);
lbl25:
                // 1 sources

                return v1 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Url validateRelativeUri(String relativeUri) {
        Url url;
        try {
            url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("http://169.254.170.2" + relativeUri), null, (int)2, null);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException("Invalid relativeUri `" + relativeUri + '`', ex);
        }
        return url;
    }

    private final Object validateFullUri(String uri, Continuation<? super Url> $completion) {
        Url url;
        try {
            url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)uri, null, (int)2, null);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException("Invalid fullUri `" + uri + '`', ex);
        }
        Url url2 = url;
        if (Intrinsics.areEqual((Object)url2.getScheme(), (Object)Scheme.Companion.getHTTPS())) {
            return url2;
        }
        url = url2.getHost();
        if (url instanceof Host.IpAddress) {
            Set set = EcsCredentialsProviderKt.access$getAllowedAddrs$p();
            Host host = url2.getHost();
            Intrinsics.checkNotNull((Object)host, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.net.Host.IpAddress");
            if (set.contains(((Host.IpAddress)host).getAddress())) {
                return url2;
            }
            throw new ProviderConfigurationException("The container credentials full URI (" + uri + ") has an invalid host. Host can only be one of [" + CollectionsKt.joinToString$default((Iterable)EcsCredentialsProviderKt.access$getAllowedAddrs$p(), null, null, null, (int)0, null, null, (int)63, null) + "].", null, 2, null);
        }
        if (url instanceof Host.Domain) {
            throw new ProviderConfigurationException("The container credentials full URI (" + uri + ") is specified via hostname which is not currently supported.", null, 2, null);
        }
        throw new NoWhenBranchMatchedException();
    }

    public void close() {
        if (this.manageEngine) {
            CloseableKt.closeIfCloseable((Object)this.httpClient);
        }
    }

    public EcsCredentialsProvider() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Object access$loadAuthToken(EcsCredentialsProvider $this, Continuation $completion) {
        return $this.loadAuthToken((Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$loadAuthTokenFromFile(EcsCredentialsProvider $this, String path, Continuation $completion) {
        return $this.loadAuthTokenFromFile(path, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$validateFullUri(EcsCredentialsProvider $this, String uri, Continuation $completion) {
        return $this.validateFullUri(uri, (Continuation<? super Url>)$completion);
    }
}

