/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.serde;

import aws.sdk.kotlin.services.s3.model.PutBucketAclRequest;
import aws.sdk.kotlin.services.s3.serde.AccessControlPolicyPayloadSerializerKt;
import aws.sdk.kotlin.services.s3.serde.PutBucketAclOperationSerializer;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpMethod;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder;
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilderKt;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Laws/sdk/kotlin/services/s3/serde/PutBucketAclOperationSerializer;", "Laws/smithy/kotlin/runtime/http/operation/HttpSerialize;", "Laws/sdk/kotlin/services/s3/model/PutBucketAclRequest;", "()V", "serialize", "Laws/smithy/kotlin/runtime/http/request/HttpRequestBuilder;", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "input", "(Laws/smithy/kotlin/runtime/operation/ExecutionContext;Laws/sdk/kotlin/services/s3/model/PutBucketAclRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "s3"})
public final class PutBucketAclOperationSerializer
implements HttpSerialize<PutBucketAclRequest> {
    @Nullable
    public Object serialize(@NotNull ExecutionContext context, @NotNull PutBucketAclRequest input, @NotNull Continuation<? super HttpRequestBuilder> $completion) {
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setMethod(HttpMethod.PUT);
        HttpRequestBuilderKt.url((HttpRequestBuilder)builder, (Function1)serialize.2.INSTANCE);
        HttpRequestBuilderKt.headers((HttpRequestBuilder)builder, (Function1)((Function1)new Function1<HeadersBuilder, Unit>(input){
            final /* synthetic */ PutBucketAclRequest $input;
            {
                this.$input = $input;
                super(1);
            }

            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                if (this.$input.getAcl() != null) {
                    $this$headers.append("x-amz-acl", (Object)this.$input.getAcl().getValue());
                }
                if (this.$input.getChecksumAlgorithm() != null) {
                    $this$headers.append("x-amz-sdk-checksum-algorithm", (Object)this.$input.getChecksumAlgorithm().getValue());
                }
                String string = this.$input.getContentMd5();
                boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
                if (bl) {
                    $this$headers.append("Content-MD5", (Object)this.$input.getContentMd5());
                }
                String string2 = this.$input.getExpectedBucketOwner();
                boolean bl2 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                if (bl2) {
                    $this$headers.append("x-amz-expected-bucket-owner", (Object)this.$input.getExpectedBucketOwner());
                }
                String string3 = this.$input.getGrantFullControl();
                boolean bl3 = string3 != null ? ((CharSequence)string3).length() > 0 : false;
                if (bl3) {
                    $this$headers.append("x-amz-grant-full-control", (Object)this.$input.getGrantFullControl());
                }
                String string4 = this.$input.getGrantRead();
                boolean bl4 = string4 != null ? ((CharSequence)string4).length() > 0 : false;
                if (bl4) {
                    $this$headers.append("x-amz-grant-read", (Object)this.$input.getGrantRead());
                }
                String string5 = this.$input.getGrantReadAcp();
                boolean bl5 = string5 != null ? ((CharSequence)string5).length() > 0 : false;
                if (bl5) {
                    $this$headers.append("x-amz-grant-read-acp", (Object)this.$input.getGrantReadAcp());
                }
                String string6 = this.$input.getGrantWrite();
                boolean bl6 = string6 != null ? ((CharSequence)string6).length() > 0 : false;
                if (bl6) {
                    $this$headers.append("x-amz-grant-write", (Object)this.$input.getGrantWrite());
                }
                String string7 = this.$input.getGrantWriteAcp();
                boolean bl7 = string7 != null ? ((CharSequence)string7).length() > 0 : false;
                if (bl7) {
                    $this$headers.append("x-amz-grant-write-acp", (Object)this.$input.getGrantWriteAcp());
                }
            }
        }));
        if (input.getAccessControlPolicy() != null) {
            byte[] payload = AccessControlPolicyPayloadSerializerKt.serializeAccessControlPolicyPayloadWithXmlNameAccessControlPolicy(input.getAccessControlPolicy());
            builder.setBody(HttpBody.Companion.fromBytes(payload));
        }
        if (!(builder.getBody() instanceof HttpBody.Empty)) {
            builder.getHeaders().setMissing("Content-Type", (Object)"application/xml");
        }
        return builder;
    }
}

