// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.time.Instant

public class CopyObjectRequest private constructor(builder: Builder) {
    /**
     * The canned access control list (ACL) to apply to the object.
     *
     * When you copy an object, the ACL metadata is not preserved and is set to `private` by default. Only the owner has full access control. To override the default ACL setting, specify a new ACL when you generate a copy request. For more information, see [Using ACLs](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
     *
     * If the destination bucket that you're copying objects to uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. Buckets that use this setting only accept `PUT` requests that don't specify an ACL or `PUT` requests that specify bucket owner full control ACLs, such as the `bucket-owner-full-control` canned ACL or an equivalent form of this ACL expressed in the XML format. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
     *
     * + If your destination bucket uses the bucket owner enforced setting for Object Ownership, all objects written to the bucket by any account will be owned by the bucket owner.
     * + This functionality is not supported for directory buckets.
     * + This functionality is not supported for Amazon S3 on Outposts.
     */
    public val acl: aws.sdk.kotlin.services.s3.model.ObjectCannedAcl? = builder.acl
    /**
     * The name of the destination bucket.
     *
     * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the object.
     *
     * Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.
     *
     * For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val bucketKeyEnabled: kotlin.Boolean? = builder.bucketKeyEnabled
    /**
     * Specifies the caching behavior along the request/reply chain.
     */
    public val cacheControl: kotlin.String? = builder.cacheControl
    /**
     * Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     *
     * When you copy an object, if the source object has a checksum, that checksum value will be copied to the new object by default. If the `CopyObject` request does not include this `x-amz-checksum-algorithm` header, the checksum algorithm will be copied from the source object to the destination object (if it's present on the source object). You can optionally specify a different checksum algorithm to use with the `x-amz-checksum-algorithm` header. Unrecognized or unsupported values will respond with the HTTP status code `400 Bad Request`.
     *
     * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * Specifies presentational information for the object. Indicates whether an object should be displayed in a web browser or downloaded as a file. It allows specifying the desired filename for the downloaded file.
     */
    public val contentDisposition: kotlin.String? = builder.contentDisposition
    /**
     * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
     *
     * For directory buckets, only the `aws-chunked` value is supported in this header field.
     */
    public val contentEncoding: kotlin.String? = builder.contentEncoding
    /**
     * The language the content is in.
     */
    public val contentLanguage: kotlin.String? = builder.contentLanguage
    /**
     * A standard MIME type that describes the format of the object data.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Specifies the source object for the copy operation. The source object can be up to 5 GB. If the source object is an object that was uploaded by using a multipart upload, the object copy will be a single part object after the source object is copied to the destination bucket.
     *
     * You specify the value of the copy source in one of two formats, depending on whether you want to access the source object through an [access point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
     * + For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object `reports/january.pdf` from the general purpose bucket `awsexamplebucket`, use `awsexamplebucket/reports/january.pdf`. The value must be URL-encoded. To copy the object `reports/january.pdf` from the directory bucket `awsexamplebucket--use1-az5--x-s3`, use `awsexamplebucket--use1-az5--x-s3/reports/january.pdf`. The value must be URL-encoded.
     * + For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, to copy the object `reports/january.pdf` through access point `my-access-point` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`. The value must be URL encoded.   + Amazon S3 supports copy operations using Access points only when the source and destination buckets are in the same Amazon Web Services Region.
     *    + Access points are not supported by directory buckets.
     * Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`. For example, to copy the object `reports/january.pdf` through outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`. The value must be URL-encoded.
     *
     * If your source bucket versioning is enabled, the `x-amz-copy-source` header by default identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the `versionId` query parameter. Specifically, append `?versionId=<version-id>` to the value (for example, `awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.
     *
     * If you enable versioning on the destination bucket, Amazon S3 generates a unique version ID for the copied object. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the `x-amz-version-id` response header in the response.
     *
     * If you do not enable versioning or suspend it on the destination bucket, the version ID that Amazon S3 generates in the `x-amz-version-id` response header is always null.
     *
     * **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets.
     */
    public val copySource: kotlin.String? = builder.copySource
    /**
     * Copies the object if its entity tag (ETag) matches the specified tag.
     *
     *  If both the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request and evaluate as follows, Amazon S3 returns `200 OK` and copies the data:
     * + `x-amz-copy-source-if-match` condition evaluates to true
     * + `x-amz-copy-source-if-unmodified-since` condition evaluates to false
     */
    public val copySourceIfMatch: kotlin.String? = builder.copySourceIfMatch
    /**
     * Copies the object if it has been modified since the specified time.
     *
     * If both the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request and evaluate as follows, Amazon S3 returns the `412 Precondition Failed` response code:
     * + `x-amz-copy-source-if-none-match` condition evaluates to false
     * + `x-amz-copy-source-if-modified-since` condition evaluates to true
     */
    public val copySourceIfModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.copySourceIfModifiedSince
    /**
     * Copies the object if its entity tag (ETag) is different than the specified ETag.
     *
     * If both the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request and evaluate as follows, Amazon S3 returns the `412 Precondition Failed` response code:
     * + `x-amz-copy-source-if-none-match` condition evaluates to false
     * + `x-amz-copy-source-if-modified-since` condition evaluates to true
     */
    public val copySourceIfNoneMatch: kotlin.String? = builder.copySourceIfNoneMatch
    /**
     * Copies the object if it hasn't been modified since the specified time.
     *
     *  If both the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request and evaluate as follows, Amazon S3 returns `200 OK` and copies the data:
     * + `x-amz-copy-source-if-match` condition evaluates to true
     * + `x-amz-copy-source-if-unmodified-since` condition evaluates to false
     */
    public val copySourceIfUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.copySourceIfUnmodifiedSince
    /**
     * Specifies the algorithm to use when decrypting the source object (for example, `AES256`).
     *
     * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerAlgorithm: kotlin.String? = builder.copySourceSseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be the same one that was used when the source object was created.
     *
     * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerKey: kotlin.String? = builder.copySourceSseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     *
     * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
     *
     * This functionality is not supported when the source object is in a directory bucket.
     */
    public val copySourceSseCustomerKeyMd5: kotlin.String? = builder.copySourceSseCustomerKeyMd5
    /**
     * The account ID of the expected destination bucket owner. If the account ID that you provide does not match the actual owner of the destination bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The account ID of the expected source bucket owner. If the account ID that you provide does not match the actual owner of the source bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedSourceBucketOwner: kotlin.String? = builder.expectedSourceBucketOwner
    /**
     * The date and time at which the object is no longer cacheable.
     */
    public val expires: aws.smithy.kotlin.runtime.time.Instant? = builder.expires
    /**
     * Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
     *
     * + This functionality is not supported for directory buckets.
     * + This functionality is not supported for Amazon S3 on Outposts.
     */
    public val grantFullControl: kotlin.String? = builder.grantFullControl
    /**
     * Allows grantee to read the object data and its metadata.
     *
     * + This functionality is not supported for directory buckets.
     * + This functionality is not supported for Amazon S3 on Outposts.
     */
    public val grantRead: kotlin.String? = builder.grantRead
    /**
     * Allows grantee to read the object ACL.
     *
     * + This functionality is not supported for directory buckets.
     * + This functionality is not supported for Amazon S3 on Outposts.
     */
    public val grantReadAcp: kotlin.String? = builder.grantReadAcp
    /**
     * Allows grantee to write the ACL for the applicable object.
     *
     * + This functionality is not supported for directory buckets.
     * + This functionality is not supported for Amazon S3 on Outposts.
     */
    public val grantWriteAcp: kotlin.String? = builder.grantWriteAcp
    /**
     * The key of the destination object.
     */
    public val key: kotlin.String? = builder.key
    /**
     * A map of metadata to store with the object in S3.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * Specifies whether the metadata is copied from the source object or replaced with metadata that's provided in the request. When copying an object, you can preserve all metadata (the default) or specify new metadata. If this header isn’t specified, `COPY` is the default behavior.
     *
     * **General purpose bucket** - For general purpose buckets, when you grant permissions, you can use the `s3:x-amz-metadata-directive` condition key to enforce certain metadata behavior when objects are uploaded. For more information, see [Amazon S3 condition key examples](https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html) in the *Amazon S3 User Guide*.
     *
     * `x-amz-website-redirect-location` is unique to each object and is not copied when using the `x-amz-metadata-directive` header. To copy the value, you must specify `x-amz-website-redirect-location` in the request header.
     */
    public val metadataDirective: aws.sdk.kotlin.services.s3.model.MetadataDirective? = builder.metadataDirective
    /**
     * Specifies whether you want to apply a legal hold to the object copy.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus? = builder.objectLockLegalHoldStatus
    /**
     * The Object Lock mode that you want to apply to the object copy.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockMode: aws.sdk.kotlin.services.s3.model.ObjectLockMode? = builder.objectLockMode
    /**
     * The date and time when you want the Object Lock of the object copy to expire.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = builder.objectLockRetainUntilDate
    /**
     * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * The server-side encryption algorithm used when storing this object in Amazon S3 (for example, `AES256`, `aws:kms`, `aws:kms:dsse`). Unrecognized or unsupported values won’t write a destination object and will receive a `400 Bad Request` response.
     *
     * Amazon S3 automatically encrypts all new objects that are copied to an S3 bucket. When copying an object, if you don't specify encryption information in your copy request, the encryption setting of the target object is set to the default encryption configuration of the destination bucket. By default, all buckets have a base level of encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket has a default encryption configuration that uses server-side encryption with Key Management Service (KMS) keys (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side encryption with customer-provided encryption keys (SSE-C), Amazon S3 uses the corresponding KMS key, or a customer-provided key to encrypt the target object copy.
     *
     * When you perform a `CopyObject` operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.
     *
     * With server-side encryption, Amazon S3 encrypts your data as it writes your data to disks in its data centers and decrypts the data when you access it. For more information about server-side encryption, see [Using Server-Side Encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) in the *Amazon S3 User Guide*.
     *
     * For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (`AES256`) is supported.
     */
    public val serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = builder.serverSideEncryption
    /**
     * Specifies the algorithm to use when encrypting the object (for example, `AES256`).
     *
     * When you perform a `CopyObject` operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded. Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerKey: kotlin.String? = builder.sseCustomerKey
    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. This value must be explicitly added to specify encryption context for `CopyObject` requests.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val ssekmsEncryptionContext: kotlin.String? = builder.ssekmsEncryptionContext
    /**
     * Specifies the KMS ID (Key ID, Key ARN, or Key Alias) to use for object encryption. All GET and PUT requests for an object protected by KMS will fail if they're not made via SSL or using SigV4. For information about configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see [Specifying the Signature Version in Request Authentication](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported when the destination bucket is a directory bucket.
     */
    public val ssekmsKeyId: kotlin.String? = builder.ssekmsKeyId
    /**
     * If the `x-amz-storage-class` header is not used, the copied object will be stored in the `STANDARD` Storage Class by default. The `STANDARD` storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class.
     *
     * + **Directory buckets ** - For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects. Unsupported storage class values won't write a destination object and will respond with the HTTP status code `400 Bad Request`.
     * + **Amazon S3 on Outposts ** - S3 on Outposts only uses the `OUTPOSTS` Storage Class.
     * You can use the `CopyObject` action to change the storage class of an object that is already stored in Amazon S3 by using the `x-amz-storage-class` header. For more information, see [Storage Classes](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html) in the *Amazon S3 User Guide*.
     *
     * Before using an object as a source object for the copy operation, you must restore a copy of it if it meets any of the following conditions:
     * + The storage class of the source object is `GLACIER` or `DEEP_ARCHIVE`.
     * + The storage class of the source object is `INTELLIGENT_TIERING` and it's [S3 Intelligent-Tiering access tier](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering-overview.html#intel-tiering-tier-definition) is `Archive Access` or `Deep Archive Access`.
     *
     * For more information, see [RestoreObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html) and [Copying Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html) in the *Amazon S3 User Guide*.
     */
    public val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * The tag-set for the object copy in the destination bucket. This value must be used in conjunction with the `x-amz-tagging-directive` if you choose `REPLACE` for the `x-amz-tagging-directive`. If you choose `COPY` for the `x-amz-tagging-directive`, you don't need to set the `x-amz-tagging` header, because the tag-set will be copied from the source object directly. The tag-set must be encoded as URL Query parameters.
     *
     * The default value is the empty value.
     *
     * **Directory buckets** - For directory buckets in a `CopyObject` operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a `501 Not Implemented` status code. When the destination bucket is a directory bucket, you will receive a `501 Not Implemented` response in any of the following situations:
     * + When you attempt to `COPY` the tag-set from an S3 source object that has non-empty tags.
     * + When you attempt to `REPLACE` the tag-set of a source object and set a non-empty value to `x-amz-tagging`.
     * + When you don't set the `x-amz-tagging-directive` header and the source object has non-empty tags. This is because the default value of `x-amz-tagging-directive` is `COPY`.
     * Because only the empty tag-set is supported for directory buckets in a `CopyObject` operation, the following situations are allowed:
     * + When you attempt to `COPY` the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.
     * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and set the `x-amz-tagging` value of the directory bucket destination object to empty.
     * + When you attempt to `REPLACE` the tag-set of a general purpose bucket source object that has non-empty tags and set the `x-amz-tagging` value of the directory bucket destination object to empty.
     * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and don't set the `x-amz-tagging` value of the directory bucket destination object. This is because the default value of `x-amz-tagging` is the empty value.
     */
    public val tagging: kotlin.String? = builder.tagging
    /**
     * Specifies whether the object tag-set is copied from the source object or replaced with the tag-set that's provided in the request.
     *
     * The default value is `COPY`.
     *
     * **Directory buckets** - For directory buckets in a `CopyObject` operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a `501 Not Implemented` status code. When the destination bucket is a directory bucket, you will receive a `501 Not Implemented` response in any of the following situations:
     * + When you attempt to `COPY` the tag-set from an S3 source object that has non-empty tags.
     * + When you attempt to `REPLACE` the tag-set of a source object and set a non-empty value to `x-amz-tagging`.
     * + When you don't set the `x-amz-tagging-directive` header and the source object has non-empty tags. This is because the default value of `x-amz-tagging-directive` is `COPY`.
     * Because only the empty tag-set is supported for directory buckets in a `CopyObject` operation, the following situations are allowed:
     * + When you attempt to `COPY` the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.
     * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and set the `x-amz-tagging` value of the directory bucket destination object to empty.
     * + When you attempt to `REPLACE` the tag-set of a general purpose bucket source object that has non-empty tags and set the `x-amz-tagging` value of the directory bucket destination object to empty.
     * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and don't set the `x-amz-tagging` value of the directory bucket destination object. This is because the default value of `x-amz-tagging` is the empty value.
     */
    public val taggingDirective: aws.sdk.kotlin.services.s3.model.TaggingDirective? = builder.taggingDirective
    /**
     * If the destination bucket is configured as a website, redirects requests for this object copy to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. This value is unique to each object and is not copied when using the `x-amz-metadata-directive` header. Instead, you may opt to provide this header in combination with the `x-amz-metadata-directive` header.
     *
     * This functionality is not supported for directory buckets.
     */
    public val websiteRedirectLocation: kotlin.String? = builder.websiteRedirectLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CopyObjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyObjectRequest(")
        append("acl=$acl,")
        append("bucket=$bucket,")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("cacheControl=$cacheControl,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("contentDisposition=$contentDisposition,")
        append("contentEncoding=$contentEncoding,")
        append("contentLanguage=$contentLanguage,")
        append("contentType=$contentType,")
        append("copySource=$copySource,")
        append("copySourceIfMatch=$copySourceIfMatch,")
        append("copySourceIfModifiedSince=$copySourceIfModifiedSince,")
        append("copySourceIfNoneMatch=$copySourceIfNoneMatch,")
        append("copySourceIfUnmodifiedSince=$copySourceIfUnmodifiedSince,")
        append("copySourceSseCustomerAlgorithm=$copySourceSseCustomerAlgorithm,")
        append("copySourceSseCustomerKey=*** Sensitive Data Redacted ***,")
        append("copySourceSseCustomerKeyMd5=$copySourceSseCustomerKeyMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("expectedSourceBucketOwner=$expectedSourceBucketOwner,")
        append("expires=$expires,")
        append("grantFullControl=$grantFullControl,")
        append("grantRead=$grantRead,")
        append("grantReadAcp=$grantReadAcp,")
        append("grantWriteAcp=$grantWriteAcp,")
        append("key=$key,")
        append("metadata=$metadata,")
        append("metadataDirective=$metadataDirective,")
        append("objectLockLegalHoldStatus=$objectLockLegalHoldStatus,")
        append("objectLockMode=$objectLockMode,")
        append("objectLockRetainUntilDate=$objectLockRetainUntilDate,")
        append("requestPayer=$requestPayer,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKey=*** Sensitive Data Redacted ***,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("ssekmsEncryptionContext=*** Sensitive Data Redacted ***,")
        append("ssekmsKeyId=*** Sensitive Data Redacted ***,")
        append("storageClass=$storageClass,")
        append("tagging=$tagging,")
        append("taggingDirective=$taggingDirective,")
        append("websiteRedirectLocation=$websiteRedirectLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acl?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (bucketKeyEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheControl?.hashCode() ?: 0)
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (contentDisposition?.hashCode() ?: 0)
        result = 31 * result + (contentEncoding?.hashCode() ?: 0)
        result = 31 * result + (contentLanguage?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (copySource?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfMatch?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfModifiedSince?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfNoneMatch?.hashCode() ?: 0)
        result = 31 * result + (copySourceIfUnmodifiedSince?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (copySourceSseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (expectedSourceBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (expires?.hashCode() ?: 0)
        result = 31 * result + (grantFullControl?.hashCode() ?: 0)
        result = 31 * result + (grantRead?.hashCode() ?: 0)
        result = 31 * result + (grantReadAcp?.hashCode() ?: 0)
        result = 31 * result + (grantWriteAcp?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (metadataDirective?.hashCode() ?: 0)
        result = 31 * result + (objectLockLegalHoldStatus?.hashCode() ?: 0)
        result = 31 * result + (objectLockMode?.hashCode() ?: 0)
        result = 31 * result + (objectLockRetainUntilDate?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKey?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (ssekmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (ssekmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tagging?.hashCode() ?: 0)
        result = 31 * result + (taggingDirective?.hashCode() ?: 0)
        result = 31 * result + (websiteRedirectLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyObjectRequest

        if (acl != other.acl) return false
        if (bucket != other.bucket) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (cacheControl != other.cacheControl) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (contentDisposition != other.contentDisposition) return false
        if (contentEncoding != other.contentEncoding) return false
        if (contentLanguage != other.contentLanguage) return false
        if (contentType != other.contentType) return false
        if (copySource != other.copySource) return false
        if (copySourceIfMatch != other.copySourceIfMatch) return false
        if (copySourceIfModifiedSince != other.copySourceIfModifiedSince) return false
        if (copySourceIfNoneMatch != other.copySourceIfNoneMatch) return false
        if (copySourceIfUnmodifiedSince != other.copySourceIfUnmodifiedSince) return false
        if (copySourceSseCustomerAlgorithm != other.copySourceSseCustomerAlgorithm) return false
        if (copySourceSseCustomerKey != other.copySourceSseCustomerKey) return false
        if (copySourceSseCustomerKeyMd5 != other.copySourceSseCustomerKeyMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (expectedSourceBucketOwner != other.expectedSourceBucketOwner) return false
        if (expires != other.expires) return false
        if (grantFullControl != other.grantFullControl) return false
        if (grantRead != other.grantRead) return false
        if (grantReadAcp != other.grantReadAcp) return false
        if (grantWriteAcp != other.grantWriteAcp) return false
        if (key != other.key) return false
        if (metadata != other.metadata) return false
        if (metadataDirective != other.metadataDirective) return false
        if (objectLockLegalHoldStatus != other.objectLockLegalHoldStatus) return false
        if (objectLockMode != other.objectLockMode) return false
        if (objectLockRetainUntilDate != other.objectLockRetainUntilDate) return false
        if (requestPayer != other.requestPayer) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKey != other.sseCustomerKey) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (ssekmsEncryptionContext != other.ssekmsEncryptionContext) return false
        if (ssekmsKeyId != other.ssekmsKeyId) return false
        if (storageClass != other.storageClass) return false
        if (tagging != other.tagging) return false
        if (taggingDirective != other.taggingDirective) return false
        if (websiteRedirectLocation != other.websiteRedirectLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CopyObjectRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The canned access control list (ACL) to apply to the object.
         *
         * When you copy an object, the ACL metadata is not preserved and is set to `private` by default. Only the owner has full access control. To override the default ACL setting, specify a new ACL when you generate a copy request. For more information, see [Using ACLs](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
         *
         * If the destination bucket that you're copying objects to uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. Buckets that use this setting only accept `PUT` requests that don't specify an ACL or `PUT` requests that specify bucket owner full control ACLs, such as the `bucket-owner-full-control` canned ACL or an equivalent form of this ACL expressed in the XML format. For more information, see [Controlling ownership of objects and disabling ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
         *
         * + If your destination bucket uses the bucket owner enforced setting for Object Ownership, all objects written to the bucket by any account will be owned by the bucket owner.
         * + This functionality is not supported for directory buckets.
         * + This functionality is not supported for Amazon S3 on Outposts.
         */
        public var acl: aws.sdk.kotlin.services.s3.model.ObjectCannedAcl? = null
        /**
         * The name of the destination bucket.
         *
         * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the object.
         *
         * Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.
         *
         * For more information, see [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var bucketKeyEnabled: kotlin.Boolean? = null
        /**
         * Specifies the caching behavior along the request/reply chain.
         */
        public var cacheControl: kotlin.String? = null
        /**
         * Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         *
         * When you copy an object, if the source object has a checksum, that checksum value will be copied to the new object by default. If the `CopyObject` request does not include this `x-amz-checksum-algorithm` header, the checksum algorithm will be copied from the source object to the destination object (if it's present on the source object). You can optionally specify a different checksum algorithm to use with the `x-amz-checksum-algorithm` header. Unrecognized or unsupported values will respond with the HTTP status code `400 Bad Request`.
         *
         * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * Specifies presentational information for the object. Indicates whether an object should be displayed in a web browser or downloaded as a file. It allows specifying the desired filename for the downloaded file.
         */
        public var contentDisposition: kotlin.String? = null
        /**
         * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
         *
         * For directory buckets, only the `aws-chunked` value is supported in this header field.
         */
        public var contentEncoding: kotlin.String? = null
        /**
         * The language the content is in.
         */
        public var contentLanguage: kotlin.String? = null
        /**
         * A standard MIME type that describes the format of the object data.
         */
        public var contentType: kotlin.String? = null
        /**
         * Specifies the source object for the copy operation. The source object can be up to 5 GB. If the source object is an object that was uploaded by using a multipart upload, the object copy will be a single part object after the source object is copied to the destination bucket.
         *
         * You specify the value of the copy source in one of two formats, depending on whether you want to access the source object through an [access point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
         * + For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object `reports/january.pdf` from the general purpose bucket `awsexamplebucket`, use `awsexamplebucket/reports/january.pdf`. The value must be URL-encoded. To copy the object `reports/january.pdf` from the directory bucket `awsexamplebucket--use1-az5--x-s3`, use `awsexamplebucket--use1-az5--x-s3/reports/january.pdf`. The value must be URL-encoded.
         * + For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`. For example, to copy the object `reports/january.pdf` through access point `my-access-point` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`. The value must be URL encoded.   + Amazon S3 supports copy operations using Access points only when the source and destination buckets are in the same Amazon Web Services Region.
         *    + Access points are not supported by directory buckets.
         * Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`. For example, to copy the object `reports/january.pdf` through outpost `my-outpost` owned by account `123456789012` in Region `us-west-2`, use the URL encoding of `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`. The value must be URL-encoded.
         *
         * If your source bucket versioning is enabled, the `x-amz-copy-source` header by default identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the `versionId` query parameter. Specifically, append `?versionId=<version-id>` to the value (for example, `awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.
         *
         * If you enable versioning on the destination bucket, Amazon S3 generates a unique version ID for the copied object. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the `x-amz-version-id` response header in the response.
         *
         * If you do not enable versioning or suspend it on the destination bucket, the version ID that Amazon S3 generates in the `x-amz-version-id` response header is always null.
         *
         * **Directory buckets** - S3 Versioning isn't enabled and supported for directory buckets.
         */
        public var copySource: kotlin.String? = null
        /**
         * Copies the object if its entity tag (ETag) matches the specified tag.
         *
         *  If both the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request and evaluate as follows, Amazon S3 returns `200 OK` and copies the data:
         * + `x-amz-copy-source-if-match` condition evaluates to true
         * + `x-amz-copy-source-if-unmodified-since` condition evaluates to false
         */
        public var copySourceIfMatch: kotlin.String? = null
        /**
         * Copies the object if it has been modified since the specified time.
         *
         * If both the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request and evaluate as follows, Amazon S3 returns the `412 Precondition Failed` response code:
         * + `x-amz-copy-source-if-none-match` condition evaluates to false
         * + `x-amz-copy-source-if-modified-since` condition evaluates to true
         */
        public var copySourceIfModifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Copies the object if its entity tag (ETag) is different than the specified ETag.
         *
         * If both the `x-amz-copy-source-if-none-match` and `x-amz-copy-source-if-modified-since` headers are present in the request and evaluate as follows, Amazon S3 returns the `412 Precondition Failed` response code:
         * + `x-amz-copy-source-if-none-match` condition evaluates to false
         * + `x-amz-copy-source-if-modified-since` condition evaluates to true
         */
        public var copySourceIfNoneMatch: kotlin.String? = null
        /**
         * Copies the object if it hasn't been modified since the specified time.
         *
         *  If both the `x-amz-copy-source-if-match` and `x-amz-copy-source-if-unmodified-since` headers are present in the request and evaluate as follows, Amazon S3 returns `200 OK` and copies the data:
         * + `x-amz-copy-source-if-match` condition evaluates to true
         * + `x-amz-copy-source-if-unmodified-since` condition evaluates to false
         */
        public var copySourceIfUnmodifiedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the algorithm to use when decrypting the source object (for example, `AES256`).
         *
         * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be the same one that was used when the source object was created.
         *
         * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         *
         * If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.
         *
         * This functionality is not supported when the source object is in a directory bucket.
         */
        public var copySourceSseCustomerKeyMd5: kotlin.String? = null
        /**
         * The account ID of the expected destination bucket owner. If the account ID that you provide does not match the actual owner of the destination bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The account ID of the expected source bucket owner. If the account ID that you provide does not match the actual owner of the source bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedSourceBucketOwner: kotlin.String? = null
        /**
         * The date and time at which the object is no longer cacheable.
         */
        public var expires: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
         *
         * + This functionality is not supported for directory buckets.
         * + This functionality is not supported for Amazon S3 on Outposts.
         */
        public var grantFullControl: kotlin.String? = null
        /**
         * Allows grantee to read the object data and its metadata.
         *
         * + This functionality is not supported for directory buckets.
         * + This functionality is not supported for Amazon S3 on Outposts.
         */
        public var grantRead: kotlin.String? = null
        /**
         * Allows grantee to read the object ACL.
         *
         * + This functionality is not supported for directory buckets.
         * + This functionality is not supported for Amazon S3 on Outposts.
         */
        public var grantReadAcp: kotlin.String? = null
        /**
         * Allows grantee to write the ACL for the applicable object.
         *
         * + This functionality is not supported for directory buckets.
         * + This functionality is not supported for Amazon S3 on Outposts.
         */
        public var grantWriteAcp: kotlin.String? = null
        /**
         * The key of the destination object.
         */
        public var key: kotlin.String? = null
        /**
         * A map of metadata to store with the object in S3.
         */
        public var metadata: Map<String, String>? = null
        /**
         * Specifies whether the metadata is copied from the source object or replaced with metadata that's provided in the request. When copying an object, you can preserve all metadata (the default) or specify new metadata. If this header isn’t specified, `COPY` is the default behavior.
         *
         * **General purpose bucket** - For general purpose buckets, when you grant permissions, you can use the `s3:x-amz-metadata-directive` condition key to enforce certain metadata behavior when objects are uploaded. For more information, see [Amazon S3 condition key examples](https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html) in the *Amazon S3 User Guide*.
         *
         * `x-amz-website-redirect-location` is unique to each object and is not copied when using the `x-amz-metadata-directive` header. To copy the value, you must specify `x-amz-website-redirect-location` in the request header.
         */
        public var metadataDirective: aws.sdk.kotlin.services.s3.model.MetadataDirective? = null
        /**
         * Specifies whether you want to apply a legal hold to the object copy.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus? = null
        /**
         * The Object Lock mode that you want to apply to the object copy.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockMode: aws.sdk.kotlin.services.s3.model.ObjectLockMode? = null
        /**
         * The date and time when you want the Object Lock of the object copy to expire.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see [Downloading Objects in Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * The server-side encryption algorithm used when storing this object in Amazon S3 (for example, `AES256`, `aws:kms`, `aws:kms:dsse`). Unrecognized or unsupported values won’t write a destination object and will receive a `400 Bad Request` response.
         *
         * Amazon S3 automatically encrypts all new objects that are copied to an S3 bucket. When copying an object, if you don't specify encryption information in your copy request, the encryption setting of the target object is set to the default encryption configuration of the destination bucket. By default, all buckets have a base level of encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket has a default encryption configuration that uses server-side encryption with Key Management Service (KMS) keys (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side encryption with customer-provided encryption keys (SSE-C), Amazon S3 uses the corresponding KMS key, or a customer-provided key to encrypt the target object copy.
         *
         * When you perform a `CopyObject` operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.
         *
         * With server-side encryption, Amazon S3 encrypts your data as it writes your data to disks in its data centers and decrypts the data when you access it. For more information about server-side encryption, see [Using Server-Side Encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) in the *Amazon S3 User Guide*.
         *
         * For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (`AES256`) is supported.
         */
        public var serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null
        /**
         * Specifies the algorithm to use when encrypting the object (for example, `AES256`).
         *
         * When you perform a `CopyObject` operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded. Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the `x-amz-server-side-encryption-customer-algorithm` header.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerKey: kotlin.String? = null
        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. This value must be explicitly added to specify encryption context for `CopyObject` requests.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var ssekmsEncryptionContext: kotlin.String? = null
        /**
         * Specifies the KMS ID (Key ID, Key ARN, or Key Alias) to use for object encryption. All GET and PUT requests for an object protected by KMS will fail if they're not made via SSL or using SigV4. For information about configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see [Specifying the Signature Version in Request Authentication](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported when the destination bucket is a directory bucket.
         */
        public var ssekmsKeyId: kotlin.String? = null
        /**
         * If the `x-amz-storage-class` header is not used, the copied object will be stored in the `STANDARD` Storage Class by default. The `STANDARD` storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class.
         *
         * + **Directory buckets ** - For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects. Unsupported storage class values won't write a destination object and will respond with the HTTP status code `400 Bad Request`.
         * + **Amazon S3 on Outposts ** - S3 on Outposts only uses the `OUTPOSTS` Storage Class.
         * You can use the `CopyObject` action to change the storage class of an object that is already stored in Amazon S3 by using the `x-amz-storage-class` header. For more information, see [Storage Classes](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html) in the *Amazon S3 User Guide*.
         *
         * Before using an object as a source object for the copy operation, you must restore a copy of it if it meets any of the following conditions:
         * + The storage class of the source object is `GLACIER` or `DEEP_ARCHIVE`.
         * + The storage class of the source object is `INTELLIGENT_TIERING` and it's [S3 Intelligent-Tiering access tier](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering-overview.html#intel-tiering-tier-definition) is `Archive Access` or `Deep Archive Access`.
         *
         * For more information, see [RestoreObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html) and [Copying Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html) in the *Amazon S3 User Guide*.
         */
        public var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * The tag-set for the object copy in the destination bucket. This value must be used in conjunction with the `x-amz-tagging-directive` if you choose `REPLACE` for the `x-amz-tagging-directive`. If you choose `COPY` for the `x-amz-tagging-directive`, you don't need to set the `x-amz-tagging` header, because the tag-set will be copied from the source object directly. The tag-set must be encoded as URL Query parameters.
         *
         * The default value is the empty value.
         *
         * **Directory buckets** - For directory buckets in a `CopyObject` operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a `501 Not Implemented` status code. When the destination bucket is a directory bucket, you will receive a `501 Not Implemented` response in any of the following situations:
         * + When you attempt to `COPY` the tag-set from an S3 source object that has non-empty tags.
         * + When you attempt to `REPLACE` the tag-set of a source object and set a non-empty value to `x-amz-tagging`.
         * + When you don't set the `x-amz-tagging-directive` header and the source object has non-empty tags. This is because the default value of `x-amz-tagging-directive` is `COPY`.
         * Because only the empty tag-set is supported for directory buckets in a `CopyObject` operation, the following situations are allowed:
         * + When you attempt to `COPY` the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.
         * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and set the `x-amz-tagging` value of the directory bucket destination object to empty.
         * + When you attempt to `REPLACE` the tag-set of a general purpose bucket source object that has non-empty tags and set the `x-amz-tagging` value of the directory bucket destination object to empty.
         * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and don't set the `x-amz-tagging` value of the directory bucket destination object. This is because the default value of `x-amz-tagging` is the empty value.
         */
        public var tagging: kotlin.String? = null
        /**
         * Specifies whether the object tag-set is copied from the source object or replaced with the tag-set that's provided in the request.
         *
         * The default value is `COPY`.
         *
         * **Directory buckets** - For directory buckets in a `CopyObject` operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a `501 Not Implemented` status code. When the destination bucket is a directory bucket, you will receive a `501 Not Implemented` response in any of the following situations:
         * + When you attempt to `COPY` the tag-set from an S3 source object that has non-empty tags.
         * + When you attempt to `REPLACE` the tag-set of a source object and set a non-empty value to `x-amz-tagging`.
         * + When you don't set the `x-amz-tagging-directive` header and the source object has non-empty tags. This is because the default value of `x-amz-tagging-directive` is `COPY`.
         * Because only the empty tag-set is supported for directory buckets in a `CopyObject` operation, the following situations are allowed:
         * + When you attempt to `COPY` the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.
         * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and set the `x-amz-tagging` value of the directory bucket destination object to empty.
         * + When you attempt to `REPLACE` the tag-set of a general purpose bucket source object that has non-empty tags and set the `x-amz-tagging` value of the directory bucket destination object to empty.
         * + When you attempt to `REPLACE` the tag-set of a directory bucket source object and don't set the `x-amz-tagging` value of the directory bucket destination object. This is because the default value of `x-amz-tagging` is the empty value.
         */
        public var taggingDirective: aws.sdk.kotlin.services.s3.model.TaggingDirective? = null
        /**
         * If the destination bucket is configured as a website, redirects requests for this object copy to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. This value is unique to each object and is not copied when using the `x-amz-metadata-directive` header. Instead, you may opt to provide this header in combination with the `x-amz-metadata-directive` header.
         *
         * This functionality is not supported for directory buckets.
         */
        public var websiteRedirectLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CopyObjectRequest) : this() {
            this.acl = x.acl
            this.bucket = x.bucket
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.cacheControl = x.cacheControl
            this.checksumAlgorithm = x.checksumAlgorithm
            this.contentDisposition = x.contentDisposition
            this.contentEncoding = x.contentEncoding
            this.contentLanguage = x.contentLanguage
            this.contentType = x.contentType
            this.copySource = x.copySource
            this.copySourceIfMatch = x.copySourceIfMatch
            this.copySourceIfModifiedSince = x.copySourceIfModifiedSince
            this.copySourceIfNoneMatch = x.copySourceIfNoneMatch
            this.copySourceIfUnmodifiedSince = x.copySourceIfUnmodifiedSince
            this.copySourceSseCustomerAlgorithm = x.copySourceSseCustomerAlgorithm
            this.copySourceSseCustomerKey = x.copySourceSseCustomerKey
            this.copySourceSseCustomerKeyMd5 = x.copySourceSseCustomerKeyMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.expectedSourceBucketOwner = x.expectedSourceBucketOwner
            this.expires = x.expires
            this.grantFullControl = x.grantFullControl
            this.grantRead = x.grantRead
            this.grantReadAcp = x.grantReadAcp
            this.grantWriteAcp = x.grantWriteAcp
            this.key = x.key
            this.metadata = x.metadata
            this.metadataDirective = x.metadataDirective
            this.objectLockLegalHoldStatus = x.objectLockLegalHoldStatus
            this.objectLockMode = x.objectLockMode
            this.objectLockRetainUntilDate = x.objectLockRetainUntilDate
            this.requestPayer = x.requestPayer
            this.serverSideEncryption = x.serverSideEncryption
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKey = x.sseCustomerKey
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.ssekmsEncryptionContext = x.ssekmsEncryptionContext
            this.ssekmsKeyId = x.ssekmsKeyId
            this.storageClass = x.storageClass
            this.tagging = x.tagging
            this.taggingDirective = x.taggingDirective
            this.websiteRedirectLocation = x.websiteRedirectLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CopyObjectRequest = CopyObjectRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
