/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.engine.EngineAttributes;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetrics;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpEngine;
import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.net.DefaultHostResolverJVMKt;
import aws.smithy.kotlin.runtime.net.HostResolver;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProviderContextKt;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import aws.smithy.kotlin.runtime.telemetry.logging.LoggerProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.Histogram;
import aws.smithy.kotlin.runtime.telemetry.metrics.HistogramKt;
import aws.smithy.kotlin.runtime.telemetry.trace.SpanStatus;
import aws.smithy.kotlin.runtime.telemetry.trace.TraceSpan;
import aws.smithy.kotlin.runtime.telemetry.trace.TraceSpanExtKt;
import aws.smithy.kotlin.runtime.telemetry.trace.Tracer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010*\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J2\u00101\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010&\u001a\u00020'H\u0016J \u00102\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u00103\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0016J&\u00107\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00108\u001a\u000209H\u0016J&\u0010>\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020.0;H\u0016J\u0018\u0010B\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010C\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010G\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010H\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010L\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010N\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010O\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010P\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010Q\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020 H\u0016J\u001a\u0010R\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010S\u001a\u0004\u0018\u00010TH\u0016J\u0010\u0010U\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010V\u001a\u00020\u001e2\u0012\b\u0004\u0010W\u001a\f\u0012\u0004\u0012\u0002090Xj\u0002`YH\u0082\bJ%\u0010V\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020[2\u0012\b\u0004\u0010W\u001a\f\u0012\u0004\u0012\u0002090Xj\u0002`YH\u0082\bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\\"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener;", "Lokhttp3/EventListener;", "pool", "Lokhttp3/ConnectionPool;", "hr", "Laws/smithy/kotlin/runtime/net/HostResolver;", "dispatcher", "Lokhttp3/Dispatcher;", "metrics", "Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "call", "Lokhttp3/Call;", "(Lokhttp3/ConnectionPool;Laws/smithy/kotlin/runtime/net/HostResolver;Lokhttp3/Dispatcher;Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;Lokhttp3/Call;)V", "callTimeStart", "Lkotlin/time/TimeMark;", "dnsStartTime", "logger", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "provider", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "queuedDuration", "Lkotlin/time/Duration;", "J", "requestTimeEnd", "signaledConnectAcquireDuration", "", "signaledQueuedDuration", "traceSpan", "Laws/smithy/kotlin/runtime/telemetry/trace/TraceSpan;", "cacheConditionalHit", "", "cachedResponse", "Lokhttp3/Response;", "cacheHit", "response", "cacheMiss", "callEnd", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "canceled", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "proxySelectEnd", "url", "Lokhttp3/HttpUrl;", "proxies", "proxySelectStart", "requestBodyEnd", "byteCount", "", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "responseHeadersStart", "satisfactionFailure", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "trace", "msg", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/telemetry/logging/MessageSupplier;", "throwable", "", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nHttpEngineEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpEngineEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener\n+ 2 Request.kt\nokhttp3/Request\n+ 3 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerProvider.kt\naws/smithy/kotlin/runtime/telemetry/logging/LoggerProviderKt\n*L\n1#1,217:1\n60#1,2:224\n60#1,2:226\n60#1,2:228\n60#1,2:230\n60#1,2:232\n60#1,2:234\n60#1,2:236\n60#1,2:238\n60#1,2:240\n64#1,2:242\n60#1,2:244\n60#1,2:246\n60#1,2:248\n60#1,2:250\n60#1,2:252\n64#1,2:254\n60#1,2:257\n60#1,2:259\n60#1,2:261\n60#1,2:263\n64#1,2:265\n60#1,2:267\n60#1,2:269\n64#1,2:271\n60#1,2:273\n60#1,2:275\n60#1,2:277\n60#1,2:279\n60#1,2:281\n100#2:218\n100#2:219\n100#2:256\n258#3:220\n259#3:222\n1#4:221\n31#5:223\n*S KotlinDebug\n*F\n+ 1 HttpEngineEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/HttpEngineEventListener\n*L\n74#1:224,2\n84#1:226,2\n88#1:228,2\n90#1:230,2\n93#1:232,2\n96#1:234,2\n98#1:236,2\n100#1:238,2\n103#1:240,2\n112#1:242,2\n139#1:244,2\n142#1:246,2\n149#1:248,2\n152#1:250,2\n156#1:252,2\n159#1:254,2\n166#1:257,2\n171#1:259,2\n174#1:261,2\n177#1:263,2\n179#1:265,2\n185#1:267,2\n191#1:269,2\n198#1:271,2\n204#1:273,2\n209#1:275,2\n211#1:277,2\n213#1:279,2\n215#1:281,2\n41#1:218\n46#1:219\n164#1:256\n46#1:220\n46#1:222\n46#1:221\n46#1:223\n*E\n"})
public final class HttpEngineEventListener
extends EventListener {
    @NotNull
    private final ConnectionPool pool;
    @NotNull
    private final HostResolver hr;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final HttpClientMetrics metrics;
    @NotNull
    private final TelemetryProvider provider;
    @NotNull
    private final TraceSpan traceSpan;
    @NotNull
    private final Logger logger;
    @Nullable
    private TimeMark callTimeStart;
    private boolean signaledQueuedDuration;
    private long queuedDuration;
    private boolean signaledConnectAcquireDuration;
    @Nullable
    private TimeMark dnsStartTime;
    @Nullable
    private TimeMark requestTimeEnd;

    public HttpEngineEventListener(@NotNull ConnectionPool pool, @NotNull HostResolver hr, @NotNull Dispatcher dispatcher, @NotNull HttpClientMetrics metrics, @NotNull Call call) {
        SdkRequestTag sdkRequestTag;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
                Intrinsics.checkNotNullParameter((Object)hr, (String)"hr");
                Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
                Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                this.pool = pool;
                this.hr = hr;
                this.dispatcher = dispatcher;
                this.metrics = metrics;
                Request this_$iv = call.request();
                boolean $i$f$reifiedTag = false;
                SdkRequestTag sdkRequestTag2 = (SdkRequestTag)this_$iv.tag(Reflection.getOrCreateKotlinClass(SdkRequestTag.class));
                if (sdkRequestTag2 == null || (sdkRequestTag2 = sdkRequestTag2.getCallContext()) == null || (sdkRequestTag2 = TelemetryProviderContextKt.getTelemetryProvider((CoroutineContext)sdkRequestTag2)) == null) {
                    sdkRequestTag2 = TelemetryProvider.Companion.getNone();
                }
                this.provider = sdkRequestTag2;
                this.traceSpan = Tracer.DefaultImpls.createSpan$default((Tracer)this.provider.getTracerProvider().getOrCreateTracer("aws.smithy.kotlin.runtime.http.engine.okhttp"), (String)"HTTP", null, null, null, (int)14, null);
                this_$iv = call.request();
                $i$f$reifiedTag = false;
                sdkRequestTag = (SdkRequestTag)this_$iv.tag(Reflection.getOrCreateKotlinClass(SdkRequestTag.class));
                if (sdkRequestTag == null || (sdkRequestTag = sdkRequestTag.getCallContext()) == null) break block6;
                SdkRequestTag $this$logger$iv = sdkRequestTag;
                boolean $i$f$logger = false;
                String string = Reflection.getOrCreateKotlinClass(OkHttpEngine.class).getQualifiedName();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "logger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                String sourceComponent$iv = string;
                sdkRequestTag = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                if (sdkRequestTag != null) break block7;
            }
            LoggerProvider $this$getLogger$iv = LoggerProvider.Companion.getNone();
            boolean $i$f$getLogger = false;
            LoggerProvider loggerProvider = $this$getLogger$iv;
            String string = Reflection.getOrCreateKotlinClass(OkHttpEngine.class).getQualifiedName();
            if (string == null) {
                LoggerProvider loggerProvider2 = loggerProvider;
                boolean bl = false;
                LoggerProvider loggerProvider3 = loggerProvider2;
                String string3 = "getLogger<T> cannot be used on an anonymous object";
                throw new IllegalArgumentException(string3.toString());
            }
            sdkRequestTag = loggerProvider.getOrCreateLogger(string);
        }
        this.logger = sdkRequestTag;
        this.queuedDuration = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
    }

    private final void trace(Function0<String> msg) {
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(msg){
            final /* synthetic */ Function0<String> $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)this.$msg.invoke();
            }
        }), (int)1, null);
    }

    private final void trace(Throwable throwable, Function0<String> msg) {
        boolean $i$f$trace = false;
        this.logger.trace(throwable, (Function0)new Function0<String>(msg){
            final /* synthetic */ Function0<String> $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)this.$msg.invoke();
            }
        });
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        long now = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.callTimeStart = TimeSource.Monotonic.ValueTimeMark.box-impl((long)now);
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "call started";
            }
        }), (int)1, null);
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        this.dnsStartTime = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        if (!this.signaledQueuedDuration) {
            TimeMark timeMark = this.callTimeStart;
            if (timeMark == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            this.queuedDuration = timeMark.elapsedNow-UwyO8pc();
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getRequestsQueuedDuration(), (long)this.queuedDuration, null, null, (int)6, null);
            this.signaledQueuedDuration = true;
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(domainName){
            final /* synthetic */ String $domainName$inlined;
            {
                this.$domainName$inlined = string;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "dns query: domain=" + this.$domainName$inlined;
            }
        }), (int)1, null);
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(domainName, inetAddressList){
            final /* synthetic */ String $domainName$inlined;
            final /* synthetic */ List $inetAddressList$inlined;
            {
                this.$domainName$inlined = string;
                this.$inetAddressList$inlined = list;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "dns resolved: domain=" + this.$domainName$inlined + "; records=" + this.$inetAddressList$inlined;
            }
        }), (int)1, null);
    }

    public void proxySelectStart(@NotNull Call call, @NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(url){
            final /* synthetic */ HttpUrl $url$inlined;
            {
                this.$url$inlined = httpUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "proxy select start: url=" + this.$url$inlined;
            }
        }), (int)1, null);
    }

    public void proxySelectEnd(@NotNull Call call, @NotNull HttpUrl url, @NotNull List<? extends Proxy> proxies) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(proxies, (String)"proxies");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(url, proxies){
            final /* synthetic */ HttpUrl $url$inlined;
            final /* synthetic */ List $proxies$inlined;
            {
                this.$url$inlined = httpUrl;
                this.$proxies$inlined = list;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "proxy select end: url=" + this.$url$inlined + "; proxies=" + this.$proxies$inlined;
            }
        }), (int)1, null);
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(inetSocketAddress, proxy){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "starting connection: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined;
            }
        }), (int)1, null);
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "initiating TLS connection";
            }
        }), (int)1, null);
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(handshake){
            final /* synthetic */ Handshake $handshake$inlined;
            {
                this.$handshake$inlined = handshake;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "TLS connect end: handshake=" + this.$handshake$inlined;
            }
        }), (int)1, null);
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "connection established: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        }), (int)1, null);
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(inetSocketAddress, proxy, protocol){
            final /* synthetic */ InetSocketAddress $inetSocketAddress$inlined;
            final /* synthetic */ Proxy $proxy$inlined;
            final /* synthetic */ Protocol $protocol$inlined;
            {
                this.$inetSocketAddress$inlined = inetSocketAddress;
                this.$proxy$inlined = proxy;
                this.$protocol$inlined = protocol;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "connect failed: addr=" + this.$inetSocketAddress$inlined + "; proxy=" + this.$proxy$inlined + "; protocol=" + this.$protocol$inlined;
            }
        });
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
        this.hr.reportFailure(DefaultHostResolverJVMKt.toHostAddress((InetAddress)inetAddress));
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.metrics.setAcquiredConnections((long)this.pool.connectionCount());
        this.metrics.setIdleConnections((long)this.pool.idleConnectionCount());
        TimeMark timeMark = this.callTimeStart;
        if (timeMark == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        TimeMark callStarted = timeMark;
        if (!this.signaledQueuedDuration) {
            this.signaledQueuedDuration = true;
            this.queuedDuration = callStarted.elapsedNow-UwyO8pc();
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getRequestsQueuedDuration(), (long)this.queuedDuration, null, null, (int)6, null);
        }
        if (!this.signaledConnectAcquireDuration) {
            long l;
            this.signaledConnectAcquireDuration = true;
            if (this.dnsStartTime != null) {
                TimeMark timeMark2 = this.dnsStartTime;
                Intrinsics.checkNotNull((Object)timeMark2);
                l = timeMark2.elapsedNow-UwyO8pc();
            } else {
                l = Duration.minus-LRDsOJo((long)callStarted.elapsedNow-UwyO8pc(), (long)this.queuedDuration);
            }
            long connectAcquireDuration = l;
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getConnectionAcquireDuration(), (long)connectAcquireDuration, null, null, (int)6, null);
        }
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "connection acquired: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        }), (int)1, null);
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "sending request headers";
            }
        }), (int)1, null);
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() == null) {
            this.requestTimeEnd = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "finished sending request headers";
            }
        }), (int)1, null);
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "sending request body";
            }
        }), (int)1, null);
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.requestTimeEnd = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "finished sending request body: bytesSent=" + this.$byteCount$inlined;
            }
        }), (int)1, null);
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "request failed";
            }
        });
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        TimeMark timeMark = this.requestTimeEnd;
        if (timeMark != null) {
            long ttfb = timeMark.elapsedNow-UwyO8pc();
            boolean bl = false;
            HistogramKt.recordSeconds-dWUq8MI$default((Histogram)this.metrics.getTimeToFirstByteDuration(), (long)ttfb, null, null, (int)6, null);
            Request this_$iv = call.request();
            boolean $i$f$reifiedTag = false;
            SdkRequestTag sdkRequestTag = (SdkRequestTag)this_$iv.tag(Reflection.getOrCreateKotlinClass(SdkRequestTag.class));
            if (sdkRequestTag != null && (sdkRequestTag = sdkRequestTag.getExecContext()) != null) {
                sdkRequestTag.set(EngineAttributes.INSTANCE.getTimeToFirstByte(), Duration.box-impl((long)ttfb));
            }
        }
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "response headers start";
            }
        }), (int)1, null);
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = response.body().contentLength();
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(contentLength){
            final /* synthetic */ long $contentLength$inlined;
            {
                this.$contentLength$inlined = l;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "response headers end: contentLengthHeader=" + this.$contentLength$inlined;
            }
        }), (int)1, null);
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "response body available";
            }
        }), (int)1, null);
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(byteCount){
            final /* synthetic */ long $byteCount$inlined;
            {
                this.$byteCount$inlined = l;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "response body finished: bytesConsumed=" + this.$byteCount$inlined;
            }
        }), (int)1, null);
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "response failed";
            }
        });
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.metrics.setAcquiredConnections((long)this.pool.connectionCount());
        this.metrics.setIdleConnections((long)this.pool.idleConnectionCount());
        int connId = System.identityHashCode(connection);
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(connId, connection, this){
            final /* synthetic */ int $connId$inlined;
            final /* synthetic */ Connection $connection$inlined;
            final /* synthetic */ HttpEngineEventListener this$0;
            {
                this.$connId$inlined = n;
                this.$connection$inlined = connection;
                this.this$0 = httpEngineEventListener;
                super(0);
            }

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "connection released: conn(id=" + this.$connId$inlined + ")=" + this.$connection$inlined + "; connPool: total=" + HttpEngineEventListener.access$getPool$p(this.this$0).connectionCount() + ", idle=" + HttpEngineEventListener.access$getPool$p(this.this$0).idleConnectionCount();
            }
        }), (int)1, null);
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "call complete";
            }
        }), (int)1, null);
        this.traceSpan.close();
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        this.metrics.setQueuedRequests((long)this.dispatcher.queuedCallsCount());
        this.metrics.setInFlightRequests((long)this.dispatcher.runningCallsCount());
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        this_$iv.logger.trace((Throwable)ioe, (Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "call failed";
            }
        });
        TraceSpanExtKt.recordException((TraceSpan)this.traceSpan, (Throwable)ioe, (boolean)true);
        this.traceSpan.setStatus(SpanStatus.ERROR);
        this.traceSpan.close();
    }

    public void canceled(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "call cancelled";
            }
        }), (int)1, null);
    }

    public void satisfactionFailure(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "cache satisfaction failure";
            }
        }), (int)1, null);
    }

    public void cacheConditionalHit(@NotNull Call call, @NotNull Response cachedResponse) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "cache conditional hit";
            }
        }), (int)1, null);
    }

    public void cacheHit(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "cache hit";
            }
        }), (int)1, null);
    }

    public void cacheMiss(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        HttpEngineEventListener this_$iv = this;
        boolean $i$f$trace = false;
        Logger.DefaultImpls.trace$default((Logger)this_$iv.logger, null, (Function0)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                boolean bl = false;
                return "cache miss";
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ ConnectionPool access$getPool$p(HttpEngineEventListener $this) {
        return $this.pool;
    }
}

