/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.content.DocumentKt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.SerialKind;
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer;
import aws.smithy.kotlin.runtime.serde.json.JsonFieldIterator;
import aws.smithy.kotlin.runtime.serde.json.JsonNullFieldIterator;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamReader;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamReaderKt;
import aws.smithy.kotlin.runtime.serde.json.JsonToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001:B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\f\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u00020*H\u0016J\b\u00101\u001a\u00020\u0011H\u0016J6\u00102\u001a\u0002H3\"\u0004\b\u0000\u001032!\u00104\u001a\u001d\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0004\u0012\u0002H305H\u0002\u00a2\u0006\u0002\u00109R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonDeserializer;", "Laws/smithy/kotlin/runtime/serde/Deserializer;", "Laws/smithy/kotlin/runtime/serde/Deserializer$ElementIterator;", "Laws/smithy/kotlin/runtime/serde/Deserializer$EntryIterator;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "payload", "", "([B)V", "reader", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamReader;", "deserializeBigDecimal", "Ljava/math/BigDecimal;", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeBigInteger", "Ljava/math/BigInteger;", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBoolean", "", "deserializeByte", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeDocumentImpl", "deserializeDouble", "", "deserializeFloat", "", "deserializeInt", "", "deserializeList", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "deserializeLong", "", "deserializeMap", "deserializeNull", "", "deserializeNumber", "", "deserializeShort", "", "deserializeString", "", "deserializeStruct", "Laws/smithy/kotlin/runtime/serde/Deserializer$FieldIterator;", "Laws/smithy/kotlin/runtime/serde/SdkObjectDescriptor;", "hasNextElement", "hasNextEntry", "key", "nextHasValue", "nextNumberValue", "T", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "serde-json"})
@SourceDebugExtension(value={"SMAP\nJsonDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonDeserializer.kt\naws/smithy/kotlin/runtime/serde/json/JsonDeserializer\n+ 2 JsonStreamReader.kt\naws/smithy/kotlin/runtime/serde/json/JsonStreamReaderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Deserializer.kt\naws/smithy/kotlin/runtime/serde/DeserializerKt\n*L\n1#1,228:1\n42#2,14:229\n42#2,14:248\n42#2,14:262\n42#2,14:276\n42#2,14:290\n42#2,14:304\n42#2,14:318\n42#2,14:332\n1#3:243\n236#4,2:244\n242#4,2:246\n*S KotlinDebug\n*F\n+ 1 JsonDeserializer.kt\naws/smithy/kotlin/runtime/serde/json/JsonDeserializer\n*L\n71#1:229,14\n114#1:248,14\n121#1:262,14\n129#1:276,14\n134#1:290,14\n139#1:304,14\n149#1:318,14\n162#1:332,14\n88#1:244,2\n96#1:246,2\n*E\n"})
public final class JsonDeserializer
implements Deserializer,
Deserializer.ElementIterator,
Deserializer.EntryIterator,
PrimitiveDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonStreamReader reader;
    @NotNull
    private static final Set<String> validNumberStrings;

    public JsonDeserializer(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.reader = JsonStreamReaderKt.jsonStreamReader(payload);
    }

    public byte deserializeByte() {
        return ((Number)this.nextNumberValue(deserializeByte.1.INSTANCE)).byteValue();
    }

    public int deserializeInt() {
        return ((Number)this.nextNumberValue(deserializeInt.1.INSTANCE)).intValue();
    }

    public short deserializeShort() {
        return ((Number)this.nextNumberValue(deserializeShort.1.INSTANCE)).shortValue();
    }

    public long deserializeLong() {
        return ((Number)this.nextNumberValue(deserializeLong.1.INSTANCE)).longValue();
    }

    public float deserializeFloat() {
        return (float)this.deserializeDouble();
    }

    public double deserializeDouble() {
        return ((Number)this.nextNumberValue(deserializeDouble.1.INSTANCE)).doubleValue();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return (BigInteger)this.nextNumberValue(deserializeBigInteger.1.INSTANCE);
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return (BigDecimal)this.nextNumberValue(deserializeBigDecimal.1.INSTANCE);
    }

    private final Number deserializeNumber() {
        return (Number)this.nextNumberValue(deserializeNumber.1.INSTANCE);
    }

    private final <T> T nextNumberValue(Function1<? super String, ? extends T> block) {
        Object object;
        JsonToken token = this.reader.nextToken();
        if (token instanceof JsonToken.Number) {
            object = block.invoke((Object)((JsonToken.Number)token).getValue());
        } else if (token instanceof JsonToken.String && validNumberStrings.contains(((JsonToken.String)token).getValue())) {
            object = block.invoke((Object)((JsonToken.String)token).getValue());
        } else {
            throw new DeserializationException(token + " cannot be deserialized as type Number");
        }
        return (T)object;
    }

    @NotNull
    public String deserializeString() {
        String string;
        JsonToken token = this.reader.nextToken();
        if (token instanceof JsonToken.String) {
            string = ((JsonToken.String)token).getValue();
        } else if (token instanceof JsonToken.Number) {
            string = ((JsonToken.Number)token).getValue();
        } else if (token instanceof JsonToken.Bool) {
            string = String.valueOf(((JsonToken.Bool)token).getValue());
        } else {
            throw new DeserializationException(token + " cannot be deserialized as type String");
        }
        return string;
    }

    public boolean deserializeBoolean() {
        JsonStreamReader $this$nextTokenOf$iv = this.reader;
        boolean $i$f$nextTokenOf = false;
        JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != JsonToken.Bool.class) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.Bool.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
        }
        JsonToken jsonToken = token$iv;
        if (jsonToken == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.Bool");
        }
        JsonToken.Bool token = (JsonToken.Bool)((JsonToken)((JsonToken.Bool)jsonToken));
        return token.getValue();
    }

    @NotNull
    public Document deserializeDocument() {
        Document document = this.deserializeDocumentImpl();
        if (document == null) {
            boolean bl = false;
            String string = "expected non-null document field";
            throw new IllegalStateException(string.toString());
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private final Document deserializeDocumentImpl() {
        Document document;
        JsonToken token = this.reader.peek();
        if (token instanceof JsonToken.Number) {
            document = DocumentKt.Document((Number)this.deserializeNumber());
        } else if (token instanceof JsonToken.String) {
            document = DocumentKt.Document((String)this.deserializeString());
        } else if (token instanceof JsonToken.Bool) {
            document = DocumentKt.Document((boolean)this.deserializeBoolean());
        } else if (Intrinsics.areEqual((Object)token, (Object)JsonToken.Null.INSTANCE)) {
            this.reader.nextToken();
            document = null;
        } else if (Intrinsics.areEqual((Object)token, (Object)JsonToken.BeginArray.INSTANCE)) {
            void $this$deserializeList$iv;
            Deserializer.ElementIterator deserializer$iv;
            Deserializer deserializer = this;
            SdkFieldDescriptor descriptor$iv = new SdkFieldDescriptor((SerialKind)SerialKind.Document.INSTANCE, 0, null, 6, null);
            boolean $i$f$deserializeList = false;
            Deserializer.ElementIterator $this$deserializeDocumentImpl_u24lambda_u241 = deserializer$iv = $this$deserializeList$iv.deserializeList(descriptor$iv);
            boolean bl = false;
            List values = new ArrayList();
            while ($this$deserializeDocumentImpl_u24lambda_u241.hasNextElement()) {
                values.add(this.deserializeDocumentImpl());
            }
            document = (Document)new Document.List(values);
        } else if (Intrinsics.areEqual((Object)token, (Object)JsonToken.BeginObject.INSTANCE)) {
            void $this$deserializeMap$iv;
            Deserializer.EntryIterator deserializer$iv;
            Deserializer $this$deserializeList$iv = this;
            SdkFieldDescriptor descriptor$iv = new SdkFieldDescriptor((SerialKind)SerialKind.Document.INSTANCE, 0, null, 6, null);
            boolean $i$f$deserializeMap = false;
            Deserializer.EntryIterator $this$deserializeDocumentImpl_u24lambda_u242 = deserializer$iv = $this$deserializeMap$iv.deserializeMap(descriptor$iv);
            boolean bl = false;
            Map values = new LinkedHashMap();
            while ($this$deserializeDocumentImpl_u24lambda_u242.hasNextEntry()) {
                values.put($this$deserializeDocumentImpl_u24lambda_u242.key(), this.deserializeDocumentImpl());
            }
            document = (Document)new Document.Map(values);
        } else {
            if ((Intrinsics.areEqual((Object)token, (Object)JsonToken.EndArray.INSTANCE) ? true : Intrinsics.areEqual((Object)token, (Object)JsonToken.EndObject.INSTANCE)) ? true : Intrinsics.areEqual((Object)token, (Object)JsonToken.EndDocument.INSTANCE)) {
                throw new DeserializationException("encountered unexpected json token \"" + token + "\" while deserializing document");
            }
            if (token instanceof JsonToken.Name) {
                throw new DeserializationException("encountered unexpected json field declaration \"" + ((JsonToken.Name)token).getValue() + "\" while deserializing document");
            }
            throw new NoWhenBranchMatchedException();
        }
        return document;
    }

    @Nullable
    public Void deserializeNull() {
        JsonStreamReader $this$nextTokenOf$iv = this.reader;
        boolean $i$f$nextTokenOf = false;
        JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != JsonToken.Null.class) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.Null.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
        }
        JsonToken jsonToken = token$iv;
        if (jsonToken == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.Null");
        }
        JsonToken cfr_ignored_0 = (JsonToken.Null)jsonToken;
        return null;
    }

    @NotNull
    public Deserializer.FieldIterator deserializeStruct(@NotNull SdkObjectDescriptor descriptor) {
        Deserializer.FieldIterator fieldIterator;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        JsonToken jsonToken = this.reader.peek();
        if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.BeginObject.INSTANCE)) {
            JsonStreamReader $this$nextTokenOf$iv = this.reader;
            boolean $i$f$nextTokenOf = false;
            JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
            boolean $i$f$requireToken = false;
            if (token$iv.getClass() != JsonToken.BeginObject.class) {
                throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.BeginObject.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
            }
            JsonToken jsonToken2 = token$iv;
            if (jsonToken2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.BeginObject");
            }
            JsonToken cfr_ignored_0 = (JsonToken.BeginObject)jsonToken2;
            fieldIterator = new JsonFieldIterator(this.reader, descriptor, this);
        } else if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.Null.INSTANCE)) {
            fieldIterator = new JsonNullFieldIterator(this);
        } else {
            throw new DeserializationException("Unexpected token type " + this.reader.peek());
        }
        return fieldIterator;
    }

    @NotNull
    public Deserializer.ElementIterator deserializeList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        JsonStreamReader $this$nextTokenOf$iv = this.reader;
        boolean $i$f$nextTokenOf = false;
        JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != JsonToken.BeginArray.class) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.BeginArray.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
        }
        JsonToken jsonToken = token$iv;
        if (jsonToken == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.BeginArray");
        }
        JsonToken cfr_ignored_0 = (JsonToken.BeginArray)jsonToken;
        return this;
    }

    @NotNull
    public Deserializer.EntryIterator deserializeMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        JsonStreamReader $this$nextTokenOf$iv = this.reader;
        boolean $i$f$nextTokenOf = false;
        JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != JsonToken.BeginObject.class) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.BeginObject.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
        }
        JsonToken jsonToken = token$iv;
        if (jsonToken == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.BeginObject");
        }
        JsonToken cfr_ignored_0 = (JsonToken.BeginObject)jsonToken;
        return this;
    }

    @NotNull
    public String key() {
        JsonStreamReader $this$nextTokenOf$iv = this.reader;
        boolean $i$f$nextTokenOf = false;
        JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
        boolean $i$f$requireToken = false;
        if (token$iv.getClass() != JsonToken.Name.class) {
            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.Name.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
        }
        JsonToken jsonToken = token$iv;
        if (jsonToken == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.Name");
        }
        JsonToken.Name token = (JsonToken.Name)((JsonToken)((JsonToken.Name)jsonToken));
        return token.getValue();
    }

    public boolean nextHasValue() {
        return !Intrinsics.areEqual((Object)this.reader.peek(), (Object)JsonToken.Null.INSTANCE);
    }

    public boolean hasNextEntry() {
        boolean bl;
        JsonToken jsonToken = this.reader.peek();
        if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndObject.INSTANCE)) {
            JsonStreamReader $this$nextTokenOf$iv = this.reader;
            boolean $i$f$nextTokenOf = false;
            JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
            boolean $i$f$requireToken = false;
            if (token$iv.getClass() != JsonToken.EndObject.class) {
                throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.EndObject.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
            }
            JsonToken jsonToken2 = token$iv;
            if (jsonToken2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.EndObject");
            }
            JsonToken cfr_ignored_0 = (JsonToken.EndObject)jsonToken2;
            bl = false;
        } else {
            bl = !(Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.Null.INSTANCE) ? true : Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndDocument.INSTANCE));
        }
        return bl;
    }

    public boolean hasNextElement() {
        boolean bl;
        JsonToken jsonToken = this.reader.peek();
        if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndArray.INSTANCE)) {
            JsonStreamReader $this$nextTokenOf$iv = this.reader;
            boolean $i$f$nextTokenOf = false;
            JsonToken token$iv = $this$nextTokenOf$iv.nextToken();
            boolean $i$f$requireToken = false;
            if (token$iv.getClass() != JsonToken.EndArray.class) {
                throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.EndArray.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv.getClass()));
            }
            JsonToken jsonToken2 = token$iv;
            if (jsonToken2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.EndArray");
            }
            JsonToken cfr_ignored_0 = (JsonToken.EndArray)jsonToken2;
            bl = false;
        } else {
            bl = !Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndDocument.INSTANCE);
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"Infinity", "-Infinity", "NaN"};
        validNumberStrings = SetsKt.setOf((Object[])objectArray);
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonDeserializer$Companion;", "", "()V", "validNumberStrings", "", "", "serde-json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

