/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFileVersionLegalHold;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxLegalHoldAssignment;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="legal_hold")
public class BoxLegalHoldPolicy
extends BoxResource {
    public static final URLTemplate LEGAL_HOLD_URL_TEMPLATE = new URLTemplate("legal_hold_policies/%s");
    public static final URLTemplate ALL_LEGAL_HOLD_URL_TEMPLATE = new URLTemplate("legal_hold_policies");
    public static final URLTemplate LEGAL_HOLD_ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("legal_hold_policies/%s/assignments");
    public static final URLTemplate LIST_OF_FILE_VERSION_HOLDS_URL_TEMPLATE = new URLTemplate("file_version_legal_holds");
    private static final int DEFAULT_LIMIT = 100;

    public BoxLegalHoldPolicy(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = LEGAL_HOLD_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new Info(responseJSON);
    }

    public static Info create(BoxAPIConnection api, String name) {
        return BoxLegalHoldPolicy.createOngoing(api, name, null);
    }

    public static Info create(BoxAPIConnection api, String name, String description, Date filterStartedAt, Date filterEndedAt) {
        BoxLegalHoldPolicy createdPolicy;
        URL url = ALL_LEGAL_HOLD_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_name", name);
        if (description != null) {
            requestJSON.add("description", description);
        }
        if (filterStartedAt != null) {
            requestJSON.add("filter_started_at", BoxDateFormat.format(filterStartedAt));
        }
        if (filterEndedAt != null) {
            requestJSON.add("filter_ended_at", BoxDateFormat.format(filterEndedAt));
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxLegalHoldPolicy boxLegalHoldPolicy = createdPolicy = new BoxLegalHoldPolicy(api, responseJSON.get("id").asString());
        boxLegalHoldPolicy.getClass();
        return boxLegalHoldPolicy.new Info(responseJSON);
    }

    public static Info createOngoing(BoxAPIConnection api, String name, String description) {
        BoxLegalHoldPolicy createdPolicy;
        URL url = ALL_LEGAL_HOLD_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_name", name).add("is_ongoing", true);
        if (description != null) {
            requestJSON.add("description", description);
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxLegalHoldPolicy boxLegalHoldPolicy = createdPolicy = new BoxLegalHoldPolicy(api, responseJSON.get("id").asString());
        boxLegalHoldPolicy.getClass();
        return boxLegalHoldPolicy.new Info(responseJSON);
    }

    public void delete() {
        URL url = LEGAL_HOLD_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public void updateInfo(Info info) {
        URL url = LEGAL_HOLD_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        info.update(responseJSON);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api) {
        return BoxLegalHoldPolicy.getAll(api, null, 100, new String[0]);
    }

    public static Iterable<Info> getAll(final BoxAPIConnection api, String policyName, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (policyName != null) {
            builder.appendParam("policy_name", policyName);
        }
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, ALL_LEGAL_HOLD_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]), limit){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxLegalHoldPolicy policy;
                BoxLegalHoldPolicy boxLegalHoldPolicy = policy = new BoxLegalHoldPolicy(api, jsonObject.get("id").asString());
                boxLegalHoldPolicy.getClass();
                return boxLegalHoldPolicy.new Info(jsonObject);
            }
        };
    }

    public BoxLegalHoldAssignment.Info assignTo(BoxResource resource) {
        return BoxLegalHoldAssignment.create(this.getAPI(), this.getID(), BoxResource.getResourceType(resource.getClass()), resource.getID());
    }

    public Iterable<BoxLegalHoldAssignment.Info> getAssignments(String ... fields) {
        return this.getAssignments(null, null, 100, fields);
    }

    public Iterable<BoxLegalHoldAssignment.Info> getAssignments(String type, String id, int limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (type != null) {
            builder.appendParam("assign_to_type", type);
        }
        if (id != null) {
            builder.appendParam("assign_to_id", id);
        }
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<BoxLegalHoldAssignment.Info>(this.getAPI(), LEGAL_HOLD_ASSIGNMENTS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID()), limit){

            @Override
            protected BoxLegalHoldAssignment.Info factory(JsonObject jsonObject) {
                BoxLegalHoldAssignment assignment;
                BoxLegalHoldAssignment boxLegalHoldAssignment = assignment = new BoxLegalHoldAssignment(BoxLegalHoldPolicy.this.getAPI(), jsonObject.get("id").asString());
                boxLegalHoldAssignment.getClass();
                return boxLegalHoldAssignment.new BoxLegalHoldAssignment.Info(jsonObject);
            }
        };
    }

    public Iterable<BoxFileVersionLegalHold.Info> getFileVersionHolds(String ... fields) {
        return this.getFileVersionHolds(100, fields);
    }

    public Iterable<BoxFileVersionLegalHold.Info> getFileVersionHolds(int limit, String ... fields) {
        QueryStringBuilder queryString = new QueryStringBuilder().appendParam("policy_id", this.getID());
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = LIST_OF_FILE_VERSION_HOLDS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString.toString(), new Object[0]);
        return new BoxResourceIterable<BoxFileVersionLegalHold.Info>(this.getAPI(), url, limit){

            @Override
            protected BoxFileVersionLegalHold.Info factory(JsonObject jsonObject) {
                BoxFileVersionLegalHold assignment;
                BoxFileVersionLegalHold boxFileVersionLegalHold = assignment = new BoxFileVersionLegalHold(BoxLegalHoldPolicy.this.getAPI(), jsonObject.get("id").asString());
                boxFileVersionLegalHold.getClass();
                return new BoxFileVersionLegalHold.Info(boxFileVersionLegalHold, jsonObject);
            }
        };
    }

    public class Info
    extends BoxResource.Info {
        private String policyName;
        private String description;
        private String status;
        private int assignmentCountUser;
        private int assignmentCountFolder;
        private int assignmentCountFile;
        private int assignmentCountFileVersion;
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;
        private Date deletedAt;
        private Date filterStartedAt;
        private Date filterEndedAt;
        private String releaseNotes;
        private Boolean isOngoing;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxLegalHoldPolicy.this;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStatus() {
            return this.status;
        }

        public int getAssignmentCountUser() {
            return this.assignmentCountUser;
        }

        public int getAssignmentCountFolder() {
            return this.assignmentCountFolder;
        }

        public int getAssignmentCountFile() {
            return this.assignmentCountFile;
        }

        public int getAssignmentCountFileVersion() {
            return this.assignmentCountFileVersion;
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public Date getDeletedAt() {
            return this.deletedAt;
        }

        public Date getFilterStartedAt() {
            return this.filterStartedAt;
        }

        public Date getFilterEndedAt() {
            return this.filterEndedAt;
        }

        public String getReleaseNotes() {
            return this.releaseNotes;
        }

        public Boolean getIsOngoing() {
            return this.isOngoing;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("policy_name")) {
                    this.policyName = value.asString();
                } else if (memberName.equals("description")) {
                    this.description = value.asString();
                } else if (memberName.equals("status")) {
                    this.status = value.asString();
                } else if (memberName.equals("release_notes")) {
                    this.releaseNotes = value.asString();
                } else if (memberName.equals("assignment_counts")) {
                    JsonObject countsJSON = value.asObject();
                    this.assignmentCountUser = countsJSON.get("user").asInt();
                    this.assignmentCountFolder = countsJSON.get("folder").asInt();
                    this.assignmentCountFile = countsJSON.get("file").asInt();
                    this.assignmentCountFileVersion = countsJSON.get("file_version").asInt();
                } else if (memberName.equals("created_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.createdBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxLegalHoldPolicy.this.getAPI(), userID);
                        boxUser.getClass();
                        this.createdBy = boxUser.new BoxUser.Info(userJSON);
                    } else {
                        this.createdBy.update(userJSON);
                    }
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("deleted_at")) {
                    this.deletedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("filter_started_at")) {
                    this.filterStartedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("filter_ended_at")) {
                    this.filterEndedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("is_ongoing")) {
                    this.isOngoing = value.asBoolean();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

