/*
 * Decompiled with CFR 0.152.
 */
package com.github.gantsign.maven.plugin.ktlint.internal;

import com.github.gantsign.maven.plugin.ktlint.internal.AbstractLintSupport;
import com.github.gantsign.maven.plugin.ktlint.internal.Sources;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J|\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001926\u0010\u001a\u001a2\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u00020!0\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002J\t\u0010#\u001a\u00020!H\u0086\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/gantsign/maven/plugin/ktlint/internal/Format;", "Lcom/github/gantsign/maven/plugin/ktlint/internal/AbstractLintSupport;", "log", "Lorg/apache/maven/plugin/logging/Log;", "basedir", "Ljava/io/File;", "modulePackaging", "", "sources", "", "Lcom/github/gantsign/maven/plugin/ktlint/internal/Sources;", "charset", "Ljava/nio/charset/Charset;", "android", "", "enableExperimentalRules", "(Lorg/apache/maven/plugin/logging/Log;Ljava/io/File;Ljava/lang/String;Ljava/util/List;Ljava/nio/charset/Charset;ZZ)V", "formattedFileCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "formatFile", "fileName", "sourceText", "ruleSets", "Lcom/pinterest/ktlint/core/RuleSet;", "userData", "", "onError", "Lkotlin/Function2;", "Lcom/pinterest/ktlint/core/LintError;", "Lkotlin/ParameterName;", "name", "err", "corrected", "", "editorConfigPath", "invoke", "ktlint-maven-plugin"})
public final class Format
extends AbstractLintSupport {
    @NotNull
    private final String modulePackaging;
    @NotNull
    private final List<Sources> sources;
    @NotNull
    private final Charset charset;
    @NotNull
    private final AtomicInteger formattedFileCount;

    public Format(@NotNull Log log, @NotNull File basedir, @NotNull String modulePackaging, @NotNull List<Sources> sources, @NotNull Charset charset, boolean android, boolean enableExperimentalRules) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)modulePackaging, (String)"modulePackaging");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(log, basedir, android, enableExperimentalRules);
        this.modulePackaging = modulePackaging;
        this.sources = sources;
        this.charset = charset;
        this.formattedFileCount = new AtomicInteger();
    }

    /*
     * WARNING - void declaration
     */
    public final void invoke() {
        boolean bl = false;
        Set checkedFiles = new LinkedHashSet();
        for (Sources sources : this.sources) {
            boolean isIncluded = sources.component1();
            Set<File> sourceRoots = sources.component2();
            String[] includes = sources.component3();
            Set<String> excludes = sources.component4();
            if (!isIncluded) {
                this.getLog().debug((CharSequence)Intrinsics.stringPlus((String)"Source roots not included: ", sourceRoots));
                continue;
            }
            for (File sourceRoot : sourceRoots) {
                void $this$mapTo$iv$iv;
                String[] excludesArray;
                String[] stringArray;
                String[] stringArray2;
                String[] stringArray3;
                String[] stringArray4;
                if (!sourceRoot.exists()) {
                    String msg = Intrinsics.stringPlus((String)"Source root doesn't exist: ", (Object)FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir()));
                    if (Intrinsics.areEqual((Object)this.modulePackaging, (Object)"pom")) {
                        this.getLog().debug((CharSequence)msg);
                        continue;
                    }
                    this.getLog().warn((CharSequence)msg);
                    continue;
                }
                if (!sourceRoot.isDirectory()) {
                    throw new MojoFailureException(Intrinsics.stringPlus((String)"Source root is not a directory: ", (Object)FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir())));
                }
                String[] stringArray5 = includes;
                boolean bl2 = false;
                boolean bl3 = false;
                String[] p0 = stringArray5;
                boolean bl4 = false;
                Object object = stringArray4 = !p0.isEmpty() ? stringArray5 : null;
                if (stringArray4 == null) {
                    stringArray3 = null;
                } else {
                    Collection $this$toTypedArray$iv = (Collection)stringArray4;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray6 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    stringArray3 = stringArray2 = stringArray6;
                }
                if (stringArray2 == null) {
                    stringArray4 = new String[]{"**/*.kt"};
                    stringArray = stringArray4;
                } else {
                    stringArray = stringArray2;
                }
                String[] includesArray = stringArray;
                Collection $this$toTypedArray$iv = excludes;
                boolean $i$f$toTypedArray22 = false;
                Collection thisCollection$iv322 = $this$toTypedArray$iv;
                if (thisCollection$iv322.toArray(new String[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] $i$f$toTypedArray22 = new DirectoryScanner();
                boolean thisCollection$iv322 = false;
                boolean thisCollection$iv = false;
                Object[] $this$invoke_u24lambda_u2d0 = $i$f$toTypedArray22;
                boolean bl5 = false;
                $this$invoke_u24lambda_u2d0.setIncludes(Arrays.copyOf(includesArray, includesArray.length));
                $this$invoke_u24lambda_u2d0.setExcludes(Arrays.copyOf(excludesArray, excludesArray.length));
                $this$invoke_u24lambda_u2d0.setBasedir(sourceRoot);
                $this$invoke_u24lambda_u2d0.setCaseSensitive(true);
                Object[] ds = $i$f$toTypedArray22;
                ds.scan();
                String[] thisCollection$iv322 = ds.getIncludedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)thisCollection$iv322, (String)"ds.includedFiles");
                Object[] $this$map$iv = thisCollection$iv322;
                boolean $i$f$map = false;
                $this$invoke_u24lambda_u2d0 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    File file = new File(sourceRoot, (String)it);
                    collection.add(file);
                }
                List sourceFiles = (List)destination$iv$iv;
                Iterable $this$forEach$iv = sourceFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl7 = false;
                    File file2 = file.getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.canonicalFile");
                    if (!checkedFiles.add(file2)) continue;
                    String relativePath = FilesKt.toRelativeString((File)file, (File)this.getBasedir());
                    this.getLog().debug((CharSequence)Intrinsics.stringPlus((String)"checking format: ", (Object)relativePath));
                    Map userData = MapsKt.mapOf((Pair)TuplesKt.to((Object)"android", (Object)String.valueOf(this.getAndroid())));
                    String sourceText = FilesKt.readText((File)file, (Charset)this.charset);
                    String formattedText2 = this.formatFile(relativePath, sourceText, this.getRuleSets(), userData, (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(relativePath, this){
                        final /* synthetic */ String $relativePath;
                        final /* synthetic */ Format this$0;
                        {
                            this.$relativePath = $relativePath;
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final void invoke(@NotNull LintError $dstr$line$col$_u24__u24$detail, boolean corrected) {
                            Intrinsics.checkNotNullParameter((Object)$dstr$line$col$_u24__u24$detail, (String)"$dstr$line$col$_u24__u24$detail");
                            int line = $dstr$line$col$_u24__u24$detail.component1();
                            int col = $dstr$line$col$_u24__u24$detail.component2();
                            String detail = $dstr$line$col$_u24__u24$detail.component4();
                            String lintError = this.$relativePath + ':' + line + ':' + col + ": " + detail;
                            this.this$0.getLog().debug((CharSequence)("Format " + (corrected ? "fixed" : "could not fix") + " > " + lintError));
                        }
                    }), this.getEditorConfigPath(file));
                    if (formattedText2 == sourceText) continue;
                    this.getLog().debug((CharSequence)Intrinsics.stringPlus((String)"Format fixed > ", (Object)relativePath));
                    FilesKt.writeText((File)file, (String)formattedText2, (Charset)this.charset);
                    this.formattedFileCount.incrementAndGet();
                }
            }
        }
        this.getLog().info((CharSequence)(this.formattedFileCount.get() + " file(s) formatted."));
    }

    private final String formatFile(String fileName, String sourceText, List<? extends RuleSet> ruleSets2, Map<String, String> userData, Function2<? super LintError, ? super Boolean, Unit> onError, String editorConfigPath) {
        boolean bl = !StringsKt.endsWith((String)fileName, (String)".kt", (boolean)true);
        return KtLint.INSTANCE.format(new KtLint.Params(fileName, sourceText, (Iterable)ruleSets2, userData, onError, bl, editorConfigPath, false, 128, null));
    }
}

