/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.value.Value;

public class PageDataLeaf
extends PageData {
    private final boolean optimizeUpdate;
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start;
    private int overflowRowSize;
    private int columnCount;
    private int memoryData;
    private boolean writtenData;

    private PageDataLeaf(PageDataIndex pageDataIndex, int n, Data data) {
        super(pageDataIndex, n, data);
        this.optimizeUpdate = pageDataIndex.getDatabase().getSettings().optimizeUpdate;
    }

    static PageDataLeaf create(PageDataIndex pageDataIndex, int n, int n2) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, pageDataIndex.getPageStore().createData());
        pageDataIndex.getPageStore().logUndo(pageDataLeaf, null);
        pageDataLeaf.rows = Row.EMPTY_ARRAY;
        pageDataLeaf.parentPageId = n2;
        pageDataLeaf.columnCount = pageDataIndex.getTable().getColumns().length;
        pageDataLeaf.writeHead();
        pageDataLeaf.start = pageDataLeaf.data.length();
        return pageDataLeaf;
    }

    public static Page read(PageDataIndex pageDataIndex, Data data, int n) {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageDataIndex, n, data);
        pageDataLeaf.read();
        return pageDataLeaf;
    }

    private void read() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int n = this.data.readVarInt();
        if (n != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n + " type:" + by);
        }
        this.columnCount = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (by == 1) {
            if (this.entryCount != 1) {
                DbException.throwInternalError("entries: " + this.entryCount);
            }
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readVarLong();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.writtenData = true;
    }

    private int getRowLength(Row row) {
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            n += this.data.getValueLen(row.getValue(i));
        }
        return n;
    }

    private int findInsertionPoint(long l) {
        int n = this.find(l);
        if (n < this.entryCount && this.keys[n] == l) {
            throw this.index.getDuplicateKeyException("" + l);
        }
        return n;
    }

    @Override
    int addRowTry(Row row) {
        int n;
        int n2;
        int n3;
        int n4;
        this.index.getPageStore().logUndo(this, this.data);
        int n5 = this.getRowLength(row);
        int n6 = this.index.getPageStore().getPageSize();
        int n7 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
        int n8 = 2 + Data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && n7 - n5 < this.start + n8) {
            int n9 = this.findInsertionPoint(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return n9 < 2 ? 1 : (n9 > this.entryCount - 1 ? this.entryCount - 1 : n9);
                }
                int n10 = this.entryCount / 3;
                return n9 < n10 ? n10 : (n9 >= 2 * n10 ? 2 * n10 : n9);
            }
            return n9;
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 0) {
            n4 = 0;
        } else {
            if (!this.optimizeUpdate) {
                this.readAllRows();
            }
            n4 = this.findInsertionPoint(row.getKey());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        n7 = n4 == 0 ? n6 : this.offsets[n4 - 1];
        int n11 = n7 - n5;
        this.start += n8;
        this.offsets = PageDataLeaf.insert(this.offsets, this.entryCount, n4, n11);
        PageDataLeaf.add(this.offsets, n4 + 1, this.entryCount + 1, -n5);
        this.keys = PageDataLeaf.insert(this.keys, this.entryCount, n4, row.getKey());
        this.rows = PageDataLeaf.insert(this.rows, this.entryCount, n4, row);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        if (this.optimizeUpdate && this.writtenData && n11 >= this.start) {
            byte[] byArray = this.data.getBytes();
            n3 = this.offsets[this.entryCount - 1] + n5;
            n2 = this.offsets[n4];
            System.arraycopy(byArray, n3, byArray, n3 - n5, n2 - n3 + n5);
            this.data.setPos(n2);
            for (n = 0; n < this.columnCount; ++n) {
                this.data.writeValue(row.getValue(n));
            }
        }
        if (n11 < this.start) {
            int n12;
            this.writtenData = false;
            if (this.entryCount > 1) {
                DbException.throwInternalError("" + this.entryCount);
            }
            this.start += 4;
            int n13 = n5 - (n6 - this.start);
            this.offsets[n4] = n11 = this.start;
            n3 = this.getPos();
            n2 = n6;
            this.firstOverflowPageId = n = this.index.getPageStore().allocatePage();
            this.overflowRowSize = n6 + n5;
            this.writeData();
            Row row2 = this.rows[0];
            this.rowRef = new SoftReference<Row>(row2);
            this.rows[0] = null;
            Data data = this.index.getPageStore().createData();
            data.checkCapacity(this.data.length());
            data.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int n14;
                int n15;
                if (n13 <= n6 - 9) {
                    n15 = 19;
                    n12 = n13;
                    n14 = 0;
                } else {
                    n15 = 3;
                    n12 = n6 - 11;
                    n14 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = PageDataOverflow.create(this.index.getPageStore(), n, n15, n3, n14, data, n2, n12);
                this.index.getPageStore().update(pageDataOverflow);
                n2 += n12;
                n3 = n;
                n = n14;
            } while ((n13 -= n12) > 0);
        }
        if (this.rowRef == null) {
            this.memoryChange(true, row);
        } else {
            this.memoryChange(true, null);
        }
        return -1;
    }

    private void removeRow(int n) {
        Row row;
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        if ((row = this.getRowAt(n)) != null) {
            this.memoryChange(false, row);
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            DbException.throwInternalError("" + this.entryCount);
        }
        if (this.firstOverflowPageId != 0) {
            this.start -= 4;
            this.freeOverflow();
            this.firstOverflowPageId = 0;
            this.overflowRowSize = 0;
            this.rowRef = null;
        }
        int n2 = 2 + Data.getVarLongLen(this.keys[n]);
        int n3 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n4 = n3 - this.offsets[n];
        if (this.optimizeUpdate) {
            if (this.writtenData) {
                byte[] byArray = this.data.getBytes();
                int n5 = this.offsets[this.entryCount];
                System.arraycopy(byArray, n5, byArray, n5 + n4, this.offsets[n] - n5);
                Arrays.fill(byArray, n5, n5 + n4, (byte)0);
            }
        } else {
            int n6 = this.offsets[this.entryCount];
            Arrays.fill(this.data.getBytes(), n6, n6 + n4, (byte)0);
        }
        this.start -= n2;
        this.offsets = PageDataLeaf.remove(this.offsets, this.entryCount + 1, n);
        PageDataLeaf.add(this.offsets, n, this.entryCount, n4);
        this.keys = PageDataLeaf.remove(this.keys, this.entryCount + 1, n);
        this.rows = PageDataLeaf.remove(this.rows, this.entryCount + 1, n);
    }

    @Override
    Cursor find(Session session, long l, long l2, boolean bl) {
        int n = this.find(l);
        return new PageDataCursor(session, this, n, l2, bl);
    }

    Row getRowAt(int n) {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId == 0) {
                row = this.readRow(this.data, this.offsets[n], this.columnCount);
            } else {
                PageDataOverflow pageDataOverflow;
                if (this.rowRef != null && (row = this.rowRef.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                Data data = pageStore.createData();
                int n2 = pageStore.getPageSize();
                int n3 = this.offsets[n];
                data.write(this.data.getBytes(), n3, n2 - n3);
                int n4 = this.firstOverflowPageId;
                while ((n4 = (pageDataOverflow = this.index.getPageOverflow(n4)).readInto(data)) != 0) {
                }
                this.overflowRowSize = n2 + data.length();
                row = this.readRow(data, 0, this.columnCount);
            }
            row.setKey(this.keys[n]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(row);
            } else {
                this.rows[n] = row;
                this.memoryChange(true, row);
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    @Override
    PageData split(int n) {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n2, this.parentPageId);
        while (n < this.entryCount) {
            int n3 = pageDataLeaf.addRowTry(this.getRowAt(n));
            if (n3 != -1) {
                DbException.throwInternalError("split " + n3);
            }
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    @Override
    long getLastKey() {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        return this;
    }

    @Override
    protected void remapChildren(int n) {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.firstOverflowPageId);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(pageDataOverflow);
    }

    @Override
    boolean remove(long l) {
        int n = this.find(l);
        if (this.keys == null || this.keys[n] != l) {
            throw DbException.get(90112, this.index.getSQL() + ": " + l + " " + (this.keys == null ? -1L : this.keys[n]));
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeRecursive();
            return true;
        }
        this.removeRow(n);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        this.freeOverflow();
    }

    private void freeOverflow() {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow pageDataOverflow;
            int n = this.firstOverflowPageId;
            do {
                pageDataOverflow = this.index.getPageOverflow(n);
                pageDataOverflow.free();
            } while ((n = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    @Override
    Row getRowWithKey(long l) {
        int n = this.find(l);
        return this.getRowAt(n);
    }

    @Override
    int getRowCount() {
        return this.entryCount;
    }

    @Override
    void setRowCountStored(int n) {
    }

    @Override
    long getDiskSpaceUsed() {
        return this.index.getPageStore().getPageSize();
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRowAt(i);
        }
    }

    private void writeHead() {
        this.data.reset();
        int n = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.columnCount);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n;
        if (this.written) {
            return;
        }
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.writeHead();
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
            this.data.checkCapacity(this.overflowRowSize);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeVarLong(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        if (!this.writtenData || !this.optimizeUpdate) {
            for (n = 0; n < this.entryCount; ++n) {
                this.data.setPos(this.offsets[n]);
                Row row = this.getRowAt(n);
                for (int i = 0; i < this.columnCount; ++i) {
                    this.data.writeValue(row.getValue(i));
                }
            }
            this.writtenData = true;
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " " + this.index.getTable().getName() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.offsets);
    }

    @Override
    public void moveTo(Session session, int n) {
        PageStore pageStore = this.index.getPageStore();
        if (this.parentPageId != 0) {
            pageStore.getPage(this.parentPageId);
        }
        pageStore.logUndo(this, this.data);
        PageDataLeaf pageDataLeaf = PageDataLeaf.create(this.index, n, this.parentPageId);
        this.readAllRows();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.overflowRowSize = this.overflowRowSize;
        pageDataLeaf.firstOverflowPageId = this.firstOverflowPageId;
        pageDataLeaf.rowRef = this.rowRef;
        pageDataLeaf.rows = this.rows;
        if (this.firstOverflowPageId != 0) {
            pageDataLeaf.rows[0] = this.getRowAt(0);
        }
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.offsets = this.offsets;
        pageDataLeaf.start = this.start;
        pageDataLeaf.remapChildren(this.getPos());
        pageDataLeaf.writeData();
        pageDataLeaf.data.truncate(this.index.getPageStore().getPageSize());
        pageStore.update(pageDataLeaf);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n);
        }
        pageStore.free(this.getPos());
    }

    void setOverflow(int n, int n2) {
        if (SysProperties.CHECK && n != this.firstOverflowPageId) {
            DbException.throwInternalError("move " + this + " " + this.firstOverflowPageId);
        }
        this.index.getPageStore().logUndo(this, this.data);
        this.firstOverflowPageId = n2;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.writeHead();
            this.data.writeInt(this.firstOverflowPageId);
        }
        this.index.getPageStore().update(this);
    }

    private void memoryChange(boolean bl, Row row) {
        int n = row == null ? 0 : 20 + row.getMemory();
        this.memoryData += bl ? n : -n;
        this.index.memoryChange(240 + this.memoryData + this.index.getPageStore().getPageSize() >> 2);
    }

    @Override
    public boolean isStream() {
        return this.firstOverflowPageId > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row readRow(Data data, int n, int n2) {
        Value[] valueArray = new Value[n2];
        Data data2 = data;
        synchronized (data2) {
            data.setPos(n);
            for (int i = 0; i < n2; ++i) {
                valueArray[i] = data.readValue();
            }
        }
        return this.index.getDatabase().createRow(valueArray, -1);
    }
}

