/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.ProductLimitsRequest;
import com.itextpdf.licensing.base.reporting.ProductLimitsResponse;
import com.itextpdf.licensing.base.reporting.serverstatus.HealthCheckHolder;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.reporting.volume.ProductUsage;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataAggregator;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.kinesis.KinesisDataSender;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AwsLicenseServer
implements ILicenseServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsLicenseServer.class);
    private static final String AWS_API_LEFT_LIMITS_HOST = "sdk-requests.licensing.itextpdf.com";
    private static final String AWS_API_LEFT_LIMITS_PATH = "/v1/volume/limits-left";
    private static final String AWS_KINESIS_STREAM_NAME = "VolumeUsages";
    private static final int AWS_RECORD_MAX_SIZE = 0x100000;
    private static AwsLicenseServer instance;
    private final ApiGatewayClient leftLimitsRequestClient = AwsResourcesCreator.createApiGatewayClientWithAuth("sdk-requests.licensing.itextpdf.com", "/v1/volume/limits-left");
    private KinesisDataSender kinesisDataSender;

    private AwsLicenseServer() {
    }

    static AwsLicenseServer getInstance() {
        if (instance == null) {
            String healthCheckTime = VolumeDataAggregator.getCurrentTimeForSendUsage();
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Creating AwsLicenseServer, health check time: {0}", (Object[])new Object[]{healthCheckTime});
            instance = AwsLicenseServer.createInstanceWithHealthCheck(VolumeDataAggregator.createHealthCheckUsage(healthCheckTime));
        }
        return instance;
    }

    static void resetInstance() {
        instance = null;
    }

    @Override
    public boolean write(List<ProductUsage> usageList) {
        if (this.kinesisDataSender == null) {
            this.kinesisDataSender = AwsResourcesCreator.createKinesisDataSender(0x100000, AWS_KINESIS_STREAM_NAME);
        }
        String usageArrayStr = JsonMapperUtil.serializeToMinimalString(usageList);
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to write volume usage: {0}", (Object[])new Object[]{usageArrayStr});
        if (usageArrayStr != null) {
            byte[] recordBytes = usageArrayStr.getBytes(StandardCharsets.UTF_8);
            return this.kinesisDataSender.sendRecord(recordBytes);
        }
        return false;
    }

    @Override
    public List<ProductLimitsResponse> getRemainingEvents(List<ProductLimitsRequest> requestList) {
        String jsonRequestBody = JsonMapperUtil.serializeToMinimalString(requestList);
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to get remaining events: {0}", (Object[])new Object[]{jsonRequestBody});
        ApiGatewayResponse response = this.leftLimitsRequestClient.makePostRequest(jsonRequestBody);
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to get remaining events response: {0},\nstatus: {1}", (Object[])new Object[]{response.getBody(), response.getStatus()});
        if (response.getStatus() != 200 || response.getBody() == null) {
            throw new LicenseKeyException("Exception during http request execution.");
        }
        return Arrays.asList(JsonMapperUtil.deserializeProductLimitsResponseListFromString(response.getBody()));
    }

    @Override
    public LicenseServerHealthStatus healthCheck() {
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to perform health check request", (Object[])new Object[0]);
        LicenseServerHealthStatus status = HealthCheckHolder.getInstance().healthCheck();
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Health check result: {0}", (Object[])new Object[]{status.name()});
        return status;
    }

    static AwsLicenseServer createInstanceWithHealthCheck(List<ProductUsage> healthCheckUsage) {
        boolean isHealthy;
        AwsLicenseServer localInstance = new AwsLicenseServer();
        try {
            isHealthy = localInstance.write(healthCheckUsage);
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Health check write result: {0}", (Object[])new Object[]{isHealthy});
        }
        catch (NoClassDefFoundError ex) {
            throw ex;
        }
        catch (Exception ignore) {
            isHealthy = false;
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Health check ignored exception: {0}", (Exception)ignore, (Object[])new Object[]{ignore.getMessage()});
        }
        if (isHealthy || localInstance.healthCheck() == LicenseServerHealthStatus.UNHEALTHY_ON_SERVER_SIDE) {
            return localInstance;
        }
        throw new LicenseKeyException("Cannot send data to remote reporting server");
    }
}

