/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.itextpdf.commons.utils.MapUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ProductLimitsResponse {
    @JsonProperty(value="licenseKey")
    private final String licenseKey;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="leftLimits")
    private final Map<String, Long> leftLimits;

    public ProductLimitsResponse(@JsonProperty(value="licenseKey") String licenseKey, @JsonProperty(value="productName") String productName, @JsonProperty(value="leftLimits") Map<String, Long> leftLimits) {
        if (licenseKey == null) {
            throw new IllegalArgumentException("License file key can not be null.");
        }
        this.licenseKey = licenseKey;
        if (productName == null) {
            throw new IllegalArgumentException("Product name can not be null.");
        }
        this.productName = productName;
        if (leftLimits == null) {
            throw new IllegalArgumentException("Left limits can not be null.");
        }
        this.leftLimits = new LinkedHashMap<String, Long>();
        for (Map.Entry<String, Long> entry : leftLimits.entrySet()) {
            this.leftLimits.put(entry.getKey(), entry.getValue());
        }
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getProductName() {
        return this.productName;
    }

    public Map<String, Long> getLeftLimits() {
        return Collections.unmodifiableMap(this.leftLimits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductLimitsResponse response = (ProductLimitsResponse)o;
        return Objects.equals(this.licenseKey, response.licenseKey) && Objects.equals(this.productName, response.productName) && MapUtil.equals(this.leftLimits, response.leftLimits);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.licenseKey, this.productName);
        return hashCode * 31 + (this.leftLimits == null ? 0 : MapUtil.getHashCode(this.leftLimits));
    }
}

