/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.tool.xml.xtra.xfa.element.BarcodeDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.IContentTextElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.UiElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.io.IOException;
import java.util.ArrayList;

public class BarcodeElement
extends UiElement {
    protected XFARectangle barcodeTextRectangle;
    protected String textLocation = "below";
    BarcodeDrawer barcodeDrawer;
    private final float TEXT_WIDTH_ADDITION = 5.0f;

    public BarcodeElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement) {
        super(elementTag, elementRec, document, contentElement);
        String textLocationAttr;
        if (this.attributes != null && (textLocationAttr = (String)this.attributes.get("textLocation")) != null && textLocationAttr.length() > 0) {
            this.textLocation = textLocationAttr.toLowerCase();
        }
        String code = "";
        if (contentElement instanceof IContentTextElement) {
            IContentTextElement textElement = (IContentTextElement)((Object)contentElement);
            ArrayList<Element> content = textElement.getContent();
            for (Element el : content) {
                if (!(el instanceof Paragraph)) continue;
                Paragraph p = (Paragraph)el;
                code = code + p.getContent();
                p.setAlignment(1);
            }
        }
        this.barcodeDrawer = new BarcodeDrawer(this.attributes, code, elementRec.getWidth());
        if (!this.barcodeDrawer.isEmpty()) {
            Float barcodeHeight;
            this.barcodeDrawer.setAccessibleAttribute(PdfName.ALT, new PdfString("Bar code " + code));
            this.barcodeTextRectangle = elementRec.clone();
            this.barcodeTextRectangle.setLlx(Float.valueOf(this.barcodeTextRectangle.getLlx().floatValue() - 2.5f));
            this.barcodeTextRectangle.setWidth(Float.valueOf(this.barcodeDrawer.getBarcodeWidth() + 5.0f));
            if (contentElement != null) {
                this.barcodeTextRectangle.setHeight(Float.valueOf(((IContentTextElement)((Object)contentElement)).getTextDrawer().getFlattenerContext().getFont(elementTag.retrieveParent().retrieveParent(), "Identity-H").getSize()));
                if (this.textLocation.equalsIgnoreCase("below") || this.textLocation.equalsIgnoreCase("belowEmbedded")) {
                    ((IContentTextElement)((Object)contentElement)).getTextDrawer().setVerticalAlignment(2);
                    this.barcodeTextRectangle.setUry(Float.valueOf(elementRec.getUry().floatValue() - elementRec.getHeight().floatValue() + this.barcodeTextRectangle.getHeight().floatValue()));
                } else if (this.textLocation.equalsIgnoreCase("above") || this.textLocation.equalsIgnoreCase("aboveEmbedded")) {
                    ((IContentTextElement)((Object)contentElement)).getTextDrawer().setVerticalAlignment(0);
                }
                this.applyMargins(this.barcodeTextRectangle);
                ((IContentTextElement)((Object)contentElement)).createColumnText(this.barcodeTextRectangle);
                this.unapplyMargins(this.barcodeTextRectangle);
            }
            if ((barcodeHeight = elementRec.getHeight()) == null) {
                barcodeHeight = Float.valueOf(this.barcodeTextRectangle.getHeight().floatValue() * 3.0f);
            }
            if (contentElement != null && this.barcodeDrawer.barcodeHasTextOnIt() && (this.textLocation.equalsIgnoreCase("below") || this.textLocation.equalsIgnoreCase("above"))) {
                barcodeHeight = Float.valueOf(barcodeHeight.floatValue() - 1.5f * ((IContentTextElement)((Object)contentElement)).getTextRectangle().getHeight().floatValue());
            }
            this.barcodeDrawer.setBarHeight(barcodeHeight.floatValue());
        } else {
            this.barcodeDrawer = null;
        }
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        if (canvas != null && this.barcodeDrawer != null && !this.barcodeDrawer.isEmpty()) {
            if (this.contentElement != null && !this.textLocation.equalsIgnoreCase("none") && this.barcodeDrawer.barcodeHasTextOnIt()) {
                this.contentElement.draw(canvas, parentBoundingBox);
                canvas.saveState();
                XFARectangle actualElementRect = this.elementRec.clone();
                actualElementRect.setLlx(Float.valueOf(actualElementRect.getLlx().floatValue() - 2.5f));
                actualElementRect.setWidth(Float.valueOf(this.barcodeDrawer.getBarcodeWidth() + 5.0f));
                Rectangle rect = actualElementRect.toRectangle();
                rect.setBottom(rect.getBottom());
                canvas.rectangle(rect.getLeft(), rect.getBottom(), rect.getWidth(), rect.getHeight());
                Rectangle textRect = ((IContentTextElement)((Object)this.contentElement)).getTextRectangle().toRectangle();
                if (this.textLocation.equalsIgnoreCase("aboveEmbedded") || this.textLocation.equalsIgnoreCase("belowEmbedded")) {
                    float diffWidth = rect.getWidth() - textRect.getWidth();
                    textRect.setLeft(textRect.getLeft() + diffWidth / 2.0f);
                    textRect.setRight(textRect.getRight() + diffWidth / 2.0f);
                } else {
                    textRect.setLeft(rect.getLeft() - 5.0f);
                    textRect.setRight(rect.getRight() + 5.0f);
                }
                canvas.rectangle(textRect.getLeft(), textRect.getBottom(), textRect.getWidth(), textRect.getHeight());
                canvas.eoClip();
                canvas.newPath();
            } else {
                canvas.saveState();
            }
            float translateY = this.elementRec.getUry().floatValue() - this.elementRec.getHeight().floatValue();
            if (this.contentElement != null && this.barcodeDrawer.barcodeHasTextOnIt() && this.textLocation.equalsIgnoreCase("below")) {
                translateY += 1.5f * ((IContentTextElement)((Object)this.contentElement)).getTextRectangle().getHeight().floatValue();
            }
            canvas.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, this.elementRec.getLlx().floatValue(), translateY));
            if (!this.barcodeDrawer.barcodeHasTextOnIt()) {
                canvas.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (this.elementRec.getWidth().floatValue() - this.barcodeDrawer.getBarcodeWidth()) / 2.0f, (this.elementRec.getHeight().floatValue() - this.barcodeDrawer.getBarcodeHeight()) / 2.0f));
            }
            this.barcodeDrawer.draw(canvas, parentBoundingBox);
            canvas.restoreState();
        }
        return PositionResult.State.FULL_CONTENT;
    }

    @Override
    protected boolean isTextWidget() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.barcodeDrawer == null || this.barcodeDrawer.isEmpty();
    }

    @Override
    public boolean isTagged() {
        return !this.isEmpty() && this.barcodeDrawer.getRole() != PdfName.ARTIFACT;
    }
}

