/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPipeline
extends AbstractPipeline<FlattenerContext> {
    static final Logger logger = LoggerFactory.getLogger(PdfPipeline.class);
    protected final FlattenerContext flattenerContext;

    public PdfPipeline(Pipeline<?> next, FlattenerContext flattenerContext) {
        super(next);
        this.flattenerContext = flattenerContext;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        context.put(this.getContextKey(), this.flattenerContext);
        return super.init(context);
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        return super.open(context, t, po);
    }

    @Override
    public Pipeline<?> content(WorkerContext ctx, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        try {
            if ("chunk".equalsIgnoreCase(currentTag.getName()) && currentTag.getParent() != null && "document".equalsIgnoreCase(currentTag.getParent().getName())) {
                ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64.decode(text));
                this.flattenerContext.setReader(new PdfReader(arrayInputStream));
            }
        }
        catch (IOException ioexc) {
            if (logger.isErrorEnabled()) {
                logger.error("", (Throwable)ioexc);
            }
            throw new PipelineException(ioexc);
        }
        return super.content(ctx, currentTag, text, po);
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        return super.close(context, t, po);
    }
}

