/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.CustomSpanAttributeSender;
import com.newrelic.agent.bridge.NoOpDistributedTracePayload;
import com.newrelic.agent.bridge.Span;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.SpanCategory;
import com.newrelic.agent.service.analytics.SpanEvent;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.tracing.SpanProxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class SpanImpl
implements Span {
    private static final String applicationId = ServiceFactory.getDistributedTraceService().getApplicationId();
    private final String appName;
    private final String guid;
    private final AtomicReference<Float> priority;
    private final SpanCategory category;
    private final boolean sampled;
    private final Map<String, Object> userAttributes;
    private final Map<String, Object> agentAttributes;
    private final AttributeSender attributeSender = new CustomSpanAttributeSender(this);
    private final AtomicReference<Boolean> finished = new AtomicReference<Boolean>(false);
    private final AtomicReference<SpanProxy> spanProxy = new AtomicReference<SpanProxy>(new SpanProxy());
    private volatile String name;
    private volatile long timestamp;
    private volatile String traceId;
    private volatile long duration;
    private volatile ExternalParameters externalParameters;

    public SpanImpl(String name) {
        this.appName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        this.guid = TransactionGuidFactory.generateGuid();
        this.timestamp = System.currentTimeMillis();
        this.name = name;
        this.category = SpanCategory.generic;
        this.traceId = this.guid;
        this.priority = DistributedTraceUtil.getPriority();
        this.sampled = DistributedTraceUtil.isSampledPriority(this.priority.get().floatValue());
        this.userAttributes = new LazyMapImpl<String, Object>(new MapMaker().initialCapacity(8).concurrencyLevel(4));
        this.agentAttributes = new LazyMapImpl<String, Object>(new MapMaker().initialCapacity(8).concurrencyLevel(4));
    }

    public Span reportAsExternal(ExternalParameters externalParameters) {
        this.externalParameters = externalParameters;
        return this;
    }

    public DistributedTracePayload createDistributedTracePayload() {
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isEnabled()) {
            this.spanProxy.get().setTimestamp(this.timestamp);
            DistributedTracePayloadImpl payload = (DistributedTracePayloadImpl)this.spanProxy.get().createDistributedTracePayload(this.traceId, this.priority.get(), this.guid, null);
            if (payload != null && payload.priority != null) {
                this.priority.set(payload.priority);
            }
            return payload == null ? NoOpDistributedTracePayload.INSTANCE : payload;
        }
        return NoOpDistributedTracePayload.INSTANCE;
    }

    public boolean acceptDistributedTracePayload(String payload) {
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isEnabled()) {
            this.spanProxy.get().setTimestamp(this.timestamp);
            boolean accept = this.spanProxy.get().acceptDistributedTracePayload(payload);
            if (accept) {
                this.traceId = this.spanProxy.get().getInboundDistributedTracePayload().traceId;
                this.priority.set(this.spanProxy.get().getInboundDistributedTracePayload().priority);
            }
            return accept;
        }
        Agent.LOG.log(Level.FINE, "Not accepting payload, distributed tracing disabled");
        return false;
    }

    public boolean acceptDistributedTracePayload(DistributedTracePayload payload) {
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isEnabled()) {
            this.spanProxy.get().setTimestamp(this.timestamp);
            boolean accept = this.spanProxy.get().acceptDistributedTracePayload(payload);
            if (accept) {
                this.traceId = this.spanProxy.get().getInboundDistributedTracePayload().traceId;
                this.priority.set(this.spanProxy.get().getInboundDistributedTracePayload().priority);
            }
            return accept;
        }
        Agent.LOG.log(Level.FINE, "Not accepting payload, distributed tracing disabled");
        return false;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.guid;
    }

    public boolean isSampled() {
        return this.sampled;
    }

    public Span addCustomParameter(String key, String value) {
        this.attributeSender.addAttribute(key, value, "Span.addCustomParameter");
        return this;
    }

    public Span addCustomParameter(String key, Number value) {
        this.attributeSender.addAttribute(key, value, "Span.addCustomParameter");
        return this;
    }

    public Span addCustomParameter(String key, Boolean value) {
        this.attributeSender.addAttribute(key, value, "Span.addCustomParameter");
        return this;
    }

    public Span addCustomParameters(Map<String, Object> params) {
        this.attributeSender.addAttributes(params, "Span.addCustomParameters");
        return this;
    }

    public Span setName(String name) {
        this.name = name;
        return this;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp >= 0L) {
            this.timestamp = timestamp;
        } else if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.log(Level.FINEST, "Invalid timestamp: {0} set for span: {1}. Using existing timestamp: {2}.", timestamp, this, this.timestamp);
        }
    }

    public void finish() {
        this.finish(System.currentTimeMillis());
    }

    public void finish(long finishMillis) {
        if (this.finished.compareAndSet(false, true)) {
            this.duration = finishMillis - this.timestamp;
            SpanEvent.SpanEventBuilder builder = SpanEvent.builder().setName(this.name).setTraceId(this.traceId).setTimestamp(this.timestamp).setGuid(this.guid).setAppName(this.appName).setDurationInSeconds((float)this.duration / 1000.0f).setCategory(this.category).setExternalParameterAttributes(this.externalParameters).setUserAttributes(this.userAttributes).setAgentAttributes(this.agentAttributes);
            DistributedTracePayloadImpl payload = this.spanProxy.get().getInboundDistributedTracePayload();
            if (payload == null) {
                builder.setSampled(this.sampled).setParentId(null).setPriority(this.priority.get().floatValue()).setIsRootSpanEvent(true).setDecider(true);
            } else {
                builder.setSampled(payload.sampled).setParentId(payload.guid).setPriority(payload.priority.floatValue()).setIsRootSpanEvent(!payload.applicationId.equals(applicationId));
            }
            ServiceFactory.getServiceManager().getSpanEventsService().storeEvent(builder.build());
        }
    }

    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    public long getStartTime() {
        return this.timestamp;
    }

    public String toString() {
        return "SpanImpl{guid='" + this.guid + '\'' + ", name='" + this.name + '\'' + ", traceId='" + this.traceId + '\'' + '}';
    }
}

