/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Map;
import java.util.logging.Level;

public class CustomAttributeSender
extends AttributeSender {
    protected static String ATTRIBUTE_TYPE = "custom";

    @Override
    protected String getAttributeType() {
        return ATTRIBUTE_TYPE;
    }

    @Override
    protected Map<String, Object> getAttributeMap() throws Throwable {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null && ServiceFactory.getConfigService().getDefaultAgentConfig().isCustomParametersAllowed()) {
            return currentTxn.getUserAttributes();
        }
        return null;
    }

    @Override
    public <T> T verifyParameterAndReturnValue(String key, T value, String methodCalled) {
        try {
            Transaction currentTxn = Transaction.getTransaction(false);
            if (currentTxn != null && currentTxn.getAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute when {1} was invoked with key \"{2}\" while in high security mode.", this.getAttributeType(), methodCalled, key);
                return null;
            }
            if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isCustomParametersAllowed()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute when {1} was invoked with key \"{2}\" while lasp custom_parameters disabled.", this.getAttributeType(), methodCalled, key);
                return null;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Unable to verify attribute. Exception thrown while verifying security policies", t);
            return null;
        }
        return super.verifyParameterAndReturnValue(key, value, methodCalled);
    }

    @Override
    protected void addCustomAttributeImpl(String key, Object value, String methodName) {
        try {
            Transaction tx = Transaction.getTransaction(false);
            if (tx == null) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute for key \"{1}\" because there is no transaction.", this.getAttributeType(), key);
                return;
            }
            Map<String, Object> attributeMap = this.getAttributeMap();
            if (attributeMap != null && attributeMap.size() >= tx.getAgentConfig().getMaxUserParameters()) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute for key \"{1}\" because the limit is {2}.", this.getAttributeType(), key, tx.getAgentConfig().getMaxUserParameters());
                return;
            }
            super.addCustomAttributeImpl(key, value, methodName);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Exception adding {0} parameter for key: \"{1}\": {2}", this.getAttributeType(), key, t);
        }
    }
}

