/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.ExtensionParsers;
import com.newrelic.agent.extension.ExtensionRewriter;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.bootstrap.BootstrapAgent;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class JarExtension {
    private final ClassLoader classloader;
    private final File file;
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarExtension create(IAgentLogger logger, ExtensionParsers extensionParsers, File file) throws IOException {
        String agentClass;
        JarFile jar = new JarFile(file);
        URLClassLoader jarClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, AgentBridge.getAgent().getClass().getClassLoader());
        try {
            agentClass = JarExtension.getAgentClass(jar.getManifest());
            if (null != agentClass) {
                logger.log(Level.FINE, "Detected agentmain class {0} in {1}", agentClass, file.getAbsolutePath());
                if (BootstrapAgent.class.getName().equals(agentClass)) {
                    throw new IOException("Attempt to load the New Relic agent from the extentions directory.  Remove " + file.getName() + " from directory " + file.getParent());
                }
                byte[] newBytes = ExtensionRewriter.rewrite(jar, jarClassLoader);
                if (null != newBytes) {
                    JarExtension.validateJar(newBytes);
                    file = JarExtension.writeTempJar(logger, file, newBytes);
                }
            }
        }
        finally {
            jar.close();
        }
        JarExtension ext = new JarExtension(logger, extensionParsers, file, jarClassLoader, true);
        if (agentClass != null) {
            ext.invokeMainMethod(logger, agentClass);
        }
        return ext;
    }

    public static JarExtension create(IAgentLogger logger, ExtensionParsers extensionParsers, String jarFileName) throws IOException {
        return new JarExtension(logger, extensionParsers, new File(jarFileName), AgentBridge.getAgent().getClass().getClassLoader(), false);
    }

    private JarExtension(IAgentLogger logger, ExtensionParsers extensionParsers, File file, ClassLoader classLoader, boolean custom) throws IOException {
        this.classloader = classLoader;
        this.file = file;
        JarFile jarFile = new JarFile(file);
        logger.fine(MessageFormat.format(!custom ? "Loading built-in agent extensions" : "Loading extension jar \"{0}\"", file.getAbsolutePath()));
        Collection<JarEntry> entries = JarExtension.getExtensions(jarFile);
        for (JarEntry entry : entries) {
            InputStream iStream = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                if (iStream != null) {
                    try {
                        Extension extension = extensionParsers.getParser(entry.getName()).parse(classLoader, iStream, custom);
                        this.addExtension(extension);
                    }
                    catch (Exception ex) {
                        logger.severe(MessageFormat.format("Invalid extension file {0} : {1}", entry.getName(), ex.toString()));
                        logger.log(Level.FINER, ex.toString(), ex);
                    }
                    continue;
                }
                logger.fine(MessageFormat.format("Unable to load extension resource \"{0}\"", entry.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iStream == null) continue;
                if (throwable != null) {
                    try {
                        iStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iStream.close();
            }
        }
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public final Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    void addExtension(Extension extension) {
        Extension existing = this.extensions.get(extension.getName());
        if (existing == null || existing.getVersionNumber() < extension.getVersionNumber()) {
            this.extensions.put(extension.getName(), extension);
        }
    }

    private static Collection<JarEntry> getExtensions(JarFile file) {
        List<JarEntry> list = JarExtension.readExtensionsFromManifest(file);
        if (list.isEmpty()) {
            Pattern pattern = Pattern.compile("^META-INF/extensions/(.*).(yml|xml)$");
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!pattern.matcher(name).matches()) continue;
                list.add(entry);
            }
        }
        return list;
    }

    private static List<JarEntry> readExtensionsFromManifest(JarFile file) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        JarEntry extensionsManifestEntry = file.getJarEntry("META-INF/extensions/extensions");
        if (extensionsManifestEntry != null) {
            try (InputStream extensionsManifestStream = file.getInputStream(extensionsManifestEntry);){
                if (extensionsManifestStream != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(extensionsManifestStream, StandardCharsets.UTF_8));
                    String filename = null;
                    while ((filename = in.readLine()) != null) {
                        if (filename.trim().isEmpty()) continue;
                        JarEntry jarEntry = file.getJarEntry("META-INF/extensions/" + filename);
                        if (jarEntry == null) {
                            Agent.LOG.log(Level.FINE, "Error reading {0} from {1}", filename, file.getName());
                            continue;
                        }
                        list.add(jarEntry);
                    }
                }
            }
            catch (IOException e) {
                Agent.LOG.log(Level.FINE, "Error reading extensions from manifest", e);
            }
        }
        return list;
    }

    public boolean isWeaveInstrumentation() {
        return JarExtension.isWeaveInstrumentation(this.file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWeaveInstrumentation(File file) {
        Collection<String> classNames = JarExtension.getClassFileNames(file);
        if (classNames.isEmpty()) return false;
        if (!file.exists()) {
            return false;
        }
        try (JarFile jarFile = new JarFile(file);){
            Iterator<String> iterator = classNames.iterator();
            while (iterator.hasNext()) {
                Throwable throwable;
                InputStream stream;
                block34: {
                    String fileName = iterator.next();
                    JarEntry jarEntry = jarFile.getJarEntry(fileName);
                    try {
                        boolean bl;
                        block35: {
                            stream = jarFile.getInputStream(jarEntry);
                            throwable = null;
                            try {
                                ClassReader reader;
                                if (stream == null || !WeaveUtils.isWeavedClass(reader = new ClassReader(stream))) break block34;
                                bl = true;
                                if (stream == null) return bl;
                                if (throwable == null) break block35;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (stream == null) throw throwable3;
                                    if (throwable == null) {
                                        stream.close();
                                        throw throwable3;
                                    }
                                    try {
                                        stream.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                stream.close();
                                return bl;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                return bl;
                            }
                        }
                        stream.close();
                        return bl;
                    }
                    catch (IOException e) {
                        Agent.LOG.log(Level.INFO, "Error processing " + fileName, e);
                        continue;
                    }
                }
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                stream.close();
            }
            return false;
        }
        catch (IOException ex) {
            Agent.LOG.log(Level.INFO, "Error processing extension jar " + file, ex);
        }
        return false;
    }

    public Collection<String> getClassFileNames() {
        return JarExtension.getClassFileNames(this.file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<String> getClassFileNames(File file) {
        if (!file.exists()) return Collections.emptyList();
        try (JarFile jarFile = new JarFile(file);){
            ArrayList<String> classes = new ArrayList<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                String fileName = entry.getName();
                try {
                    classes.add(fileName);
                }
                catch (Exception exception) {}
            }
            ArrayList<String> arrayList = classes;
            return arrayList;
        }
        catch (IOException e) {
            Agent.LOG.debug("Unable to read classes in " + file.getAbsolutePath() + ".  " + e.getMessage());
        }
        return Collections.emptyList();
    }

    public Collection<Class<?>> getClasses() {
        Collection<String> classNames = this.getClassFileNames();
        if (classNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList classes = new ArrayList();
        for (String fileName : classNames) {
            int index = fileName.indexOf(".class");
            fileName = fileName.substring(0, index);
            fileName = fileName.replace('/', '.');
            try {
                classes.add(this.classloader.loadClass(fileName));
            }
            catch (Exception exception) {}
        }
        return classes;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    private static String getAgentClass(Manifest manifest) {
        for (String attr : Arrays.asList("Agent-Class", "Premain-Class")) {
            String agentClass = manifest.getMainAttributes().getValue(attr);
            if (null == agentClass) continue;
            return agentClass;
        }
        return null;
    }

    private void invokeMainMethod(IAgentLogger logger, String agentClass) {
        try {
            Class<?> clazz = this.classloader.loadClass(agentClass);
            logger.log(Level.FINE, "Invoking {0}.premain method", agentClass);
            Method method = clazz.getDeclaredMethod("premain", String.class, Instrumentation.class);
            String agentArgs = "";
            method.invoke(null, agentArgs, ServiceFactory.getClassTransformerService().getExtensionInstrumentation());
        }
        catch (ClassNotFoundException | SecurityException e) {
            logger.log(Level.INFO, "Unable to load {0}", agentClass);
            logger.log(Level.FINEST, e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.INFO, "{0} has no premain method", agentClass);
            logger.log(Level.FINEST, e, e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to invoke {0}.premain", agentClass);
            logger.log(Level.FINEST, e, e.getMessage());
        }
    }

    private static File writeTempJar(IAgentLogger logger, File file, byte[] newBytes) throws IOException {
        File original = file;
        file = File.createTempFile(file.getName(), ".jar", BootstrapLoader.getTempDir());
        file.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(file);){
            Streams.copy((InputStream)new ByteArrayInputStream(newBytes), (OutputStream)out, newBytes.length);
        }
        logger.log(Level.FINER, "Rewriting {0} as {1}", original.getAbsolutePath(), file.getAbsolutePath());
        return file;
    }

    private static void validateJar(byte[] bytes) throws IOException {
    }
}

