/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import java.util.regex.Pattern;

public class GeneratedClassDetector
implements ClassMatchVisitorFactory {
    public static final boolean isGenerated(String className) {
        Pattern proxy = Pattern.compile("(.*)proxy(.*)", 2);
        Pattern cglib = Pattern.compile("(.*)cglib(.*)", 2);
        Pattern generated = Pattern.compile("(.*)generated(.*)", 2);
        if (className == null) {
            return false;
        }
        if (className.contains("$$")) {
            return true;
        }
        return generated.matcher(className).find() || cglib.matcher(className).find() || proxy.matcher(className).find();
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, final ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(458752, cv){

            @Override
            public void visitSource(String source, String debug) {
                super.visitSource(source, debug);
                context.setSourceAttribute(true);
                if ("<generated>".equals(source)) {
                    context.setGenerated(true);
                }
            }

            @Override
            public void visitEnd() {
                String className;
                super.visitEnd();
                if (!context.hasSourceAttribute() && GeneratedClassDetector.isGenerated(className = reader.getClassName())) {
                    context.setGenerated(true);
                }
            }
        };
    }
}

