/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.metrics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.metrics.JmxAction;
import com.newrelic.agent.jmx.metrics.MonotonicallyIncreasingJmxMetric;
import com.newrelic.agent.jmx.metrics.SimpleJmxMetric;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;

public abstract class JmxMetric {
    private final String attributeMetricName;
    private final String[] attributes;
    private final JmxAction action;

    protected JmxMetric(String pAttribute) {
        this(new String[]{pAttribute}, null, JmxAction.USE_FIRST_ATT);
    }

    protected JmxMetric(String[] pAttributes, String pAttMetricName, JmxAction pAction) throws IllegalArgumentException {
        this.attributes = pAttributes;
        this.attributeMetricName = pAttMetricName == null ? pAttributes[0] : pAttMetricName;
        this.action = pAction;
    }

    public static JmxMetric create(String attribute, JmxType type) {
        if (JmxType.MONOTONICALLY_INCREASING.equals((Object)type)) {
            return new MonotonicallyIncreasingJmxMetric(attribute);
        }
        return new SimpleJmxMetric(attribute);
    }

    public static JmxMetric create(String attribute, String attMetricName, JmxType type) {
        if (JmxType.MONOTONICALLY_INCREASING.equals((Object)type)) {
            return new MonotonicallyIncreasingJmxMetric(new String[]{attribute}, attMetricName, JmxAction.USE_FIRST_ATT);
        }
        return new SimpleJmxMetric(new String[]{attribute}, attMetricName, JmxAction.USE_FIRST_ATT);
    }

    public static JmxMetric create(String[] attributes, String attMetricName, JmxAction pAction, JmxType type) {
        if (attributes == null || attributes.length == 0) {
            throw new IllegalArgumentException("A JmxMetric can not be created with zero attributes.");
        }
        if (JmxType.MONOTONICALLY_INCREASING.equals((Object)type)) {
            return new MonotonicallyIncreasingJmxMetric(attributes, attMetricName, pAction);
        }
        return new SimpleJmxMetric(attributes, attMetricName, pAction);
    }

    public abstract void recordStats(StatsEngine var1, String var2, float var3);

    public abstract JmxType getType();

    public String getAttributeMetricName() {
        return this.attributeMetricName;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void applySingleMBean(String rootMetricName, Map<String, Float> inputAttToValues, Map<String, Float> resultingValues) {
        block3: {
            String fullMetricName = rootMetricName + this.attributeMetricName;
            try {
                float value = this.action.performAction(this.attributes, inputAttToValues);
                Float oldVal = resultingValues.get(fullMetricName);
                if (oldVal != null) {
                    value += oldVal.floatValue();
                }
                resultingValues.put(fullMetricName, Float.valueOf(value));
                Agent.LOG.log(Level.FINER, "Adding Multi Bean: {0} Value: {1}", fullMetricName, Float.valueOf(value));
            }
            catch (IllegalArgumentException e) {
                if (!Agent.LOG.isFinerEnabled()) break block3;
                Agent.LOG.log(Level.FINER, MessageFormat.format("JMX Metric {0} not recorded. {1}", fullMetricName, e.getMessage()));
            }
        }
    }

    public void recordMultMBeanStats(StatsEngine statsEngine, Map<String, Float> metricWithValues) {
        for (Map.Entry<String, Float> current : metricWithValues.entrySet()) {
            if (current.getKey().length() <= 0) continue;
            this.recordStats(statsEngine, current.getKey(), current.getValue().floatValue());
            Agent.LOG.log(Level.FINER, "JMX Multi Bean Metric: {0} Value: {1}", current.getKey(), current.getValue());
        }
    }

    public void recordSingleMBeanStats(StatsEngine statsEngine, String rootMetricName, Map<String, Float> values) {
        block2: {
            String fullMetricName = rootMetricName + this.attributeMetricName;
            try {
                float val = this.action.performAction(this.attributes, values);
                this.recordStats(statsEngine, fullMetricName, val);
                Agent.LOG.log(Level.FINER, "JMX Metric: {0} Value: {1}", fullMetricName, Float.valueOf(val));
            }
            catch (IllegalArgumentException e) {
                if (!Agent.LOG.isFinerEnabled()) break block2;
                Agent.LOG.log(Level.FINER, MessageFormat.format("JMX Metric {0} not recorded. {1}", fullMetricName, e.getMessage()));
            }
        }
    }
}

