/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.deps.com.google.common.collect.ConcurrentHashMultiset;
import com.newrelic.agent.deps.com.google.common.collect.Multiset;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfileTree;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.TransactionStats;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class KeyTransactionProfile
implements IProfile,
ExtendedTransactionListener,
JSONStreamAware {
    private static final int CAPACITY = 100;
    private final IProfile delegate;
    private final String keyTransaction;
    private final Map<Long, BlockingQueue<StackTraceHolder>> pendingStackTraces = new ConcurrentHashMap<Long, BlockingQueue<StackTraceHolder>>();
    private final Queue<StackTraceHolder> releasedStackTraces = new ConcurrentLinkedQueue<StackTraceHolder>();
    private final Multiset<Long> activeTransactionThreadIds = ConcurrentHashMultiset.create();

    public KeyTransactionProfile(Profile profile) {
        this.keyTransaction = profile.getProfilerParameters().getKeyTransaction();
        this.delegate = profile;
    }

    IProfile getDelegate() {
        return this.delegate;
    }

    @Override
    public void start() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        this.delegate.start();
    }

    @Override
    public void end() {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.pendingStackTraces.clear();
        this.releaseStackTraces();
        this.delegate.end();
        this.activeTransactionThreadIds.clear();
    }

    @Override
    public ProfilerParameters getProfilerParameters() {
        return this.delegate.getProfilerParameters();
    }

    @Override
    public int getSampleCount() {
        return this.delegate.getSampleCount();
    }

    @Override
    public Long getProfileId() {
        return this.delegate.getProfileId();
    }

    @Override
    public ProfileTree getProfileTree(ThreadType threadType) {
        return this.delegate.getProfileTree(threadType);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        this.delegate.writeJSONString(out);
    }

    @Override
    public int trimBy(int count) {
        return this.delegate.trimBy(count);
    }

    @Override
    public long getStartTimeMillis() {
        return this.delegate.getStartTimeMillis();
    }

    @Override
    public long getEndTimeMillis() {
        return this.delegate.getEndTimeMillis();
    }

    Map<Long, Integer> getPendingThreadQueueSizes() {
        HashMap<Long, Integer> pendingThreadQueueSizes = new HashMap<Long, Integer>();
        for (Map.Entry<Long, BlockingQueue<StackTraceHolder>> entry : this.pendingStackTraces.entrySet()) {
            pendingThreadQueueSizes.put(entry.getKey(), entry.getValue().size());
        }
        return pendingThreadQueueSizes;
    }

    Set<Long> getActiveThreadIds() {
        return this.activeTransactionThreadIds.elementSet();
    }

    private void releaseStackTraces() {
        StackTraceHolder holder;
        while ((holder = this.releasedStackTraces.poll()) != null) {
            this.delegate.addStackTrace(holder.getThreadId(), holder.isRunnable(), holder.getType(), holder.getStackTrace());
        }
        return;
    }

    @Override
    public void dispatcherTransactionStarted(Transaction transaction) {
        this.activeTransactionThreadIds.add(transaction.getInitiatingThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatcherTransactionFinished(TransactionData td, TransactionStats stats) {
        try {
            this.doDispatcherTransactionFinished(td, stats);
            long threadId = td.getTransaction().getInitiatingThreadId();
            boolean success = this.getActiveThreadIds().remove(threadId);
            Agent.LOG.finer("Attempt to remove thread id: " + threadId + " was " + (success ? "" : "not ") + "successful");
        }
        catch (Exception e) {
            try {
                String msg = MessageFormat.format("Error releasing stack traces for \"{0}\": {1}", td.getBlameMetricName(), e);
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, e);
                } else {
                    Agent.LOG.finer(msg);
                }
                long threadId = td.getTransaction().getInitiatingThreadId();
                boolean success = this.getActiveThreadIds().remove(threadId);
                Agent.LOG.finer("Attempt to remove thread id: " + threadId + " was " + (success ? "" : "not ") + "successful");
            }
            catch (Throwable throwable) {
                long threadId = td.getTransaction().getInitiatingThreadId();
                boolean success = this.getActiveThreadIds().remove(threadId);
                Agent.LOG.finer("Attempt to remove thread id: " + threadId + " was " + (success ? "" : "not ") + "successful");
                throw throwable;
            }
        }
    }

    @Override
    public void dispatcherTransactionCancelled(Transaction transaction) {
        this.getActiveThreadIds().remove(transaction.getInitiatingThreadId());
    }

    private void doDispatcherTransactionFinished(TransactionData td, TransactionStats stats) {
        boolean isKeyTransaction = this.isKeyTransaction(td);
        for (TransactionActivity transactionActivity : td.getTransactionActivities()) {
            StackTraceHolder holder;
            BlockingQueue<StackTraceHolder> holderQueue = this.getHolderQueue(transactionActivity.getThreadId());
            if (holderQueue == null) continue;
            long startTime = transactionActivity.getRootTracer().getStartTime();
            long endTime = transactionActivity.getRootTracer().getEndTime();
            ArrayList holders = new ArrayList(holderQueue.size());
            holderQueue.drainTo(holders);
            Iterator iterator = holders.iterator();
            while (iterator.hasNext() && (holder = (StackTraceHolder)iterator.next()) != null) {
                if (startTime > holder.getStackTraceTime() || endTime < holder.getStackTraceTime()) {
                    holderQueue.offer(holder);
                    continue;
                }
                if (!isKeyTransaction) continue;
                this.releasedStackTraces.add(holder);
            }
        }
    }

    private boolean isKeyTransaction(TransactionData td) {
        return this.keyTransaction.equals(td.getBlameMetricName());
    }

    @Override
    public void beforeSampling() {
        this.clearNonTransactionQueues();
        this.releaseStackTraces();
        this.delegate.beforeSampling();
    }

    private void clearNonTransactionQueues() {
        Set<Long> pendingThreadIds = this.pendingStackTraces.keySet();
        pendingThreadIds.retainAll(this.getActiveThreadIds());
    }

    @Override
    public void addStackTrace(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
        if (type != ThreadType.BasicThreadType.OTHER) {
            return;
        }
        StackTraceHolder holder = new StackTraceHolder(threadId, runnable, type, stackTrace);
        BlockingQueue<StackTraceHolder> holderQueue = this.getOrCreateHolderQueue(threadId);
        holderQueue.offer(holder);
    }

    private BlockingQueue<StackTraceHolder> getHolderQueue(long threadId) {
        return this.pendingStackTraces.get(threadId);
    }

    private BlockingQueue<StackTraceHolder> getOrCreateHolderQueue(long threadId) {
        BlockingQueue<StackTraceHolder> holderQueue = this.pendingStackTraces.get(threadId);
        if (holderQueue == null) {
            holderQueue = new LinkedBlockingQueue<StackTraceHolder>(100);
            this.pendingStackTraces.put(threadId, holderQueue);
        }
        return holderQueue;
    }

    @Override
    public void markInstrumentedMethods() {
    }

    private static class StackTraceHolder {
        private final long threadId;
        private final boolean runnable;
        private final ThreadType type;
        private final long stackTraceTime;
        private final StackTraceElement[] stackTrace;

        private StackTraceHolder(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
            this.threadId = threadId;
            this.runnable = runnable;
            this.type = type;
            this.stackTrace = stackTrace;
            this.stackTraceTime = System.nanoTime();
        }

        public long getThreadId() {
            return this.threadId;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public ThreadType getType() {
            return this.type;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public long getStackTraceTime() {
            return this.stackTraceTime;
        }
    }
}

