/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ProfilerParameters
implements JSONStreamAware {
    private final Long profileId;
    private final Long samplePeriodInMillis;
    private final Long durationInMillis;
    private final boolean onlyRunnableThreads;
    private final boolean onlyRequestThreads;
    private final boolean profileAgentCode;
    private final String keyTransaction;
    private final String appName;
    private String profilerFormat;
    private boolean profileInstrumentation = true;
    private Map<?, ?> parameterMap = new HashMap();

    public ProfilerParameters(Long profileId, long samplePeriodInMillis, long durationInMillis, boolean onlyRunnableThreads, boolean onlyRequestThreads, boolean profileAgentCode, String keyTransaction, String appName) {
        this.profileId = profileId;
        this.samplePeriodInMillis = samplePeriodInMillis;
        this.durationInMillis = durationInMillis;
        this.onlyRunnableThreads = onlyRunnableThreads;
        this.onlyRequestThreads = onlyRequestThreads;
        this.profileAgentCode = profileAgentCode;
        this.keyTransaction = keyTransaction;
        this.appName = appName;
    }

    public Long getProfileId() {
        return this.profileId;
    }

    public Long getSamplePeriodInMillis() {
        return this.samplePeriodInMillis;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public boolean isRunnablesOnly() {
        return this.onlyRunnableThreads;
    }

    public boolean isOnlyRequestThreads() {
        return this.onlyRequestThreads;
    }

    public boolean isProfileAgentThreads() {
        return this.profileAgentCode;
    }

    public boolean isProfileInstrumentation() {
        return this.profileInstrumentation;
    }

    public ProfilerParameters setProfileInstrumentation(Boolean includeTransactions) {
        if (includeTransactions != null) {
            this.profileInstrumentation = includeTransactions;
        }
        return this;
    }

    public String getKeyTransaction() {
        return this.keyTransaction;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProfilerFormat() {
        return this.profilerFormat;
    }

    public ProfilerParameters setProfilerFormat(String profileFormat) {
        if (profileFormat != null) {
            profileFormat.trim();
        }
        this.profilerFormat = profileFormat;
        return this;
    }

    public ProfilerParameters setParameterMap(Map<?, ?> parameterMap) {
        this.parameterMap = parameterMap;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = this.profileId == null ? result : 31 * result + this.profileId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ProfilerParameters other = (ProfilerParameters)obj;
        return this.profileId.longValue() == other.profileId.longValue();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(this.parameterMap, out);
    }
}

