/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.core.CoreService;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.samplers.MemorySampler;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.ThreadSampler;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.MergeStatsEngine;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SamplerServiceImpl
extends AbstractService
implements SamplerService {
    private static final String SAMPLER_THREAD_NAME = "New Relic Sampler Service";
    private static final int INITIAL_DELAY_IN_MILLISECONDS = 60000;
    private static final long DELAY_IN_MILLISECONDS = 5000L;
    private final ScheduledExecutorService scheduledExecutor;
    private final Set<ScheduledFuture<?>> tasks = Sets.newSetFromMap(new ConcurrentHashMap());
    private final StatsEngine statsEngine = new StatsEngineImpl();
    private final CoreService coreService;
    private final String defaultAppName;
    private final boolean isAutoAppNamingEnabled;
    private final long memorySampleDelayInMillis;

    public SamplerServiceImpl() {
        super(SamplerService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(SAMPLER_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.coreService = ServiceFactory.getCoreService();
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.isAutoAppNamingEnabled = config.isAutoAppNamingEnabled();
        this.defaultAppName = config.getApplicationName();
        this.memorySampleDelayInMillis = ((Integer)config.getValue("sampler_service.memory_sample_delay_in_millis", 60000)).intValue();
    }

    @Override
    protected void doStart() {
        MemorySampler memorySampler = new MemorySampler();
        memorySampler.start();
        this.addMetricSampler(memorySampler, this.memorySampleDelayInMillis, 5000L, TimeUnit.MILLISECONDS);
        ThreadSampler threadSampler = new ThreadSampler();
        this.addMetricSampler(threadSampler, 60000L, 5000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Set<ScheduledFuture<?>> set = this.tasks;
        synchronized (set) {
            for (ScheduledFuture<?> task : this.tasks) {
                task.cancel(false);
            }
            this.tasks.clear();
        }
        this.scheduledExecutor.shutdown();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void addMetricSampler(final MetricSampler sampler, long initialDelay, long delay, TimeUnit unit) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SamplerServiceImpl.this.runSampler(sampler);
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Unable to sample {0}: {1}", this.getClass().getName(), t);
                    if (SamplerServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                        SamplerServiceImpl.this.getLogger().log(Level.WARNING, msg, t);
                    } else {
                        SamplerServiceImpl.this.getLogger().warning(msg);
                    }
                }
                finally {
                    SamplerServiceImpl.this.statsEngine.clear();
                }
            }
        };
        this.addSampler(runnable, initialDelay, delay, unit);
    }

    private void runSampler(MetricSampler sampler) {
        if (!this.coreService.isEnabled()) {
            return;
        }
        sampler.sample(this.statsEngine);
        if (!this.isAutoAppNamingEnabled) {
            this.mergeStatsEngine(this.defaultAppName);
            return;
        }
        List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
        for (IRPMService rpmService : rpmServices) {
            String appName = rpmService.getApplicationName();
            this.mergeStatsEngine(appName);
        }
    }

    private void mergeStatsEngine(String appName) {
        StatsService statsService = ServiceFactory.getStatsService();
        MergeStatsEngine work = new MergeStatsEngine(appName, this.statsEngine);
        statsService.doStatsWork(work);
    }

    @Override
    public Closeable addSampler(Runnable sampler, long period, TimeUnit timeUnit) {
        return this.addSampler(sampler, period, period, timeUnit);
    }

    @Override
    public Closeable addSampler(Runnable sampler, long initialDelay, long period, TimeUnit timeUnit) {
        if (this.scheduledExecutor.isShutdown()) {
            return null;
        }
        final ScheduledFuture<?> task = this.scheduledExecutor.scheduleWithFixedDelay(SafeWrappers.safeRunnable(sampler), initialDelay, period, timeUnit);
        this.tasks.add(task);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                SamplerServiceImpl.this.tasks.remove(task);
                task.cancel(false);
            }
        };
    }
}

