/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.JarCollectorConfig;
import com.newrelic.agent.config.JarCollectorConfigImpl;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.module.Jar;
import com.newrelic.agent.service.module.JarCollectorService;
import com.newrelic.agent.service.module.JarCollectorServiceProcessor;
import com.newrelic.agent.service.module.SendModuleMetadataCommand;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class JarCollectorServiceImpl
extends AbstractService
implements JarCollectorService,
HarvestListener {
    private final JarCollectorServiceProcessor processor = new JarCollectorServiceProcessor();
    private long lastAllJarFlush = 0L;
    private final String defaultApp;
    private final boolean enabled;
    private final AtomicReference<Map<String, URL>> queuedJars = new AtomicReference<Map<String, URL>>(this.newUrlMap());
    private volatile Map<File, WeavePackageConfig> weaveConfigurations;

    private Map<String, URL> newUrlMap() {
        return new ConcurrentHashMap<String, URL>();
    }

    public JarCollectorServiceImpl() {
        super(JarCollectorService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.defaultApp = config.getApplicationName();
        JarCollectorConfig jarCollectorConfig = config.getJarCollectorConfig();
        this.enabled = jarCollectorConfig.isEnabled();
        if (JarCollectorConfigImpl.isUsingDeprecatedConfigSettings()) {
            String deprecatedConfigMsg = "Jar Collector system properties prefixed with 'newrelic.config.module.' and environment variables prefixed with 'NEW_RELIC_MODULE_' are deprecated and will be removed in a future agent release. Instead use the 'newrelic.config.jar_collector.' and 'NEW_RELIC_JAR_COLLECTOR_' prefixes.";
            Agent.LOG.info(deprecatedConfigMsg);
            NewRelic.incrementCounter((String)"Supportability/Deprecated/Config/JarCollector");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.enabled) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
            ServiceFactory.getCommandParser().addCommands(new SendModuleMetadataCommand(this.processor));
            this.weaveConfigurations = ImmutableMap.copyOf(this.getWeavePackageConfig(ServiceFactory.getExtensionService().getWeaveExtensions()));
        }
    }

    private Map<File, WeavePackageConfig> getWeavePackageConfig(Collection<File> weaveExtensions) {
        HashMap<File, WeavePackageConfig> configs = new HashMap<File, WeavePackageConfig>();
        for (File file : weaveExtensions) {
            try {
                WeavePackageConfig weaveConfig = WeavePackageConfig.builder().url(file.toURI().toURL()).build();
                configs.put(file, weaveConfig);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return configs;
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    private boolean needToSendAllJars() {
        return ServiceFactory.getRPMService().getConnectionTimestamp() > this.lastAllJarFlush;
    }

    @Override
    public synchronized void beforeHarvest(String pAppName, StatsEngine pStatsEngine) {
        if (!this.defaultApp.equals(pAppName)) {
            return;
        }
        Agent.LOG.log(Level.FINER, "Harvesting Modules");
        boolean sendAll = this.needToSendAllJars();
        Map<String, URL> urls = this.queuedJars.getAndSet(this.newUrlMap());
        List<Jar> jars = this.processor.processModuleData(urls.values(), sendAll);
        this.addWeaveModules(jars);
        if (sendAll) {
            this.lastAllJarFlush = System.nanoTime();
        }
        if (!jars.isEmpty()) {
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                for (Jar jar : jars) {
                    sb.append("   ");
                    sb.append(jar.getName());
                    sb.append(":");
                    sb.append(jar.getVersion());
                }
                Agent.LOG.log(Level.FINEST, "Sending jars: " + sb.toString());
            }
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(pAppName).sendModules(jars);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, MessageFormat.format("Unable to send {0} jar(s). Will attempt next harvest.", jars.size()));
                this.queuedJars.get().putAll(urls);
            }
        }
    }

    private void addWeaveModules(List<Jar> jars) {
        if (null != this.weaveConfigurations) {
            jars.addAll(JarCollectorServiceProcessor.getWeaveJars(this.weaveConfigurations));
            this.weaveConfigurations = null;
        }
    }

    @Override
    public void afterHarvest(String pAppName) {
    }

    Map<String, URL> getQueuedJars() {
        return this.queuedJars.get();
    }

    void addUrls(URL ... urls) {
        if (this.enabled) {
            for (URL url : urls) {
                URL newUrl;
                if ("jar".equals(url.getProtocol())) {
                    String path = url.getFile();
                    if (this.queuedJars.get().containsKey(path)) continue;
                    int index = path.lastIndexOf(".jar");
                    if (index > 0) {
                        path = path.substring(0, index + ".jar".length());
                    }
                    try {
                        newUrl = new URL(path);
                        this.queuedJars.get().put(url.getPath(), newUrl);
                    }
                    catch (MalformedURLException e) {
                        Agent.LOG.log(Level.FINEST, e, "Error parsing jar: {0}", e.getMessage());
                    }
                    continue;
                }
                if (url.getFile().endsWith(".jar")) {
                    this.queuedJars.get().put(url.getFile(), url);
                    continue;
                }
                int jarIndex = url.getFile().lastIndexOf(".jar");
                if (jarIndex <= 0) continue;
                String path = url.getFile().substring(0, jarIndex + ".jar".length());
                if (this.queuedJars.get().containsKey(path)) continue;
                try {
                    newUrl = new URL(url.getProtocol(), url.getHost(), path);
                    this.queuedJars.get().put(path, newUrl);
                }
                catch (MalformedURLException e) {
                    Agent.LOG.log(Level.FINEST, e, "Error parsing jar: {0}", e.getMessage());
                }
            }
        }
    }

    @Override
    public ClassMatchVisitorFactory getSourceVisitor() {
        return new ClassMatchVisitorFactory(){

            @Override
            public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
                if (JarCollectorServiceImpl.this.enabled && null != context.getProtectionDomain() && null != context.getProtectionDomain().getCodeSource() && null != context.getProtectionDomain().getCodeSource().getLocation()) {
                    JarCollectorServiceImpl.this.addUrls(context.getProtectionDomain().getCodeSource().getLocation());
                }
                return null;
            }
        };
    }
}

