/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.hash.HashCode;
import com.newrelic.agent.deps.com.google.common.hash.HashFunction;
import com.newrelic.agent.deps.com.google.common.hash.Hashing;
import com.newrelic.agent.util.StringMap;
import com.newrelic.org.apache.axis.encoding.Base64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Strings {
    public static final String NEWRELIC_DEPENDENCY_INTERNAL_PACKAGE_PREFIX = "com/newrelic/agent/deps/";
    private static final String NEWRELIC_DEPENDENCY_PACKAGE_PREFIX = "com.newrelic.agent.deps.";
    private static final StringMap NO_OP_STRING_MAP = new StringMap(){

        @Override
        public Object addString(String string) {
            return string;
        }

        @Override
        public Map<Object, String> getStringMap() {
            return ImmutableMap.of();
        }
    };

    private Strings() {
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }

    public static Collection<String> trim(Collection<String> strings) {
        ArrayList<String> trimmedList = new ArrayList<String>(strings.size());
        for (String string : strings) {
            trimmedList.add(string.trim());
        }
        return trimmedList;
    }

    public static String unquoteDatabaseName(String s) {
        int index = s.indexOf(46);
        if (index > 0) {
            return new StringBuilder(s.length()).append(Strings.unquote(s.substring(0, index))).append('.').append(Strings.unquote(s.substring(index + 1))).toString();
        }
        return Strings.unquote(s);
    }

    public static String removeBrackets(String s) {
        String result = s.replace("[", "");
        result = result.replace("]", "");
        return result;
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s : strings) {
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            if (strings[i].isEmpty()) continue;
            sb.append(delimiter).append(strings[i]);
        }
        return sb.toString();
    }

    public static String join(String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = 0;
        for (String s : strings) {
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].isEmpty()) continue;
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public static String[] split(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        ArrayList<String> segments = new ArrayList<String>(4);
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static String unquote(String string) {
        char last;
        if (string == null || string.length() < 2) {
            return string;
        }
        char first = string.charAt(0);
        if (first != (last = string.charAt(string.length() - 1)) || first != '\"' && first != '\'' && first != '`') {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String fixClassName(String className) {
        return Strings.trimName(className, NEWRELIC_DEPENDENCY_PACKAGE_PREFIX);
    }

    private static String trimName(String fullName, String prefix) {
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    public static String fixInternalClassName(String className) {
        className = className.replace('.', '/');
        return Strings.trimName(className, NEWRELIC_DEPENDENCY_INTERNAL_PACKAGE_PREFIX);
    }

    public static String getGlobPattern(String glob) {
        StringBuilder b = new StringBuilder().append('^');
        block5: for (char c : glob.toCharArray()) {
            switch (c) {
                case '.': {
                    b.append("\\.");
                    continue block5;
                }
                case '/': {
                    b.append("\\/");
                    continue block5;
                }
                case '*': {
                    b.append(".*");
                    continue block5;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static Pattern getPatternFromGlobs(List<String> globs) {
        ArrayList<String> patterns = new ArrayList<String>(globs.size());
        for (String glob : globs) {
            patterns.add('(' + Strings.getGlobPattern(glob) + ')');
        }
        String pattern = Joiner.on('|').join(patterns);
        return Pattern.compile(pattern);
    }

    public static StringMap getPassthroughStringMap() {
        return NO_OP_STRING_MAP;
    }

    public static StringMap newStringMap() {
        return new StringMap(){
            private final HashFunction hashFunction = Hashing.murmur3_128(394852370);
            private final Charset charSet = StandardCharsets.UTF_8;
            final Map<Object, String> stringMap = new ConcurrentHashMap<Object, String>();

            @Override
            public Map<Object, String> getStringMap() {
                return this.stringMap;
            }

            @Override
            public Object addString(String string) {
                String key;
                if (null == string) {
                    return null;
                }
                if (string.length() < 12) {
                    key = string;
                } else {
                    HashCode hash = this.hashFunction.newHasher().putString(string, this.charSet).hash();
                    byte[] asBytes = hash.asBytes();
                    key = Base64.encode(asBytes, 0, 8);
                }
                this.stringMap.put(key, string);
                return key;
            }
        };
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!Strings.regionMatches(str, true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    private static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

