/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Level;

public class PatchedClassWriter
extends ClassWriter {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    protected final ClassResolver classResolver;

    public PatchedClassWriter(int flags, ClassLoader classLoader) {
        this(flags, ClassResolvers.getClassLoaderResolver(classLoader == null ? AgentBridge.getAgent().getClass().getClassLoader() : classLoader));
    }

    public PatchedClassWriter(int flags, ClassResolver classResolver) {
        super(flags);
        this.classResolver = classResolver;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        if (JAVA_LANG_OBJECT.equals(type1) || JAVA_LANG_OBJECT.equals(type2)) {
            return JAVA_LANG_OBJECT;
        }
        try {
            ClassReader reader1 = this.getClassReader(type1);
            ClassReader reader2 = this.getClassReader(type2);
            if (reader1 == null || reader2 == null) {
                return JAVA_LANG_OBJECT;
            }
            String superClass = this.getCommonSuperClass(reader1, reader2);
            if (superClass == null) {
                return JAVA_LANG_OBJECT;
            }
            return superClass;
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINER, ex, "Unable to get common super class");
            throw new RuntimeException(ex.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClassReader getClassReader(String type) throws IOException {
        try (InputStream classResource = this.classResolver.getClassResource(type);){
            ClassReader classReader = classResource == null ? null : new ClassReader(classResource);
            return classReader;
        }
        catch (IOException ex) {
            Agent.LOG.log(Level.FINEST, ex.toString(), ex);
            return null;
        }
    }

    private String getCommonSuperClass(ClassReader reader1, ClassReader reader2) throws ClassNotFoundException, IOException {
        if (this.isAssignableFrom(reader1, reader2)) {
            return reader1.getClassName();
        }
        if (this.isAssignableFrom(reader2, reader1)) {
            return reader2.getClassName();
        }
        if (this.isInterface(reader1) || this.isInterface(reader2)) {
            return JAVA_LANG_OBJECT;
        }
        HashSet<String> classes = new HashSet<String>();
        classes.add(reader1.getClassName());
        while (reader1.getSuperName() != null) {
            classes.add(reader1.getSuperName());
            reader1 = this.getClassReader(reader1.getSuperName());
        }
        while (reader2.getSuperName() != null) {
            if (classes.contains(reader2.getClassName())) {
                return reader2.getClassName();
            }
            reader2 = this.getClassReader(reader2.getSuperName());
        }
        return null;
    }

    private boolean isInterface(ClassReader reader) {
        return (reader.getAccess() & 0x200) != 0;
    }

    private boolean isAssignableFrom(ClassReader reader1, ClassReader reader2) {
        return reader1.getClassName().equals(reader2.getClassName()) || reader1.getClassName().equals(reader2.getSuperName());
    }
}

