/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.KubernetesData;
import com.newrelic.agent.utilization.UtilizationConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class UtilizationData {
    private static final String METADATA_VERSION_KEY = "metadata_version";
    private static final int METADATA_VERSION = 5;
    private static final String LOGICAL_CORES_KEY = "logical_processors";
    private static final String RAM_KEY = "total_ram_mib";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String FULL_HOSTNAME_KEY = "full_hostname";
    private static final String IP_ADDRESS = "ip_address";
    private static final String VENDORS_KEY = "vendors";
    private static final String BOOT_ID = "boot_id";
    private static final String DOCKER = "docker";
    private static final String DOCKER_ID_KEY = "id";
    private static final String CONFIG_KEY = "config";
    private static final String KUBERNETES = "kubernetes";
    private CloudData cloudData;
    private final String hostname;
    private final String fullHostName;
    private final ArrayList<String> ipAddress;
    private final Integer logicalProcessorCount;
    private final String dockerContainerId;
    private final String bootId;
    private final Long totalRamMib;
    private final UtilizationConfig dataConfig;
    private final KubernetesData kubernetesData;

    public UtilizationData(String host, String fullHost, ArrayList<String> ip, Integer logicalProcessorCt, String dockerId, String bootId, CloudData cloudData, Future<Long> ramFuture, UtilizationConfig configData, KubernetesData kubernetesData) {
        this(host, fullHost, ip, logicalProcessorCt, dockerId, bootId, cloudData, UtilizationData.getTotalRamMibFromFuture(ramFuture), configData, kubernetesData);
    }

    public UtilizationData(String host, String fullHost, ArrayList<String> ip, Integer logicalProcessorCt, String dockerId, String bootId, CloudData cloudData, Long ram, UtilizationConfig configData, KubernetesData kubernetesData) {
        this.hostname = host;
        this.fullHostName = fullHost;
        this.ipAddress = ip;
        this.logicalProcessorCount = Integer.valueOf(0).equals(logicalProcessorCt) ? null : logicalProcessorCt;
        this.dockerContainerId = dockerId;
        this.bootId = bootId;
        this.cloudData = cloudData;
        this.totalRamMib = Long.valueOf(0L).equals(ram) ? null : ram;
        this.dataConfig = configData;
        this.kubernetesData = kubernetesData;
    }

    public Map<String, Object> map() {
        Map<String, String> kubernetesValues;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(METADATA_VERSION_KEY, 5);
        data.put(LOGICAL_CORES_KEY, this.logicalProcessorCount);
        data.put(RAM_KEY, this.totalRamMib);
        data.put(HOSTNAME_KEY, this.hostname);
        if (!(this.fullHostName == null || this.fullHostName.isEmpty() || this.fullHostName.equals(this.hostname) || this.fullHostName.equals("localhost"))) {
            data.put(FULL_HOSTNAME_KEY, this.fullHostName);
        }
        if (this.ipAddress != null && this.ipAddress.size() > 0) {
            data.put(IP_ADDRESS, this.ipAddress);
        }
        if (this.bootId != null) {
            data.put(BOOT_ID, this.bootId);
        }
        HashMap<String, Map<String, String>> vendors = new HashMap<String, Map<String, String>>();
        if (this.cloudData != null && !this.cloudData.isEmpty()) {
            vendors.put(this.cloudData.getProvider(), this.cloudData.getValueMap());
        }
        HashMap<String, Object> utilizationConfig = new HashMap<String, Object>();
        if (this.dataConfig.getHostname() != null) {
            utilizationConfig.put(HOSTNAME_KEY, this.dataConfig.getHostname());
        }
        if (this.dataConfig.getLogicalProcessors() != null) {
            utilizationConfig.put(LOGICAL_CORES_KEY, this.dataConfig.getLogicalProcessors());
        }
        if (this.dataConfig.getTotalRamMib() != null) {
            utilizationConfig.put(RAM_KEY, this.dataConfig.getTotalRamMib());
        }
        if (!utilizationConfig.isEmpty()) {
            data.put(CONFIG_KEY, utilizationConfig);
        }
        if (this.kubernetesData != null && (kubernetesValues = this.kubernetesData.getValueMap()) != null && !kubernetesValues.isEmpty()) {
            vendors.put(KUBERNETES, new HashMap<String, String>(kubernetesValues));
        }
        if (this.dockerContainerId != null) {
            HashMap<String, String> docker = new HashMap<String, String>();
            docker.put(DOCKER_ID_KEY, this.dockerContainerId);
            vendors.put(DOCKER, docker);
        }
        if (!vendors.isEmpty()) {
            data.put(VENDORS_KEY, vendors);
        }
        return data;
    }

    private static Long getTotalRamMibFromFuture(Future<Long> ramFuture) {
        Long ram = 0L;
        try {
            ram = ramFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, (Throwable)e, "Unable to capture total RAM size");
            CloudUtility.recordError("Supportability/utilization/memory/error");
        }
        return ram;
    }
}

