/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.api.agent.Logger;

public class InfiniteTracingConfig {
    private final String licenseKey;
    private final int maxQueueSize;
    private final String host;
    private final int port;
    private final Logger logger;
    private final Double flakyPercentage;
    private final Long flakyCode;
    private final boolean usePlaintext;

    public InfiniteTracingConfig(Builder builder) {
        this.licenseKey = builder.licenseKey;
        this.maxQueueSize = builder.maxQueueSize;
        this.host = builder.host;
        this.port = builder.port;
        this.logger = builder.logger;
        this.flakyPercentage = builder.flakyPercentage;
        this.flakyCode = builder.flakyCode;
        this.usePlaintext = builder.usePlaintext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Double getFlakyPercentage() {
        return this.flakyPercentage;
    }

    public Long getFlakyCode() {
        return this.flakyCode;
    }

    public boolean getUsePlaintext() {
        return this.usePlaintext;
    }

    public static class Builder {
        public int maxQueueSize;
        public Logger logger;
        private String licenseKey;
        private String host;
        private int port;
        private Double flakyPercentage;
        private Long flakyCode;
        private boolean usePlaintext;

        public Builder licenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder flakyPercentage(Double flakyPercentage) {
            this.flakyPercentage = flakyPercentage;
            return this;
        }

        public Builder flakyCode(Long flakyCode) {
            this.flakyCode = flakyCode;
            return this;
        }

        public Builder usePlaintext(boolean usePlaintext) {
            this.usePlaintext = usePlaintext;
            return this;
        }

        public InfiniteTracingConfig build() {
            return new InfiniteTracingConfig(this);
        }
    }
}

