/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.DebugFlag;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.WeakRefTransaction;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class TokenImpl
implements Token {
    private volatile Tracer initiatingTracer;
    private final AtomicBoolean active;

    public TokenImpl(Tracer tracer) {
        Transaction tx;
        this.initiatingTracer = tracer;
        this.active = new AtomicBoolean(Boolean.TRUE);
        WeakRefTransaction weakRefTransaction = this.getTransaction();
        Transaction transaction = tx = weakRefTransaction == null ? null : weakRefTransaction.getTransactionIfExists();
        if (tx != null) {
            tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Create");
        }
        if (DebugFlag.tokenEnabled.get()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement location = stackTrace[4];
            if (location.getMethodName().equals("registerAsyncActivity")) {
                location = stackTrace[5];
            }
            Agent.LOG.log(Level.INFO, "Token: {0} created for Transaction: {1}, at: {2}", this, tx, location.toString());
        }
    }

    public WeakRefTransaction getTransaction() {
        Tracer initiatingTracerCopy = this.initiatingTracer;
        if (initiatingTracerCopy != null && initiatingTracerCopy.getTransactionActivity() != null) {
            return new WeakRefTransaction(initiatingTracerCopy.getTransactionActivity().getTransaction());
        }
        return new WeakRefTransaction(null);
    }

    public Tracer getInitiatingTracer() {
        return this.initiatingTracer;
    }

    public boolean expire() {
        if (this.active.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
            Transaction tx = this.getTransaction().getTransactionIfExists();
            if (tx != null) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Expire");
                MetricNames.recordApiSupportabilityMetric("Token/Expire");
            }
            boolean expired = Transaction.expireToken(this);
            if (DebugFlag.tokenEnabled.get()) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                StackTraceElement location = stackTrace[2];
                if (location.getMethodName().equals("registerAsyncActivity") || location.getMethodName().equals("startAsyncActivity") || location.getMethodName().equals("ignoreIfUnstartedAsyncContext")) {
                    location = stackTrace[4];
                } else if (location.getMethodName().equals("linkAndExpire")) {
                    location = stackTrace[3];
                }
                Agent.LOG.log(Level.INFO, "Token: {0} expired for Transaction: {1}, at: {2}", this, tx, location.toString());
            }
            return expired;
        }
        Agent.LOG.log(Level.FINER, "Token has already been expired {0}.", this);
        return false;
    }

    public boolean link() {
        boolean linked = Transaction.linkTxOnThread(this);
        WeakRefTransaction weakRefTransaction = this.getTransaction();
        Transaction tx = weakRefTransaction == null ? null : weakRefTransaction.getTransactionIfExists();
        String locationString = null;
        if (DebugFlag.tokenEnabled.get()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement location = stackTrace[2];
            if (location.getMethodName().equals("startAsyncActivity")) {
                location = stackTrace[4];
            } else if (location.getMethodName().equals("linkAndExpire")) {
                location = stackTrace[3];
            }
            locationString = location.toString();
        }
        if (tx != null) {
            if (DebugFlag.tokenEnabled.get()) {
                if (!linked && TransactionActivity.get() == null) {
                    Agent.LOG.log(Level.WARNING, "Token: {0} was NOT linked because there was no Transaction in progress. Did you forget to add @Trace(async = true) to: {1}?", this, locationString);
                } else {
                    Agent.LOG.log(Level.INFO, "Token: {0} {1} for Transaction: {2}, at: {3}", this, linked ? "linked" : "link ignored", tx, locationString);
                }
            }
            if (linked) {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Success");
            } else {
                tx.getMetricAggregator().incrementCounter("Supportability/Async/Token/Link/Ignore");
            }
        }
        MetricNames.recordApiSupportabilityMetric("Token/Link");
        return linked;
    }

    public boolean linkAndExpire() {
        boolean linked = this.link();
        boolean expired = this.expire();
        return linked && expired;
    }

    public boolean isActive() {
        return this.active.get();
    }

    void markExpired() {
        this.active.set(Boolean.FALSE);
        Transaction tx = this.getTransaction().getTransactionIfExists();
        if (tx != null) {
            tx.onRemoval();
        }
        this.initiatingTracer = null;
    }

    void setTruncated() {
        Tracer tracer = this.initiatingTracer;
        if (tracer != null) {
            tracer.setMetricNameFormatInfo(tracer.getMetricName(), "Truncated/" + tracer.getMetricName(), tracer.getTransactionSegmentUri());
            String timeoutCauseMetric = MessageFormat.format("Supportability/Async/Token/Timeout/Cause/{0}", tracer.getClassMethodSignature());
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(timeoutCauseMetric, 1));
        } else {
            Agent.LOG.log(Level.FINEST, "Initiating tracer is null. Unable to mark segment as truncated.");
        }
    }
}

