/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.internal;

import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.com.google.common.base.Stopwatch;
import com.newrelic.agent.deps.io.grpc.InternalServiceProviders;
import com.newrelic.agent.deps.io.grpc.NameResolver;
import com.newrelic.agent.deps.io.grpc.NameResolverProvider;
import com.newrelic.agent.deps.io.grpc.internal.DnsNameResolver;
import com.newrelic.agent.deps.io.grpc.internal.GrpcUtil;
import java.net.URI;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args2) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args2, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }
}

