/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.dispatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.StatusCodePolicy;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.CustomRequestHeaderConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.dispatchers.DefaultDispatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletUtils;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.agent.transaction.TransactionNamer;
import com.newrelic.agent.transaction.WebTransactionNamer;
import com.newrelic.api.agent.ExtendedRequest;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class WebRequestDispatcher
extends DefaultDispatcher
implements WebResponse {
    private static final String UNKNOWN_URI = "/Unknown";
    private static final StatusCodePolicy LAST_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return lastStatus;
        }
    };
    private static final StatusCodePolicy ERROR_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return currentStatus < 400 ? lastStatus : currentStatus;
        }
    };
    private static final StatusCodePolicy FREEZE_STATUS_CODE_POLICY = new StatusCodePolicy(){

        public int nextStatus(int currentStatus, int lastStatus) {
            return currentStatus;
        }
    };
    private final AtomicBoolean responseRecorded = new AtomicBoolean(false);
    private volatile Request request;
    private volatile Response response;
    private volatile String requestURI;
    private volatile ExternalTimeTracker externalTimeTracker;
    private volatile int statusCode;
    private volatile String statusMessage;
    private volatile StatusCodePolicy statusCodePolicy;

    public WebRequestDispatcher(Request request, Response response, Transaction transaction) {
        super(transaction);
        boolean isLastStatusCodePolicy = (Boolean)transaction.getAgentConfig().getValue("last_status_code_policy", Boolean.TRUE);
        this.statusCodePolicy = isLastStatusCodePolicy ? LAST_STATUS_CODE_POLICY : ERROR_STATUS_CODE_POLICY;
        this.request = request;
        this.response = response;
        this.externalTimeTracker = ExternalTimeTracker.create(request, transaction.getWallClockStartTimeMs());
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Request request) {
        this.externalTimeTracker = ExternalTimeTracker.create(request, this.getTransaction().getWallClockStartTimeMs());
        this.request = request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public void transactionActivityWithResponseFinished() {
        if (this.request != null && this.responseRecorded.compareAndSet(false, true)) {
            try {
                String filteredRequestURI;
                this.getUri();
                this.setStatus();
                this.freezeStatus();
                this.setStatusMessage();
                this.recordParameters();
                this.storeReferrer();
                this.recordCustomHeaders();
                this.storeHeader("Accept", "request.headers.accept");
                this.storeHeader("Host", "request.headers.host");
                this.storeHeader("User-Agent", "request.headers.userAgent");
                this.storeHeader("Content-Length", "request.headers.contentLength");
                this.storeMethod();
                this.storeResponseContentType();
                if (this.getStatus() > 0) {
                    this.getTransaction().getAgentAttributes().put("httpResponseCode", String.valueOf(this.getStatus()));
                }
                if (this.getStatusMessage() != null) {
                    this.getTransaction().getAgentAttributes().put("httpResponseMessage", this.getStatusMessage());
                }
                if ((filteredRequestURI = this.filterRequestURI()) != null && !filteredRequestURI.isEmpty()) {
                    this.getTransaction().getAgentAttributes().put("request.uri", filteredRequestURI);
                }
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, e, "Exception when reporting request/response information.");
            }
            finally {
                this.request = null;
                this.response = null;
            }
        }
    }

    @Override
    public void transactionFinished(String transactionName, TransactionStats stats) {
        this.transactionActivityWithResponseFinished();
        this.doRecordMetrics(transactionName, stats);
    }

    private void recordParameters() {
        try {
            ServletUtils.recordParameters(this.getTransaction(), this.request);
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Error recording parameters for transaction");
        }
    }

    @Override
    public final String getUri() {
        if (this.requestURI == null) {
            this.requestURI = this.initializeRequestURI();
        }
        return this.requestURI;
    }

    @Override
    public void setTransactionName() {
        Tracer rootTracer;
        if (Transaction.isDummyRequest(this.request) && (rootTracer = this.getTransaction().getRootTracer()) != null) {
            rootTracer.nameTransaction(TransactionNamePriority.REQUEST_URI);
        }
        TransactionNamer tn = WebTransactionNamer.create(this.getTransaction(), this.filterRequestURI());
        tn.setTransactionName();
    }

    private String filterRequestURI() {
        return ServiceFactory.getAttributesService().filterRequestUri(this.getTransaction().getApplicationName(), "attributes", this.getUri());
    }

    private String initializeRequestURI() {
        String result = UNKNOWN_URI;
        if (this.request == null) {
            return result;
        }
        try {
            String uri = this.request.getRequestURI();
            if (uri == null || uri.length() == 0) {
                Agent.LOG.log(Level.FINER, "requestURI is null: setting requestURI to {0}", result);
            } else {
                result = ServiceFactory.getNormalizationService().getUrlBeforeParameters(uri);
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINER, "Error calling requestURI: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
            result = UNKNOWN_URI;
        }
        return result;
    }

    private void storeReferrer() {
        try {
            String referer = this.request.getHeader("Referer");
            if (referer != null) {
                referer = referer.split("\\;")[0];
                referer = referer.split("\\?")[0];
                this.getTransaction().getAgentAttributes().put("request.headers.referer", referer);
            }
        }
        catch (Throwable e) {
            Agent.LOG.finer("Error getting referer: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
        }
    }

    private void storeHeader(String headerName, String attributeName) {
        try {
            String headerVal = this.request.getHeader(headerName);
            if (headerVal != null) {
                this.getTransaction().getAgentAttributes().put(attributeName, headerVal);
            }
        }
        catch (Throwable e) {
            Agent.LOG.finer("Error getting HTTP " + headerName + " header: " + e.toString());
            Agent.LOG.log(Level.FINEST, e.toString(), e);
        }
    }

    private void recordCustomHeaders() {
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (agentConfig.isHighSecurity()) {
            return;
        }
        Set<CustomRequestHeaderConfig> headerConfigs = agentConfig.getTransactionEventsConfig().getRequestHeaderConfigs();
        try {
            for (CustomRequestHeaderConfig config : headerConfigs) {
                String headerName = config.getHeaderName();
                String headerVal = this.request.getHeader(headerName);
                String headerAlias = config.getHeaderAlias();
                if (headerVal != null) {
                    if (headerAlias != null) {
                        this.getTransaction().getUserAttributes().put(headerAlias, headerVal);
                        continue;
                    }
                    this.getTransaction().getUserAttributes().put(headerName, headerVal);
                    continue;
                }
                Agent.LOG.log(Level.FINE, MessageFormat.format("{0} header value was null, so it will not be included", headerName));
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, "Error recording one of header or alias from custom request headers.");
        }
    }

    private void storeMethod() {
        if (this.request instanceof ExtendedRequest) {
            try {
                String method = ((ExtendedRequest)this.request).getMethod();
                if (method != null) {
                    this.getTransaction().getAgentAttributes().put("request.method", method);
                }
            }
            catch (Throwable e) {
                Agent.LOG.finer("Error getting HTTP method: " + e.toString());
                Agent.LOG.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    private void storeResponseContentType() {
        if (this.response != null) {
            try {
                String contentType = this.response.getContentType();
                if (contentType != null) {
                    this.getTransaction().getAgentAttributes().put("response.headers.contentType", contentType);
                }
            }
            catch (Throwable e) {
                Agent.LOG.finer("Error getting HTTP response ContentType: " + e.toString());
                Agent.LOG.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    public void freezeStatus() {
        this.statusCodePolicy = FREEZE_STATUS_CODE_POLICY;
        Agent.LOG.log(Level.FINER, "Freezing status code to {0}", this.getStatus());
    }

    private void setStatus() {
        if (this.response != null) {
            try {
                this.setStatus(this.response.getStatus());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, "Failed to get response status code {0}", e.toString());
            }
        }
    }

    private void setStatusMessage() {
        if (this.response != null && this.getStatusMessage() == null && this.getStatus() >= 400) {
            try {
                this.setStatusMessage(this.response.getStatusMessage());
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, "Failed to get response status message {0}", e.toString());
            }
        }
    }

    private void doRecordMetrics(String transactionName, TransactionStats stats) {
        this.recordHeaderMetrics(stats);
        this.recordApdexMetrics(transactionName, stats);
        this.recordDispatcherMetrics(transactionName, stats);
    }

    public void recordHeaderMetrics(TransactionStats statsEngine) {
        this.externalTimeTracker.recordMetrics(statsEngine);
    }

    public long getQueueTime() {
        return this.externalTimeTracker.getExternalTime();
    }

    private void recordDispatcherMetrics(String frontendMetricName, TransactionStats stats) {
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        long frontendTimeInNanos = this.getTransaction().getTransactionTimer().getResponseTimeInNanos();
        stats.getUnscopedStats().getOrCreateResponseTimeStats(frontendMetricName).recordResponseTimeInNanos(frontendTimeInNanos);
        stats.getUnscopedStats().getOrCreateResponseTimeStats("WebTransaction").recordResponseTimeInNanos(frontendTimeInNanos);
        stats.getUnscopedStats().getOrCreateResponseTimeStats("HttpDispatcher").recordResponseTimeInNanos(frontendTimeInNanos);
        if (this.getStatus() > 0) {
            String metricName = "Network/Inbound/StatusCode/" + this.getStatus();
            stats.getUnscopedStats().getOrCreateResponseTimeStats(metricName).recordResponseTimeInNanos(frontendTimeInNanos);
        }
        if (this.hasTransactionName(frontendMetricName, "WebTransaction")) {
            Object cpuTime;
            long lastByteDurNs;
            String totalTimeMetric = this.getTransName(frontendMetricName, "WebTransaction", "TotalTime");
            stats.getUnscopedStats().getOrCreateResponseTimeStats(totalTimeMetric).recordResponseTimeInNanos(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos());
            long firstByteDurNs = this.getTransaction().getTransactionTimer().getTimeToFirstByteInNanos();
            if (firstByteDurNs > 0L) {
                String firstByteMetricName = this.getTransName(frontendMetricName, "WebTransaction", "TimeToFirstByte");
                stats.getUnscopedStats().getOrCreateResponseTimeStats(firstByteMetricName).recordResponseTimeInNanos(firstByteDurNs);
                stats.getUnscopedStats().getOrCreateResponseTimeStats("WebTransactionTimeToFirstByte").recordResponseTimeInNanos(firstByteDurNs);
            }
            if ((lastByteDurNs = this.getTransaction().getTransactionTimer().getTimetoLastByteInNanos()) > 0L) {
                String lastByteMetricName = this.getTransName(frontendMetricName, "WebTransaction", "TimeToLastByte");
                stats.getUnscopedStats().getOrCreateResponseTimeStats(lastByteMetricName).recordResponseTimeInNanos(lastByteDurNs);
                stats.getUnscopedStats().getOrCreateResponseTimeStats("WebTransactionTimeToLastByte").recordResponseTimeInNanos(lastByteDurNs);
            }
            if ((cpuTime = this.getTransaction().getIntrinsicAttributes().get("cpuTime")) != null && cpuTime instanceof Long) {
                long val = (Long)cpuTime;
                String cpuMetricName = "CPU/" + frontendMetricName;
                stats.getUnscopedStats().getOrCreateResponseTimeStats(cpuMetricName).recordResponseTimeInNanos(val);
                stats.getUnscopedStats().getOrCreateResponseTimeStats("CPU/WebTransaction").recordResponseTimeInNanos(val);
            }
        }
        stats.getUnscopedStats().getOrCreateResponseTimeStats("WebTransactionTotalTime").recordResponseTimeInNanos(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos());
    }

    private void recordApdexMetrics(String frontendMetricName, TransactionStats stats) {
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        if (!this.getTransaction().getAgentConfig().isApdexTSet()) {
            return;
        }
        if (this.isIgnoreApdex()) {
            Agent.LOG.log(Level.FINE, "Ignoring transaction for Apdex {0}", frontendMetricName);
            return;
        }
        String frontendApdexMetricName = this.getApdexMetricName(frontendMetricName, "WebTransaction", "Apdex");
        if (frontendApdexMetricName == null || frontendApdexMetricName.length() == 0) {
            return;
        }
        long apdexT = this.getTransaction().getAgentConfig().getApdexTInMillis(frontendMetricName);
        ApdexStats apdexStats = stats.getUnscopedStats().getApdexStats(frontendApdexMetricName);
        ApdexStats overallApdexStats = stats.getUnscopedStats().getApdexStats("Apdex");
        if (this.isApdexFrustrating()) {
            apdexStats.recordApdexFrustrated();
            overallApdexStats.recordApdexFrustrated();
        } else {
            long responseTimeInMillis = this.getTransaction().getTransactionTimer().getResponseTimeInMilliseconds() + this.externalTimeTracker.getExternalTime();
            apdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
            overallApdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
        }
    }

    public boolean isApdexFrustrating() {
        return this.getTransaction().isErrorReportableAndNotIgnored() && this.getTransaction().isErrorNotExpected();
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.getTransaction().getAgentConfig().getRequestTransactionTracerConfig();
    }

    @Override
    public boolean isWebTransaction() {
        return true;
    }

    @Override
    public String getCookieValue(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getCookieValue(name);
    }

    @Override
    public String getHeader(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getHeader(name);
    }

    public void setStatus(int statusCode) {
        Agent.LOG.log(Level.FINEST, "Called setStatus: {0}", statusCode);
        if (statusCode <= 0 || statusCode == this.statusCode) {
            return;
        }
        int nextStatusCode = this.statusCodePolicy.nextStatus(this.statusCode, statusCode);
        if (nextStatusCode != this.statusCode) {
            Agent.LOG.log(Level.FINER, "Setting status to {0}", nextStatusCode);
        }
        this.statusCode = nextStatusCode;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

