/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.util.asm.BenignClassReadException;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.weave.UtilityClass;
import java.util.Collection;
import java.util.logging.Level;

public class InstrumentationContextClassMatcherHelper {
    public boolean isMatch(Collection<ClassMatchVisitorFactory> matchers, Class<?> clazz) {
        if (clazz.isArray()) {
            return false;
        }
        String className = clazz.getName();
        if (className.startsWith("com.newrelic.api.agent") || className.startsWith("com.newrelic.agent.bridge") || className.startsWith("com.newrelic.weave.") || className.startsWith("com.nr.agent") || className.endsWith("_nr_ext") || className.endsWith("_nr_anon")) {
            return false;
        }
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = AgentBridge.getAgent().getClass().getClassLoader();
        }
        InstrumentationContext context = new InstrumentationContext(null, null, null);
        try {
            ClassReader reader = Utils.readClass(clazz);
            context.match(loader, clazz, reader, matchers);
            return !context.getMatches().isEmpty();
        }
        catch (BenignClassReadException ex) {
            return false;
        }
        catch (Exception ex) {
            if (this.isMissingResourceExpected(className)) {
                return false;
            }
            if (clazz.isAnnotationPresent(UtilityClass.class)) {
                return false;
            }
            Agent.LOG.log(Level.FINER, "Unable to read {0}", className);
            Agent.LOG.log(Level.FINEST, ex, "Unable to read {0}", className);
            return false;
        }
    }

    public boolean isMissingResourceExpected(String className) {
        if (className.startsWith("com.newrelic") || className.startsWith("weave.") || className.startsWith("com.nr.instrumentation")) {
            return true;
        }
        if (className.contains("$$Lambda$") || className.contains("LambdaForm$")) {
            return true;
        }
        return className.contains("GeneratedConstructorAccessor") || className.contains("GeneratedMethodAccessor") || className.contains("BoundMethodHandle$") || className.startsWith("jdk.jfr.internal.handlers.EventHandler");
    }
}

