/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.ejb3;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.util.asm.AnnotationDetails;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.agent.util.asm.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EJBAnnotationVisitor
implements ClassMatchVisitorFactory {
    private static final Set<String> EJB_DESCRIPTORS = ImmutableSet.of(Type.getObjectType("javax/ejb/Stateless").getDescriptor(), Type.getObjectType("javax/ejb/Stateful").getDescriptor());
    private static final String EJB_REMOTE_INTERFCE_DESCRIPTOR = Type.getObjectType("javax/ejb/Remote").getDescriptor();
    private static final String EJB_LOCAL_INTERFCE_DESCRIPTOR = Type.getObjectType("javax/ejb/Local").getDescriptor();
    private static final Object EJB_INTERFACE = Type.getObjectType("javax/ejb/SessionBean");

    @Override
    public ClassVisitor newClassMatchVisitor(final ClassLoader loader, Class<?> classBeingRedefined, final ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(458752, cv){
            Set<Method> methodsToInstrument;
            {
                super(x0, x1);
                this.methodsToInstrument = new HashSet<Method>();
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                for (String interfaceName : interfaces) {
                    if (!interfaceName.equals(EJB_INTERFACE)) continue;
                    try {
                        URL classResource = Utils.getClassResource(loader, interfaceName);
                        if (classResource == null) continue;
                        ClassStructure classStructure = ClassStructure.getClassStructure(classResource, 15);
                        this.collectMethodsToInstrument(classStructure);
                    }
                    catch (IOException e) {
                        if (!Agent.LOG.isFinerEnabled()) continue;
                        Agent.LOG.finer("EJB class match visitor: " + e.toString());
                    }
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (EJB_DESCRIPTORS.contains(desc)) {
                    for (String interfaceName : reader.getInterfaces()) {
                        try {
                            ClassStructure classStructure;
                            Map<String, AnnotationDetails> annotations;
                            URL classResource = Utils.getClassResource(loader, interfaceName);
                            if (classResource == null || !(annotations = (classStructure = ClassStructure.getClassStructure(classResource, 15)).getClassAnnotations()).containsKey(EJB_REMOTE_INTERFCE_DESCRIPTOR) && !annotations.containsKey(EJB_LOCAL_INTERFCE_DESCRIPTOR)) continue;
                            this.collectMethodsToInstrument(classStructure);
                        }
                        catch (IOException e) {
                            if (!Agent.LOG.isFinerEnabled()) continue;
                            Agent.LOG.finer("EJB annotation visitor: " + e.toString());
                        }
                    }
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Method method = new Method(name, desc);
                if (this.methodsToInstrument.contains(method)) {
                    if (Agent.LOG.isFinerEnabled()) {
                        Agent.LOG.finer("Creating a tracer for " + reader.getClassName() + '.' + method);
                    }
                    context.addTrace(method, TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(EJBAnnotationVisitor.class.getName()).build());
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            private void collectMethodsToInstrument(ClassStructure classStructure) {
                for (Method m3 : classStructure.getMethods()) {
                    this.methodsToInstrument.add(m3);
                }
            }
        };
    }
}

