/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.TransactionSegmentTerms;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class NormalizationRuleFactory {
    public static List<NormalizationRule> getUrlRules(String appName, List<Map<String, Object>> rulesData) {
        try {
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            if (rules.isEmpty()) {
                Agent.LOG.warning("The agent did not receive any url rules from the New Relic server.");
            } else {
                String msg = MessageFormat.format("Received {0} url rule(s) for {1}", rules.size(), appName);
                Agent.LOG.fine(msg);
            }
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting url rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return Collections.emptyList();
        }
    }

    public static List<NormalizationRule> getMetricNameRules(String appName, List<Map<String, Object>> rulesData) {
        try {
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            String msg = MessageFormat.format("Received {0} metric name rule(s) for {1}", rules.size(), appName);
            Agent.LOG.fine(msg);
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting metric name rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return Collections.emptyList();
        }
    }

    public static List<NormalizationRule> getTransactionNameRules(String appName, List<Map<String, Object>> rulesData) {
        try {
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            String msg = MessageFormat.format("Received {0} transaction name rule(s) for {1}", rules.size(), appName);
            Agent.LOG.fine(msg);
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting transaction name rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return Collections.emptyList();
        }
    }

    public static List<TransactionSegmentTerms> getTransactionSegmentTermRules(String appName, List<Map<String, Object>> rulesData) {
        ArrayList<TransactionSegmentTerms> list = new ArrayList<TransactionSegmentTerms>();
        for (Map<String, Object> map : rulesData) {
            List terms = (List)map.get("terms");
            String prefix = (String)map.get("prefix");
            TransactionSegmentTerms tst = new TransactionSegmentTerms(prefix, ImmutableSet.copyOf(terms));
            list.add(tst);
        }
        Agent.LOG.log(Level.FINE, "Received {0} transaction segment rule(s) for {1}", list.size(), appName);
        return list;
    }

    private static List<NormalizationRule> createRules(String appName, List<Map<String, Object>> rulesData) throws Exception {
        ArrayList<NormalizationRule> rules = new ArrayList<NormalizationRule>();
        for (Map<String, Object> ruleData : rulesData) {
            NormalizationRule rule = NormalizationRuleFactory.createRule(ruleData);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Adding rule for \"{0}\": \"{1}\"", appName, rule);
                Agent.LOG.finer(msg);
            }
            rules.add(rule);
        }
        NormalizationRuleFactory.sortRules(rules);
        return rules;
    }

    private static void sortRules(List<NormalizationRule> rules) {
        Collections.sort(rules, new Comparator<NormalizationRule>(){

            @Override
            public int compare(NormalizationRule lhs, NormalizationRule rhs) {
                Integer lhsOrder = lhs.getOrder();
                Integer rhsOrder = rhs.getOrder();
                return lhsOrder.compareTo(rhsOrder);
            }
        });
    }

    private static NormalizationRule createRule(Map<String, Object> ruleData) {
        Boolean terminateChain;
        Boolean ignore;
        Boolean replaceAll;
        Boolean eachSegment = (Boolean)ruleData.get("each_segment");
        if (eachSegment == null) {
            eachSegment = Boolean.FALSE;
        }
        if ((replaceAll = (Boolean)ruleData.get("replace_all")) == null) {
            replaceAll = Boolean.FALSE;
        }
        if ((ignore = (Boolean)ruleData.get("ignore")) == null) {
            ignore = Boolean.FALSE;
        }
        if ((terminateChain = (Boolean)ruleData.get("terminate_chain")) == null) {
            terminateChain = Boolean.TRUE;
        }
        int order = ((Number)ruleData.get("eval_order")).intValue();
        String matchExpression = (String)ruleData.get("match_expression");
        String replacement = (String)ruleData.get("replacement");
        return new NormalizationRule(matchExpression, replacement, ignore, order, terminateChain, eachSegment, replaceAll);
    }
}

