/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.rpm;

import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.rpm.RPMConnectionService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class RPMConnectionServiceImpl
extends AbstractService
implements RPMConnectionService {
    public static final String RPM_CONNECTION_THREAD_NAME = "New Relic RPM Connection Service";
    public static final long INITIAL_APP_SERVER_PORT_DELAY = 5L;
    public static final long SUBSEQUENT_APP_SERVER_PORT_DELAY = 5L;
    public static final long APP_SERVER_PORT_TIMEOUT = 120L;
    public static final long MIN_CONNECT_ATTEMPT_INTERVAL = 5L;
    private final ScheduledExecutorService scheduledExecutor;

    public RPMConnectionServiceImpl() {
        super(RPMConnectionService.class.getSimpleName());
        DefaultThreadFactory threadFactory2 = new DefaultThreadFactory(RPM_CONNECTION_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void connect(IRPMService rpmService) {
        RPMConnectionTask connectionTask = new RPMConnectionTask(rpmService);
        connectionTask.start();
    }

    @Override
    public void connectImmediate(IRPMService rpmService) {
        RPMConnectionTask connectionTask = new RPMConnectionTask(rpmService);
        connectionTask.startImmediate();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public long getInitialAppServerPortDelay() {
        return 5L;
    }

    public long getAppServerPortTimeout() {
        return 120L;
    }

    private final class RPMConnectionTask
    implements Runnable {
        private final IRPMService rpmService;
        private final AtomicReference<ScheduledFuture<?>> appServerPortTask = new AtomicReference();
        private final AtomicReference<ScheduledFuture<?>> appServerPortTimeoutTask = new AtomicReference();
        private final AtomicReference<ScheduledFuture<?>> connectTask = new AtomicReference();
        private final AtomicBoolean connectTaskStarted = new AtomicBoolean();
        private final int[] BACKOFF_INTERVAL_IN_SEC = new int[]{0, 15, 15, 30, 60, 120, 300};
        private final int MAX_BACKOFF_DELAY = 300;
        private final AtomicLong lastConnectionAttempt = new AtomicLong(0L);
        private final AtomicInteger backoffIndex = new AtomicInteger(0);

        private RPMConnectionTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        @Override
        public void run() {
        }

        private void start() {
            if (!this.rpmService.isMainApp()) {
                this.startImmediate();
            } else if (this.isSyncStartup() || this.isLaspEnabled() || this.isHighSecurityEnabled()) {
                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Not waiting for application server port");
                this.startSync();
            } else {
                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Waiting for application server port");
                this.appServerPortTask.set(this.scheduleAppServerPortTask());
                this.appServerPortTimeoutTask.set(this.scheduleAppServerPortTimeoutTask());
            }
        }

        private void startSync() {
            if (this.isConnected() || this.attemptConnection()) {
                return;
            }
            this.startImmediate();
        }

        private void startImmediate() {
            this.connectTask.set(this.scheduleConnectTask());
        }

        private void stop() {
            RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Stopping New Relic connection task for {0}", this.rpmService.getApplicationName());
            ScheduledFuture<?> handle = this.appServerPortTask.get();
            if (handle != null) {
                handle.cancel(false);
            }
            if ((handle = this.connectTask.get()) != null) {
                handle.cancel(false);
            }
            if ((handle = this.appServerPortTimeoutTask.get()) != null) {
                handle.cancel(false);
            }
            this.lastConnectionAttempt.set(0L);
            this.backoffIndex.set(0);
        }

        private ScheduledFuture<?> scheduleAppServerPortTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.scheduleWithFixedDelay(SafeWrappers.safeRunnable(new Runnable(){

                @Override
                public void run() {
                    if (RPMConnectionTask.this.isConnected()) {
                        RPMConnectionTask.this.stop();
                        return;
                    }
                    if (RPMConnectionTask.this.hasAppServerPort() && !RPMConnectionTask.this.connectTaskStarted()) {
                        RPMConnectionTask.this.stop();
                        RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Discovered application server port");
                        RPMConnectionTask.this.connectTask.set(RPMConnectionTask.this.scheduleConnectTask());
                    }
                }
            }), RPMConnectionServiceImpl.this.getInitialAppServerPortDelay(), 5L, TimeUnit.SECONDS);
        }

        private ScheduledFuture<?> scheduleAppServerPortTimeoutTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.schedule(SafeWrappers.safeRunnable(new Runnable(){

                @Override
                public void run() {
                    if (!RPMConnectionTask.this.connectTaskStarted()) {
                        RPMConnectionTask.this.stop();
                        if (!RPMConnectionTask.this.isConnected()) {
                            if (!RPMConnectionTask.this.hasAppServerPort()) {
                                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Gave up waiting for application server port");
                            }
                            RPMConnectionTask.this.connectTask.set(RPMConnectionTask.this.scheduleConnectTask());
                        }
                    }
                }
            }), RPMConnectionServiceImpl.this.getAppServerPortTimeout(), TimeUnit.SECONDS);
        }

        private ScheduledFuture<?> scheduleConnectTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.scheduleWithFixedDelay(SafeWrappers.safeRunnable(new Runnable(){

                @Override
                public void run() {
                    if (RPMConnectionTask.this.shouldAttemptConnection() && RPMConnectionTask.this.attemptConnection()) {
                        RPMConnectionTask.this.stop();
                    }
                }
            }), 0L, 5L, TimeUnit.SECONDS);
        }

        private boolean isMainAppConnected() {
            return ServiceFactory.getRPMService().isConnected();
        }

        private boolean isConnected() {
            return this.rpmService.isConnected();
        }

        private boolean connectTaskStarted() {
            return this.connectTaskStarted.getAndSet(true);
        }

        private boolean hasAppServerPort() {
            return this.getEnvironment().getAgentIdentity().getServerPort() != null;
        }

        private boolean isSyncStartup() {
            ConfigService configService = ServiceFactory.getConfigService();
            AgentConfig config = configService.getAgentConfig(this.rpmService.getApplicationName());
            return config.isSyncStartup();
        }

        private boolean isLaspEnabled() {
            return ServiceFactory.getConfigService().getDefaultAgentConfig().laspEnabled();
        }

        private boolean isHighSecurityEnabled() {
            return ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity();
        }

        private boolean shouldAttemptConnection() {
            if (!this.shouldAttemptBackoff()) {
                return false;
            }
            if (this.rpmService.isMainApp() || this.isMainAppConnected()) {
                return !this.isConnected();
            }
            return false;
        }

        private boolean shouldAttemptBackoff() {
            this.lastConnectionAttempt.compareAndSet(0L, System.currentTimeMillis());
            long timeSinceLastConnectionAttemptInSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastConnectionAttempt.get());
            if (timeSinceLastConnectionAttemptInSeconds >= (long)this.BACKOFF_INTERVAL_IN_SEC[this.backoffIndex.get()]) {
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Agent/Collector/Connect/BackoffAttempts", 1));
                if (timeSinceLastConnectionAttemptInSeconds < 300L) {
                    this.backoffIndex.incrementAndGet();
                }
                this.lastConnectionAttempt.set(System.currentTimeMillis());
                return true;
            }
            return false;
        }

        private boolean attemptConnection() {
            try {
                this.rpmService.launch();
                return true;
            }
            catch (Throwable e) {
                RPMConnectionServiceImpl.this.getLogger().log(Level.INFO, "Failed to connect to {0} for {1}: {2}", this.rpmService.getHostString(), this.rpmService.getApplicationName(), e.toString());
                RPMConnectionServiceImpl.this.getLogger().log(Level.FINEST, e, e.toString());
                return false;
            }
        }

        private Environment getEnvironment() {
            return ServiceFactory.getEnvironmentService().getEnvironment();
        }
    }
}

