/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.TransactionEventsConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.model.CountedDuration;
import com.newrelic.agent.model.PathHashes;
import com.newrelic.agent.model.SyntheticsIds;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.EventService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AdaptiveSampling;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.TransactionDataToDistributedTraceIntrinsics;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.analytics.TransactionEventBuilder;
import com.newrelic.agent.service.analytics.TransactionEventHarvestableImpl;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.transport.HttpError;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class TransactionEventsService
extends AbstractService
implements EventService,
TransactionListener,
AgentConfigListener {
    private final TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics;
    private volatile TransactionEventsConfig config;
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<TransactionEvent>> reservoirForApp = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<TransactionEvent>> syntheticsListForApp = new ConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    final ArrayDeque<DistributedSamplingPriorityQueue<TransactionEvent>> pendingSyntheticsHeaps = new ArrayDeque();
    static final int MAX_UNSENT_SYNTHETICS_HOLDERS = 25;
    static final int MAX_SYNTHETIC_EVENTS_PER_APP = 200;
    private volatile LoadingCache<String, String> transactionNameCache;
    private volatile int maxSamplesStored;
    private List<Harvestable> harvestables = new ArrayList<Harvestable>();

    public TransactionEventsService(TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics) {
        super(TransactionEventsService.class.getSimpleName());
        this.transactionDataToDistributedTraceIntrinsics = transactionDataToDistributedTraceIntrinsics;
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.config = agentConfig.getTransactionEventsConfig();
        this.maxSamplesStored = this.config.getMaxSamplesStored();
        this.isEnabledForApp.put(agentConfig.getApplicationName(), this.config.isEnabled());
        this.transactionNameCache = TransactionEventsService.createTransactionNameCache(this.maxSamplesStored);
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
    }

    public void addHarvestableToService(String appName) {
        TransactionEventHarvestableImpl harvestable = new TransactionEventHarvestableImpl(this, appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestable);
        this.harvestables.add(harvestable);
    }

    private static LoadingCache<String, String> createTransactionNameCache(int maxSamplesStored) {
        return CacheBuilder.newBuilder().maximumSize(maxSamplesStored).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) throws Exception {
                return key;
            }
        });
    }

    @VisibleForTesting
    void configureHarvestables(long reportPeriodInMillis, int maxSamplesStored) {
        for (Harvestable h2 : this.harvestables) {
            h2.configure(reportPeriodInMillis, maxSamplesStored);
        }
    }

    @Override
    public void clearReservoir() {
        this.reservoirForApp.clear();
    }

    @Override
    public final boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.config.isEnabled()) {
            ServiceFactory.getTransactionService().addTransactionListener(this);
            ServiceFactory.getConfigService().addIAgentConfigListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.removeHarvestables();
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        this.reservoirForApp.clear();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
        this.transactionNameCache = TransactionEventsService.createTransactionNameCache(maxSamplesStored);
    }

    @Override
    public void harvestEvents(final String appName) {
        long startTimeInNanos = System.nanoTime();
        this.beforeHarvestSynthetics(appName);
        int targetStored = this.config.getTargetSamplesStored();
        DistributedSamplingPriorityQueue<TransactionEvent> currentReservoir = this.reservoirForApp.get(appName);
        int decidedLast = AdaptiveSampling.decidedLast(currentReservoir, targetStored);
        final DistributedSamplingPriorityQueue reservoirToSend = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue(appName, "Transaction Event Service", this.maxSamplesStored, decidedLast, targetStored));
        if (reservoirToSend != null && reservoirToSend.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendAnalyticsEvents(this.maxSamplesStored, reservoirToSend.getNumberOfTries(), Collections.unmodifiableList(reservoirToSend.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        TransactionEventsService.this.recordSupportabilityMetrics(statsEngine, durationInNanos, reservoirToSend);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                });
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send events for regular transactions. Data for this harvest will be resampled and the operation will be retried.", e);
                    currentReservoir = this.reservoirForApp.get(appName);
                    currentReservoir.retryAll(reservoirToSend);
                } else {
                    reservoirToSend.clear();
                    Agent.LOG.log(Level.FINE, "Unable to send events for regular transactions. Data for this harvest will be dropped.", e);
                }
            }
            catch (Exception e) {
                reservoirToSend.clear();
                Agent.LOG.log(Level.FINE, "Unable to send events for regular transactions. Data for this harvest will be dropped.", e);
            }
        }
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/TransactionEvent/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/AnalyticEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/AnalyticEventData/HarvestLimit";
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, DistributedSamplingPriorityQueue<TransactionEvent> reservoir) {
        statsEngine.getStats("Supportability/Events/TransactionEvent/Sent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/Events/TransactionEvent/Seen").incrementCallCount(reservoir.getNumberOfTries());
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/TransactionEvent/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    private void beforeHarvestSynthetics(String appName) {
        DistributedSamplingPriorityQueue<TransactionEvent> toSend;
        DistributedSamplingPriorityQueue<TransactionEvent> currentReservoir = this.syntheticsListForApp.get(appName);
        int decidedLast = AdaptiveSampling.decidedLast(currentReservoir, this.config.getTargetSamplesStored());
        DistributedSamplingPriorityQueue current = this.syntheticsListForApp.put(appName, new DistributedSamplingPriorityQueue(appName, "Synthetics Event Service", 200, decidedLast, this.config.getTargetSamplesStored()));
        if (current != null && current.size() > 0) {
            if (this.pendingSyntheticsHeaps.size() < 25) {
                this.pendingSyntheticsHeaps.add(current);
            } else {
                Agent.LOG.fine("Some synthetic transaction events were discarded.");
            }
        }
        int maxToSend = 5;
        for (int nSent = 0; nSent < 5 && (toSend = this.pendingSyntheticsHeaps.poll()) != null; ++nSent) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendAnalyticsEvents(200, toSend.getNumberOfTries(), Collections.unmodifiableList(toSend.asList()));
                ++nSent;
                continue;
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send events for synthetic transactions. Unsent events will be included in the next harvest.", e);
                    this.pendingSyntheticsHeaps.add(toSend);
                    break;
                }
                Agent.LOG.log(Level.FINE, "Unable to send events for synthetic transactions. Unsent events will be dropped.", e);
                break;
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, "Unable to send events for synthetic transactions. Unsent events will be dropped.", e);
                break;
            }
        }
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled = (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = config.getTransactionEventsConfig().isEnabled();
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        String appName = transactionData.getApplicationName();
        if (!this.getIsEnabledForApp(transactionData.getAgentConfig(), appName)) {
            this.reservoirForApp.remove(appName);
            return;
        }
        boolean persisted = false;
        int target = this.config.getTargetSamplesStored();
        if (transactionData.isSyntheticTransaction()) {
            DistributedSamplingPriorityQueue<TransactionEvent> currentSyntheticsList = this.syntheticsListForApp.get(appName);
            while (currentSyntheticsList == null) {
                this.syntheticsListForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, "Synthetics Event Service", 200, 0, target));
                currentSyntheticsList = this.syntheticsListForApp.get(appName);
            }
            persisted = currentSyntheticsList.add(this.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
            String msg = MessageFormat.format("Added Synthetics transaction event: {0}, persisted: {1}", transactionData, persisted);
            Agent.LOG.finest(msg);
        }
        if (!persisted) {
            DistributedSamplingPriorityQueue<TransactionEvent> currentReservoir = this.reservoirForApp.get(appName);
            while (currentReservoir == null) {
                this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, "Transaction Event Service", this.maxSamplesStored, 0, target));
                currentReservoir = this.reservoirForApp.get(appName);
            }
            if (!currentReservoir.isFull() || currentReservoir.getMinPriority() < transactionData.getPriority()) {
                currentReservoir.add(this.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
            } else {
                currentReservoir.incrementNumberOfTries();
            }
        }
    }

    private String getMetricName(TransactionData transactionData) {
        String metricName = transactionData.getBlameOrRootMetricName();
        try {
            metricName = this.transactionNameCache.get(metricName);
        }
        catch (ExecutionException e) {
            Agent.LOG.finest("Error fetching cached transaction name: " + e.toString());
        }
        return metricName;
    }

    public TransactionEvent createEvent(TransactionData transactionData, TransactionStats transactionStats, String metricName) {
        boolean attributesEnabled;
        long startTime = transactionData.getWallClockStartTimeMs();
        long durationInNanos = transactionData.getLegacyDuration();
        boolean distributedTracingEnabled = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isEnabled();
        Integer port = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getServerPort();
        String syntheticsResourceId = transactionData.getSyntheticsResourceId();
        String syntheticsMonitorId = transactionData.getSyntheticsMonitorId();
        String syntheticsJobId = transactionData.getSyntheticsJobId();
        SyntheticsIds syntheticsIds = new SyntheticsIds(syntheticsResourceId, syntheticsMonitorId, syntheticsJobId);
        TransactionEventBuilder eventBuilder = new TransactionEventBuilder().setAppName(transactionData.getApplicationName()).setTimestamp(startTime).setName(metricName).setDuration((float)durationInNanos / 1.0E9f).setGuid(transactionData.getGuid()).setReferringGuid(transactionData.getReferrerGuid()).setPort(port).setTripId(transactionData.getTripId()).setApdexPerfZone(transactionData.getApdexPerfZone()).setSyntheticsIds(syntheticsIds).setError(transactionData.hasReportableErrorThatIsNotIgnored()).setpTotalTime((float)transactionData.getTransactionTime().getTotalSumTimeInNanos() / 1.0E9f).setTimeoutCause(transactionData.getTransaction().getTimeoutCause()).setPriority(transactionData.getPriority());
        if (distributedTracingEnabled) {
            DistributedTracePayloadImpl inboundDistributedTracePayload = transactionData.getInboundDistributedTracePayload();
            eventBuilder = eventBuilder.setDecider(inboundDistributedTracePayload == null || inboundDistributedTracePayload.priority == null);
            Map<String, Object> distributedTraceServiceIntrinsics = this.transactionDataToDistributedTraceIntrinsics.buildDistributedTracingIntrinsics(transactionData, true);
            eventBuilder = eventBuilder.setDistributedTraceIntrinsics(distributedTraceServiceIntrinsics);
        }
        if (attributesEnabled = ServiceFactory.getAttributesService().isAttributesEnabledForTransactionEvents(transactionData.getApplicationName())) {
            eventBuilder.putAllUserAttributes(transactionData.getUserAttributes());
        }
        Integer pathHash = null;
        if (transactionData.getTripId() != null) {
            pathHash = transactionData.generatePathHash();
        }
        PathHashes pathHashes = new PathHashes(pathHash, transactionData.getReferringPathHash(), transactionData.getAlternatePathHashes());
        eventBuilder.setPathHashes(pathHashes);
        if (transactionData.getTransactionTime().getTimeToFirstByteInNanos() > 0L) {
            float timeToFirstByte = (float)transactionData.getTransactionTime().getTimeToFirstByteInNanos() / 1.0E9f;
            eventBuilder.setTimeToFirstByte(timeToFirstByte);
        }
        if (transactionData.getTransactionTime().getTimetoLastByteInNanos() > 0L) {
            float timeToLastByte = (float)transactionData.getTransactionTime().getTimetoLastByteInNanos() / 1.0E9f;
            eventBuilder.setTimeToLastByte(timeToLastByte);
        }
        eventBuilder.setQueueDuration(TransactionEventsService.retrieveMetricIfExists(transactionStats, "WebFrontend/QueueTime").getTotal());
        float externalDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getTotal();
        float externalCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getCallCount();
        eventBuilder.setExternal(new CountedDuration(externalDuration, externalCallCount));
        float databaseDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getTotal();
        float databaseCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getCallCount();
        eventBuilder.setDatabase(new CountedDuration(databaseDuration, databaseCallCount));
        float gcCumulative = TransactionEventsService.retrieveMetricIfExists(transactionStats, "GC/cumulative").getTotal();
        eventBuilder.setGcCumulative(gcCumulative);
        TransactionEvent event = eventBuilder.build();
        if (attributesEnabled) {
            event.agentAttributes = transactionData.getAgentAttributes();
            event.agentAttributes.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
        return event;
    }

    private static CountStats retrieveMetricIfExists(TransactionStats transactionStats, String metricName) {
        if (!transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName)) {
            return NoCallCountStats.NO_STATS;
        }
        return transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(metricName);
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.isEnabledForApp.remove(appName);
        this.config = agentConfig.getTransactionEventsConfig();
    }

    public DistributedSamplingPriorityQueue<TransactionEvent> getDistributedSamplingReservoir(String appName) {
        return this.reservoirForApp.get(appName);
    }

    public DistributedSamplingPriorityQueue<TransactionEvent> getOrCreateDistributedSamplingReservoir(String appName) {
        int target;
        DistributedSamplingPriorityQueue<TransactionEvent> reservoir = this.reservoirForApp.get(appName);
        if (reservoir == null && (reservoir = this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, "Transaction Event Service", this.maxSamplesStored, 0, target = this.config.getTargetSamplesStored()))) == null) {
            reservoir = this.reservoirForApp.get(appName);
        }
        return reservoir;
    }

    private static class NoCallCountStats
    extends AbstractStats {
        static final NoCallCountStats NO_STATS = new NoCallCountStats();

        private NoCallCountStats() {
        }

        @Override
        public float getTotal() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getTotalExclusiveTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMinCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMaxCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public double getSumOfSquares() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void merge(StatsBase stats) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return NO_STATS;
        }
    }
}

