/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.util.ArrayList;
import java.util.Collection;

public class Strings {
    public static final String NEWRELIC_DEPENDENCY_INTERNAL_PACKAGE_PREFIX = "com/newrelic/agent/deps/";

    private Strings() {
    }

    public static Collection<String> trim(Collection<String> strings) {
        ArrayList<String> trimmedList = new ArrayList<String>(strings.size());
        for (String string : strings) {
            trimmedList.add(string.trim());
        }
        return trimmedList;
    }

    public static String unquoteDatabaseName(String s2) {
        int index = s2.indexOf(46);
        if (index > 0) {
            return Strings.unquote(s2.substring(0, index)) + '.' + Strings.unquote(s2.substring(index + 1));
        }
        return Strings.unquote(s2);
    }

    public static String removeBrackets(String s2) {
        return s2.replace("[", "").replace("]", "");
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s2 : strings) {
            length += s2.length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            if (strings[i].isEmpty()) continue;
            sb.append(delimiter).append(strings[i]);
        }
        return sb.toString();
    }

    public static String unquote(String string) {
        char last;
        if (string == null || string.length() < 2) {
            return string;
        }
        char first = string.charAt(0);
        if (first == (last = string.charAt(string.length() - 1)) && (first == '\"' || first == '\'' || first == '`')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String fixInternalClassName(String className) {
        if ((className = className.replace('.', '/')).startsWith(NEWRELIC_DEPENDENCY_INTERNAL_PACKAGE_PREFIX)) {
            return className.substring(NEWRELIC_DEPENDENCY_INTERNAL_PACKAGE_PREFIX.length());
        }
        return className;
    }
}

