/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.utilization.AWS;
import com.newrelic.agent.utilization.Azure;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.DataFetcher;
import com.newrelic.agent.utilization.DockerData;
import com.newrelic.agent.utilization.GCP;
import com.newrelic.agent.utilization.KubernetesData;
import com.newrelic.agent.utilization.PCF;
import com.newrelic.agent.utilization.UtilizationConfig;
import com.newrelic.agent.utilization.UtilizationData;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class UtilizationService
extends AbstractService {
    public static final String DETECT_AWS_KEY = "utilization.detect_aws";
    public static final String DETECT_DOCKER_KEY = "utilization.detect_docker";
    public static final String DETECT_PIVOTAL_CLOUD_FOUNDRY_KEY = "utilization.detect_pcf";
    public static final String DETECT_GOOGLE_CLOUD_PROVIDER_KEY = "utilization.detect_gcp";
    public static final String DETECT_AZURE_KEY = "utilization.detect_azure";
    public static final String DETECT_KUBERNETES_KEY = "utilization.detect_kubernetes";
    protected volatile UtilizationData utilizationData;
    private final String hostName;
    private final String fullHostName;
    private final ArrayList<String> ipAddress;
    private final String bootId;
    private final String dockerContainerId;
    private final int processorCount;
    private final Future<Long> totalRamInMibFuture;
    private final UtilizationConfig configData;
    private final KubernetesData kubernetesData;
    private final ExecutorService executor = Executors.newFixedThreadPool(2, new DefaultThreadFactory("New Relic Utilization Service", true));
    private Future<UtilizationData> future = null;
    private static final DockerData dockerData = new DockerData();
    private static final String THREAD_NAME = "New Relic Utilization Service";
    private final boolean isLinux;
    private final boolean detectAws;
    private final boolean detectDocker;
    private final boolean detectPcf;
    private final boolean detectGcp;
    private final boolean detectAzure;
    private final boolean detectKubernetes;
    private static final CloudUtility cloudUtility = new CloudUtility();
    private static final AWS aws = new AWS(cloudUtility);
    private static final PCF pcf = new PCF(cloudUtility);
    private static final GCP gcp = new GCP(cloudUtility);
    private static final Azure azure = new Azure(cloudUtility);

    public UtilizationService() {
        super(UtilizationService.class.getSimpleName());
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.detectAws = (Boolean)agentConfig.getValue(DETECT_AWS_KEY, Boolean.TRUE);
        this.detectDocker = (Boolean)agentConfig.getValue(DETECT_DOCKER_KEY, Boolean.TRUE);
        this.detectPcf = (Boolean)agentConfig.getValue(DETECT_PIVOTAL_CLOUD_FOUNDRY_KEY, Boolean.TRUE);
        this.detectGcp = (Boolean)agentConfig.getValue(DETECT_GOOGLE_CLOUD_PROVIDER_KEY, Boolean.TRUE);
        this.detectAzure = (Boolean)agentConfig.getValue(DETECT_AZURE_KEY, Boolean.TRUE);
        this.detectKubernetes = (Boolean)agentConfig.getValue(DETECT_KUBERNETES_KEY, Boolean.TRUE);
        this.hostName = Hostname.getHostname(agentConfig);
        this.fullHostName = Hostname.getFullHostname(agentConfig);
        this.ipAddress = Hostname.getIpAddress(agentConfig);
        this.isLinux = UtilizationService.isLinuxOs();
        this.bootId = DataFetcher.getBootId();
        this.dockerContainerId = this.detectDocker ? this.getDockerContainerId() : null;
        this.processorCount = DataFetcher.getLogicalProcessorCount();
        this.totalRamInMibFuture = this.executor.submit(DataFetcher.getTotalRamInMibCallable());
        this.configData = UtilizationConfig.createFromConfigService();
        this.kubernetesData = this.getKubernetesData();
        this.utilizationData = new UtilizationData(this.hostName, this.fullHostName, this.ipAddress, (Integer)this.processorCount, this.dockerContainerId, this.bootId, null, this.totalRamInMibFuture, this.configData, this.kubernetesData);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        this.scheduleUtilizationTask();
    }

    @Override
    protected void doStop() throws Exception {
        this.executor.shutdownNow();
    }

    private void scheduleUtilizationTask() {
        this.future = this.executor.submit(new UtilizationTask());
    }

    public UtilizationData updateUtilizationData() {
        if (this.future == null) {
            this.future = this.executor.submit(new UtilizationTask());
        }
        try {
            this.utilizationData = this.future.get(2000L, TimeUnit.MILLISECONDS);
            this.future = null;
        }
        catch (TimeoutException e) {
            Agent.LOG.log(Level.FINER, "Utilization task timed out. Returning cached utilization data.");
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Utilization task exception. Returning cached utilization data. {0}", t);
        }
        return this.utilizationData;
    }

    private static boolean isLinuxOs() {
        String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
        return os != null && !os.startsWith("windows") && !os.startsWith("mac");
    }

    protected AWS.AwsData getAwsData() {
        return aws.getData();
    }

    protected PCF.PcfData getPcfData() {
        return pcf.getData();
    }

    protected GCP.GcpData getGcpData() {
        return gcp.getData();
    }

    protected Azure.AzureData getAzureData() {
        return azure.getData();
    }

    DockerData getDockerData() {
        return dockerData;
    }

    KubernetesData getKubernetesData() {
        return this.detectKubernetes ? DataFetcher.getKubernetesData(SystemPropertyFactory.getSystemPropertyProvider()) : null;
    }

    String getDockerContainerId() {
        return this.getDockerData().getDockerContainerId(this.isLinux);
    }

    class UtilizationTask
    implements Callable<UtilizationData> {
        UtilizationTask() {
        }

        @Override
        public UtilizationData call() throws Exception {
            return this.doUpdateUtilizationData();
        }

        private UtilizationData doUpdateUtilizationData() {
            AWS.AwsData awsData;
            CloudData foundData = null;
            AWS.AwsData awsData2 = awsData = UtilizationService.this.detectAws ? UtilizationService.this.getAwsData() : AWS.AwsData.EMPTY_DATA;
            if (awsData != AWS.AwsData.EMPTY_DATA) {
                foundData = awsData;
            } else {
                PCF.PcfData pcfData;
                PCF.PcfData pcfData2 = pcfData = UtilizationService.this.detectPcf ? UtilizationService.this.getPcfData() : PCF.PcfData.EMPTY_DATA;
                if (pcfData != PCF.PcfData.EMPTY_DATA) {
                    foundData = pcfData;
                } else {
                    GCP.GcpData gcpData;
                    GCP.GcpData gcpData2 = gcpData = UtilizationService.this.detectGcp ? UtilizationService.this.getGcpData() : GCP.GcpData.EMPTY_DATA;
                    if (gcpData != GCP.GcpData.EMPTY_DATA) {
                        foundData = gcpData;
                    } else {
                        Azure.AzureData azureData;
                        Azure.AzureData azureData2 = azureData = UtilizationService.this.detectAzure ? UtilizationService.this.getAzureData() : Azure.AzureData.EMPTY_DATA;
                        if (azureData != Azure.AzureData.EMPTY_DATA) {
                            foundData = azureData;
                        }
                    }
                }
            }
            return new UtilizationData(UtilizationService.this.hostName, UtilizationService.this.fullHostName, (ArrayList<String>)UtilizationService.this.ipAddress, (Integer)UtilizationService.this.processorCount, UtilizationService.this.dockerContainerId, UtilizationService.this.bootId, foundData, UtilizationService.this.totalRamInMibFuture, UtilizationService.this.configData, UtilizationService.this.kubernetesData);
        }
    }
}

