/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.agent.deps.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedStackTrace;

public final class MethodSupport {
    private static final int JSON_SCHEMA_VERSION = 1;
    private static final int HEADROOM_75PC = 3072;

    public static String describeMethod(RecordedMethod method) {
        if (method == null) {
            return "[missing]";
        }
        return method.getType().getName() + "." + method.getName() + method.getDescriptor();
    }

    public static String empty() {
        List<Map<String, String>> payload = Collections.emptyList();
        try {
            return new String(MethodSupport.jsonWrite(payload, Optional.empty()).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate stacktrace json", e);
        }
    }

    public static String serialize(RecordedStackTrace trace) {
        if (trace == null) {
            return null;
        }
        ArrayList<Map<String, String>> payload = new ArrayList<Map<String, String>>();
        List<RecordedFrame> frames = trace.getFrames();
        for (RecordedFrame frame : frames) {
            HashMap<String, String> frameData = new HashMap<String, String>();
            frameData.put("desc", MethodSupport.describeMethod(frame.getMethod()));
            frameData.put("line", "" + frame.getLineNumber());
            frameData.put("bytecodeIndex", "" + frame.getBytecodeIndex());
            payload.add(frameData);
        }
        try {
            return new String(MethodSupport.jsonWrite(payload, Optional.empty()).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate stacktrace json", e);
        }
    }

    public static String jsonWrite(List<Map<String, String>> frames, Optional<Integer> limit) throws IOException {
        StringWriter strOut = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(strOut);
        int frameCount = Math.min(limit.orElse(frames.size()), frames.size());
        jsonWriter.beginObject();
        jsonWriter.name("type").value("stacktrace");
        jsonWriter.name("language").value("java");
        jsonWriter.name("version").value(1L);
        jsonWriter.name("truncated").value(frameCount < frames.size());
        jsonWriter.name("payload").beginArray();
        for (int i = 0; i < frameCount; ++i) {
            Map<String, String> frame = frames.get(i);
            jsonWriter.beginObject();
            jsonWriter.name("desc").value(frame.get("desc"));
            jsonWriter.name("line").value(frame.get("line"));
            jsonWriter.name("bytecodeIndex").value(frame.get("bytecodeIndex"));
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
        String out = strOut.toString();
        int length = out.length();
        if (length > 3072) {
            double percentageOfFramesToTry = 3072.0 / (double)length;
            int numFrames = (int)((double)frameCount * percentageOfFramesToTry);
            if (numFrames < frameCount) {
                return MethodSupport.jsonWrite(frames, Optional.of(numFrames));
            }
            throw new IOException("Corner case of a stack frame that can't be cleanly truncated! numFrames = " + numFrames + ", frameCount = " + frameCount + ", , percentageOfFramesToTry = " + percentageOfFramesToTry + ", length = " + length);
        }
        return out;
    }
}

