/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.jfr.BasicThreadInfo;
import com.newrelic.jfr.RecordedObjectValidators;
import java.util.Optional;
import java.util.function.Function;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public class Workarounds {
    public static final String SIMPLE_CLASS_NAME = Workarounds.class.getSimpleName();
    public static final String EVENT_THREAD = "eventThread";
    public static final String SUCCEEDED = "succeeded";
    public static final String SUCCEDED_TYPO = "succeded";

    public static Optional<String> getThreadName(RecordedEvent ev) {
        return Workarounds.getRecordedThreadInfo(ev, RecordedThread::getJavaName);
    }

    public static Optional<BasicThreadInfo> getBasicThreadInfo(RecordedEvent ev) {
        return Workarounds.getRecordedThreadInfo(ev, BasicThreadInfo::new);
    }

    private static <T> Optional<T> getRecordedThreadInfo(RecordedEvent ev, Function<RecordedThread, T> converter) {
        Object thisField;
        if (RecordedObjectValidators.hasField(ev, EVENT_THREAD, SIMPLE_CLASS_NAME) && (thisField = ev.getValue(EVENT_THREAD)) instanceof RecordedThread) {
            return Optional.of(converter.apply((RecordedThread)thisField));
        }
        return Optional.empty();
    }

    public static boolean getSucceeded(RecordedEvent ev) {
        if (RecordedObjectValidators.hasField(ev, SUCCEEDED, SIMPLE_CLASS_NAME)) {
            return ev.getBoolean(SUCCEEDED);
        }
        if (RecordedObjectValidators.hasField(ev, SUCCEDED_TYPO, SIMPLE_CLASS_NAME)) {
            return ev.getBoolean(SUCCEDED_TYPO);
        }
        return false;
    }
}

