/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.logs;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.Telemetry;
import com.newrelic.telemetry.util.Utils;

public class Log
implements Telemetry {
    private final long timestamp;
    private final String message;
    private final Attributes attributes;
    private final String serviceName;
    private final String level;
    private final Throwable throwable;

    private Log(LogBuilder builder, Throwable throwable) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.attributes = builder.attributes;
        this.serviceName = builder.serviceName;
        this.level = builder.level;
        this.throwable = throwable;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getLevel() {
        return this.level;
    }

    public static LogBuilder builder() {
        return new LogBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log log = (Log)o;
        if (this.timestamp != log.timestamp) {
            return false;
        }
        if (this.message != null ? !this.message.equals(log.message) : log.message != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(log.attributes) : log.attributes != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(log.serviceName) : log.serviceName != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(log.level) : log.level != null) {
            return false;
        }
        return this.throwable != null ? this.throwable.equals(log.throwable) : log.throwable == null;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Log{timestamp=" + this.timestamp + ", message='" + this.message + '\'' + ", attributes=" + this.attributes + ", serviceName='" + this.serviceName + '\'' + ", level='" + this.level + '\'' + ", throwable=" + this.throwable + '}';
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static class LogBuilder {
        private long timestamp = System.currentTimeMillis();
        private String message;
        private Attributes attributes = new Attributes();
        private String serviceName;
        private String level;
        private Throwable throwable;

        public LogBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public LogBuilder message(String message) {
            this.message = message;
            return this;
        }

        public LogBuilder attributes(Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public LogBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public LogBuilder level(String logLevel) {
            this.level = logLevel;
            return this;
        }

        public Log build() {
            return new Log(this, this.throwable);
        }

        public LogBuilder throwable(Throwable e) {
            Utils.verifyNonNull(e);
            this.throwable = e;
            return this;
        }

        public String toString() {
            return "LogBuilder{timestamp=" + this.timestamp + ", message='" + this.message + '\'' + ", attributes=" + this.attributes + ", serviceName='" + this.serviceName + '\'' + ", level='" + this.level + '\'' + ", throwable=" + this.throwable + '}';
        }
    }
}

