/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.okhttp;

import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.io.grpc.InternalMetadata;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.internal.GrpcUtil;
import com.newrelic.agent.deps.io.grpc.internal.TransportFrameUtil;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.framed.Header;
import com.newrelic.agent.deps.okio.ByteString;
import java.util.ArrayList;
import java.util.List;

class Headers {
    public static final Header HTTPS_SCHEME_HEADER = new Header(Header.TARGET_SCHEME, "https");
    public static final Header HTTP_SCHEME_HEADER = new Header(Header.TARGET_SCHEME, "http");
    public static final Header METHOD_HEADER = new Header(Header.TARGET_METHOD, "POST");
    public static final Header METHOD_GET_HEADER = new Header(Header.TARGET_METHOD, "GET");
    public static final Header CONTENT_TYPE_HEADER = new Header(GrpcUtil.CONTENT_TYPE_KEY.name(), "application/grpc");
    public static final Header TE_HEADER = new Header("te", "trailers");

    Headers() {
    }

    public static List<Header> createRequestHeaders(Metadata headers, String defaultPath, String authority, String userAgent, boolean useGet, boolean usePlaintext) {
        Preconditions.checkNotNull(headers, "headers");
        Preconditions.checkNotNull(defaultPath, "defaultPath");
        Preconditions.checkNotNull(authority, "authority");
        Headers.stripNonApplicationHeaders(headers);
        ArrayList<Header> okhttpHeaders = new ArrayList<Header>(7 + InternalMetadata.headerCount(headers));
        if (usePlaintext) {
            okhttpHeaders.add(HTTP_SCHEME_HEADER);
        } else {
            okhttpHeaders.add(HTTPS_SCHEME_HEADER);
        }
        if (useGet) {
            okhttpHeaders.add(METHOD_GET_HEADER);
        } else {
            okhttpHeaders.add(METHOD_HEADER);
        }
        okhttpHeaders.add(new Header(Header.TARGET_AUTHORITY, authority));
        String path = defaultPath;
        okhttpHeaders.add(new Header(Header.TARGET_PATH, path));
        okhttpHeaders.add(new Header(GrpcUtil.USER_AGENT_KEY.name(), userAgent));
        okhttpHeaders.add(CONTENT_TYPE_HEADER);
        okhttpHeaders.add(TE_HEADER);
        return Headers.addMetadata(okhttpHeaders, headers);
    }

    public static List<Header> createResponseHeaders(Metadata headers) {
        Headers.stripNonApplicationHeaders(headers);
        ArrayList<Header> okhttpHeaders = new ArrayList<Header>(2 + InternalMetadata.headerCount(headers));
        okhttpHeaders.add(new Header(Header.RESPONSE_STATUS, "200"));
        okhttpHeaders.add(CONTENT_TYPE_HEADER);
        return Headers.addMetadata(okhttpHeaders, headers);
    }

    public static List<Header> createResponseTrailers(Metadata trailers, boolean headersSent) {
        if (!headersSent) {
            return Headers.createResponseHeaders(trailers);
        }
        Headers.stripNonApplicationHeaders(trailers);
        ArrayList<Header> okhttpTrailers = new ArrayList<Header>(InternalMetadata.headerCount(trailers));
        return Headers.addMetadata(okhttpTrailers, trailers);
    }

    public static List<Header> createHttpResponseHeaders(int httpCode, String contentType, Metadata headers) {
        ArrayList<Header> okhttpHeaders = new ArrayList<Header>(2 + InternalMetadata.headerCount(headers));
        okhttpHeaders.add(new Header(Header.RESPONSE_STATUS, "" + httpCode));
        okhttpHeaders.add(new Header(GrpcUtil.CONTENT_TYPE_KEY.name(), contentType));
        return Headers.addMetadata(okhttpHeaders, headers);
    }

    private static List<Header> addMetadata(List<Header> okhttpHeaders, Metadata toAdd) {
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers(toAdd);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            ByteString key = ByteString.of(serializedHeaders[i]);
            if (key.size() == 0 || key.getByte(0) == 58) continue;
            ByteString value = ByteString.of(serializedHeaders[i + 1]);
            okhttpHeaders.add(new Header(key, value));
        }
        return okhttpHeaders;
    }

    private static void stripNonApplicationHeaders(Metadata headers) {
        headers.discardAll(GrpcUtil.CONTENT_TYPE_KEY);
        headers.discardAll(GrpcUtil.TE_HEADER);
        headers.discardAll(GrpcUtil.USER_AGENT_KEY);
    }
}

