
package com.prowidesoftware.swift.model.mx.dic;

import java.time.Month;
import java.time.Year;
import com.prowidesoftware.swift.model.mx.adapters.IsoMonthAdapter;
import com.prowidesoftware.swift.model.mx.adapters.IsoYearAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Defines the criteria used to search for calendar data.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CalendarSearchCriteria1", propOrder = {
    "yr",
    "mnth",
    "svc"
})
public class CalendarSearchCriteria1 {

    @XmlElement(name = "Yr", type = String.class)
    @XmlJavaTypeAdapter(IsoYearAdapter.class)
    @XmlSchemaType(name = "gYear")
    protected Year yr;
    @XmlElement(name = "Mnth", type = String.class)
    @XmlJavaTypeAdapter(IsoMonthAdapter.class)
    @XmlSchemaType(name = "gMonth")
    protected Month mnth;
    @XmlElement(name = "Svc")
    protected SystemAndCurrency1 svc;

    /**
     * Gets the value of the yr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Year getYr() {
        return yr;
    }

    /**
     * Sets the value of the yr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public CalendarSearchCriteria1 setYr(Year value) {
        this.yr = value;
        return this;
    }

    /**
     * Gets the value of the mnth property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Month getMnth() {
        return mnth;
    }

    /**
     * Sets the value of the mnth property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public CalendarSearchCriteria1 setMnth(Month value) {
        this.mnth = value;
        return this;
    }

    /**
     * Gets the value of the svc property.
     * 
     * @return
     *     possible object is
     *     {@link SystemAndCurrency1 }
     *     
     */
    public SystemAndCurrency1 getSvc() {
        return svc;
    }

    /**
     * Sets the value of the svc property.
     * 
     * @param value
     *     allowed object is
     *     {@link SystemAndCurrency1 }
     *     
     */
    public CalendarSearchCriteria1 setSvc(SystemAndCurrency1 value) {
        this.svc = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

}
