/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import java.lang.reflect.Type;

public class SwiftBlock2Adapter
implements JsonSerializer<SwiftBlock2>,
JsonDeserializer<SwiftBlock2> {
    private static final String DIRECTION = "direction";

    private static void setSwiftBlock2Properties(SwiftBlock2 sb, JsonObject jsonObject) {
        if (jsonObject.get("messageType") != null) {
            sb.setMessageType(jsonObject.get("messageType").getAsString());
        }
        if (jsonObject.get("messagePriority") != null) {
            sb.setMessagePriority(jsonObject.get("messagePriority").getAsString());
        }
    }

    public JsonElement serialize(SwiftBlock2 swiftBlock2, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonElement object = jsonSerializationContext.serialize((Object)swiftBlock2);
        String direction = "";
        direction = swiftBlock2.isInput() ? "I" : "O";
        object.getAsJsonObject().addProperty(DIRECTION, direction);
        return object;
    }

    public SwiftBlock2 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.get(DIRECTION) != null && jsonObject.get(DIRECTION).getAsString().equals("O")) {
            return this.getSwiftBlock2OutputObject(jsonObject);
        }
        return this.getSwiftBlock2InputObject(jsonObject);
    }

    private SwiftBlock2Output getSwiftBlock2OutputObject(JsonObject jsonObject) {
        SwiftBlock2Output swiftBlock2Output = new SwiftBlock2Output();
        SwiftBlock2Adapter.setSwiftBlock2Properties(swiftBlock2Output, jsonObject);
        if (jsonObject.get("senderInputTime") != null) {
            swiftBlock2Output.setSenderInputTime(jsonObject.get("senderInputTime").getAsString());
        }
        if (jsonObject.get("MIRDate") != null) {
            swiftBlock2Output.setMIRDate(jsonObject.get("MIRDate").getAsString());
        }
        if (jsonObject.get("MIRLogicalTerminal") != null) {
            swiftBlock2Output.setMIRLogicalTerminal(jsonObject.get("MIRLogicalTerminal").getAsString());
        }
        if (jsonObject.get("MIRSessionNumber") != null) {
            swiftBlock2Output.setMIRSessionNumber(jsonObject.get("MIRSessionNumber").getAsString());
        }
        if (jsonObject.get("MIRSequenceNumber") != null) {
            swiftBlock2Output.setMIRSequenceNumber(jsonObject.get("MIRSequenceNumber").getAsString());
        }
        if (jsonObject.get("receiverOutputDate") != null) {
            swiftBlock2Output.setReceiverOutputDate(jsonObject.get("receiverOutputDate").getAsString());
        }
        if (jsonObject.get("receiverOutputTime") != null) {
            swiftBlock2Output.setReceiverOutputTime(jsonObject.get("receiverOutputTime").getAsString());
        }
        return swiftBlock2Output;
    }

    private SwiftBlock2Input getSwiftBlock2InputObject(JsonObject jsonObject) {
        SwiftBlock2Input swiftBlock2Input = new SwiftBlock2Input();
        SwiftBlock2Adapter.setSwiftBlock2Properties(swiftBlock2Input, jsonObject);
        if (jsonObject.get("receiverAddress") != null) {
            swiftBlock2Input.setReceiverAddress(jsonObject.get("receiverAddress").getAsString());
        }
        if (jsonObject.get("deliveryMonitoring") != null) {
            swiftBlock2Input.setDeliveryMonitoring(jsonObject.get("deliveryMonitoring").getAsString());
        }
        if (jsonObject.get("obsolescencePeriod") != null) {
            swiftBlock2Input.setObsolescencePeriod(jsonObject.get("obsolescencePeriod").getAsString());
        }
        return swiftBlock2Input;
    }
}

