/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field177;
import com.prowidesoftware.swift.model.field.Field303;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT031
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT031.class.getName());
    public static final String NAME = "031";

    public MT031(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT031(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT031 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT031(m);
    }

    public MT031() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT031(String sender, String receiver) {
        super(31, sender, receiver);
    }

    public MT031(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT031.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT031 object from FIN content with a Service Message. Check if the MT031 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT031 object from FIN content with message type " + param.getType());
        }
    }

    public static MT031 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT031(fin);
    }

    public MT031(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT031 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT031(stream);
    }

    public MT031(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT031 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT031(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT031 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT031 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT031 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT031 fromJson(String json) {
        return (MT031)AbstractMT.fromJson(json);
    }

    public Field303 getField303() {
        Tag t = this.tag("303");
        if (t != null) {
            return new Field303(t.getValue());
        }
        return null;
    }

    public List<Field177> getField177() {
        ArrayList<Field177> result = new ArrayList<Field177>();
        Tag[] tags = this.tags("177");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field177(tag.getValue()));
            }
        }
        return result;
    }
}

