/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field303;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT041
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT041.class.getName());
    public static final String NAME = "041";

    public MT041(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT041(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT041 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT041(m);
    }

    public MT041() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT041(String sender, String receiver) {
        super(41, sender, receiver);
    }

    public MT041(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT041.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT041 object from FIN content with a Service Message. Check if the MT041 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT041 object from FIN content with message type " + param.getType());
        }
    }

    public static MT041 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT041(fin);
    }

    public MT041(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT041 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT041(stream);
    }

    public MT041(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT041 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT041(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT041 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT041 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT041 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT041 fromJson(String json) {
        return (MT041)AbstractMT.fromJson(json);
    }

    public Field303 getField303() {
        Tag t = this.tag("303");
        if (t != null) {
            return new Field303(t.getValue());
        }
        return null;
    }
}

