/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT049
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT049.class.getName());
    public static final String NAME = "049";

    public MT049(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT049(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT049 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT049(m);
    }

    public MT049() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT049(String sender, String receiver) {
        super(49, sender, receiver);
    }

    public MT049(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT049.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT049 object from FIN content with a Service Message. Check if the MT049 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT049 object from FIN content with message type " + param.getType());
        }
    }

    public static MT049 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT049(fin);
    }

    public MT049(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT049 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT049(stream);
    }

    public MT049(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT049 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT049(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT049 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT049 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT049 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT049 fromJson(String json) {
        return (MT049)AbstractMT.fromJson(json);
    }
}

