/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.TransactionType;
import io.fusionauth.domain.event.EventType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EventConfiguration
implements Buildable<EventConfiguration> {
    public Map<EventType, EventConfigurationData> events = new HashMap<EventType, EventConfigurationData>();

    @JacksonConstructor
    public EventConfiguration() {
    }

    public EventConfiguration(EventConfiguration other) {
        for (Map.Entry<EventType, EventConfigurationData> entry : other.events.entrySet()) {
            this.events.put(entry.getKey(), new EventConfigurationData(entry.getValue()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventConfiguration that = (EventConfiguration)o;
        return Objects.equals(this.events, that.events);
    }

    public int hashCode() {
        return Objects.hash(this.events);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class EventConfigurationData
    extends Enableable {
        public TransactionType transactionType;

        @JacksonConstructor
        public EventConfigurationData() {
        }

        public EventConfigurationData(boolean enabled, TransactionType transactionType) {
            this.enabled = enabled;
            this.transactionType = transactionType;
        }

        public EventConfigurationData(EventConfigurationData other) {
            this.enabled = other.enabled;
            this.transactionType = other.transactionType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventConfigurationData that = (EventConfigurationData)o;
            return super.equals(o) && Objects.equals((Object)this.transactionType, (Object)that.transactionType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.transactionType});
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

