/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Tenantable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Group
implements Buildable<Group>,
Tenantable {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public String name;
    public Map<UUID, List<ApplicationRole>> roles = new HashMap<UUID, List<ApplicationRole>>();
    public UUID tenantId;

    @JacksonConstructor
    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public Group(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group group = (Group)o;
        this.roles.values().forEach(c -> c.sort(Comparator.comparing(r -> r.id)));
        group.roles.values().forEach(c -> c.sort(Comparator.comparing(r -> r.id)));
        return Objects.equals(this.data, group.data) && Objects.equals(this.name, group.name) && Objects.equals(this.roles, group.roles) && Objects.equals(this.tenantId, group.tenantId);
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.name, this.roles, this.tenantId);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

