/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class Key
implements Buildable<Key> {
    public KeyAlgorithm algorithm;
    public String certificate;
    public CertificateInformation certificateInformation;
    public ZonedDateTime expirationInstant;
    public UUID id;
    public ZonedDateTime insertInstant;
    public String issuer;
    public String kid;
    public Integer length;
    public String name;
    public boolean pair;
    public String privateKey;
    public String publicKey;
    public String secret;
    public KeyType type;

    public Key() {
    }

    public Key(Key key) {
        this.algorithm = key.algorithm;
        this.certificate = key.certificate;
        this.certificateInformation = key.certificateInformation;
        this.expirationInstant = key.expirationInstant;
        this.id = key.id;
        this.insertInstant = key.insertInstant;
        this.issuer = key.issuer;
        this.kid = key.kid;
        this.length = key.length;
        this.name = key.name;
        this.pair = key.pair;
        this.privateKey = key.privateKey;
        this.publicKey = key.publicKey;
        this.secret = key.secret;
        this.type = key.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals((Object)this.algorithm, (Object)key.algorithm) && Objects.equals(this.certificateInformation, key.certificateInformation) && Objects.equals(this.expirationInstant, key.expirationInstant) && Objects.equals(this.id, key.id) && Objects.equals(this.insertInstant, key.insertInstant) && Objects.equals(this.issuer, key.issuer) && Objects.equals(this.kid, key.kid) && Objects.equals(this.length, key.length) && Objects.equals(this.name, key.name) && Objects.equals(this.pair, key.pair) && Objects.equals(this.privateKey, key.privateKey) && Objects.equals(this.publicKey, key.publicKey) && Objects.equals(this.secret, key.secret) && Objects.equals((Object)this.type, (Object)key.type);
    }

    @JsonIgnore
    public String getDisplayName() {
        if (this.algorithm == null) {
            return this.name + " (" + this.type.name() + ")";
        }
        return this.name + " (" + this.algorithm.name() + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.certificateInformation, this.expirationInstant, this.id, this.insertInstant, this.issuer, this.kid, this.length, this.name, this.pair, this.privateKey, this.publicKey, this.secret, this.type});
    }

    @JsonIgnore
    public boolean isExpired() {
        if (this.expirationInstant == null) {
            return false;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).isAfter(this.expirationInstant);
    }

    @JsonIgnore
    public boolean isPair() {
        return this.pair;
    }

    public void normalize() {
        if (this.certificate != null) {
            this.certificate = this.certificate.replace("\r\n", "\n").replace("\r", "\n");
        }
        if (this.publicKey != null) {
            this.publicKey = this.publicKey.replace("\r\n", "\n").replace("\r", "\n");
        }
        if (this.privateKey != null) {
            this.privateKey = this.privateKey.replace("\r\n", "\n").replace("\r", "\n");
        }
    }

    public Key secure() {
        this.privateKey = null;
        this.secret = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class CertificateInformation {
        public String issuer;
        public String md5Fingerprint;
        public String serialNumber;
        public String sha1Fingerprint;
        public String sha1Thumbprint;
        public String sha256Fingerprint;
        public String sha256Thumbprint;
        public String subject;
        public ZonedDateTime validFrom;
        public ZonedDateTime validTo;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CertificateInformation)) {
                return false;
            }
            CertificateInformation that = (CertificateInformation)o;
            return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.md5Fingerprint, that.md5Fingerprint) && Objects.equals(this.serialNumber, that.serialNumber) && Objects.equals(this.sha1Fingerprint, that.sha1Fingerprint) && Objects.equals(this.sha1Thumbprint, that.sha1Thumbprint) && Objects.equals(this.sha256Fingerprint, that.sha256Fingerprint) && Objects.equals(this.sha256Thumbprint, that.sha256Thumbprint) && Objects.equals(this.subject, that.subject) && Objects.equals(this.validFrom, that.validFrom) && Objects.equals(this.validTo, that.validTo);
        }

        public int hashCode() {
            return Objects.hash(this.issuer, this.md5Fingerprint, this.serialNumber, this.sha1Fingerprint, this.sha1Thumbprint, this.sha256Fingerprint, this.sha256Thumbprint, this.subject, this.validFrom, this.validTo);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static enum KeyType {
        EC,
        RSA,
        HMAC;

    }

    public static enum KeyAlgorithm {
        ES256("SHA256withECDSA"),
        ES384("SHA384withECDSA"),
        ES512("SHA512withECDSA"),
        HS256("HmacSHA256"),
        HS384("HmacSHA384"),
        HS512("HmacSHA512"),
        RS256("SHA256withRSA"),
        RS384("SHA384withRSA"),
        RS512("SHA512withRSA");

        public String algorithm;

        private KeyAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getName() {
            return this.algorithm;
        }
    }
}

