/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.HTTPMethod;
import java.net.URI;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SystemConfiguration
implements Buildable<SystemConfiguration>,
_InternalJSONColumn {
    @InternalJSONColumn
    public AuditLogConfiguration auditLogConfiguration = new AuditLogConfiguration();
    @InternalJSONColumn
    public String cookieEncryptionIV;
    @InternalJSONColumn
    public String cookieEncryptionKey;
    @InternalJSONColumn
    public CORSConfiguration corsConfiguration = new CORSConfiguration();
    public Map<String, Object> data = new HashMap<String, Object>();
    @InternalJSONColumn
    public EventLogConfiguration eventLogConfiguration = new EventLogConfiguration();
    @InternalJSONColumn
    public LoginRecordConfiguration loginRecordConfiguration = new LoginRecordConfiguration();
    public ZoneId reportTimezone;
    @InternalJSONColumn
    public UIConfiguration uiConfiguration = new UIConfiguration();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemConfiguration)) {
            return false;
        }
        SystemConfiguration that = (SystemConfiguration)o;
        return Objects.equals(this.auditLogConfiguration, that.auditLogConfiguration) && Objects.equals(this.cookieEncryptionIV, that.cookieEncryptionIV) && Objects.equals(this.cookieEncryptionKey, that.cookieEncryptionKey) && Objects.equals(this.corsConfiguration, that.corsConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.eventLogConfiguration, that.eventLogConfiguration) && Objects.equals(this.loginRecordConfiguration, that.loginRecordConfiguration) && Objects.equals(this.reportTimezone, that.reportTimezone) && Objects.equals(this.uiConfiguration, that.uiConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.cookieEncryptionIV, this.cookieEncryptionKey, this.corsConfiguration, this.data, this.reportTimezone, this.uiConfiguration);
    }

    public void normalize() {
        if (this.uiConfiguration != null) {
            this.uiConfiguration.normalize();
        }
        if (this.corsConfiguration != null) {
            this.corsConfiguration.normalize();
        }
    }

    public SystemConfiguration secure() {
        this.cookieEncryptionIV = null;
        this.cookieEncryptionKey = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class UIConfiguration
    implements Buildable<UIConfiguration> {
        public String headerColor;
        public String logoURL;
        public String menuFontColor;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UIConfiguration)) {
                return false;
            }
            UIConfiguration that = (UIConfiguration)o;
            return Objects.equals(this.logoURL, that.logoURL) && Objects.equals(this.headerColor, that.headerColor) && Objects.equals(this.menuFontColor, that.menuFontColor);
        }

        public int hashCode() {
            return Objects.hash(this.logoURL, this.headerColor, this.menuFontColor);
        }

        public void normalize() {
        }
    }

    public static class LoginRecordConfiguration {
        public DeleteConfiguration delete = new DeleteConfiguration();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoginRecordConfiguration)) {
                return false;
            }
            LoginRecordConfiguration that = (LoginRecordConfiguration)o;
            return Objects.equals(this.delete, that.delete);
        }

        public int hashCode() {
            return Objects.hash(this.delete);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class EventLogConfiguration {
        public int numberToRetain = 10000;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EventLogConfiguration)) {
                return false;
            }
            EventLogConfiguration that = (EventLogConfiguration)o;
            return this.numberToRetain == that.numberToRetain;
        }

        public int hashCode() {
            return Objects.hash(this.numberToRetain);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class DeleteConfiguration
    extends Enableable {
        public Integer numberOfDaysToRetain;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteConfiguration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DeleteConfiguration that = (DeleteConfiguration)o;
            return Objects.equals(this.numberOfDaysToRetain, that.numberOfDaysToRetain);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.numberOfDaysToRetain);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class CORSConfiguration
    extends Enableable
    implements Buildable<CORSConfiguration> {
        public boolean allowCredentials;
        public List<String> allowedHeaders = new ArrayList<String>();
        public List<HTTPMethod> allowedMethods = new ArrayList<HTTPMethod>();
        public List<URI> allowedOrigins = new ArrayList<URI>();
        public List<String> exposedHeaders = new ArrayList<String>();
        public int preflightMaxAgeInSeconds;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CORSConfiguration that = (CORSConfiguration)o;
            Collections.sort(this.allowedHeaders);
            Collections.sort(that.allowedHeaders);
            Collections.sort(this.allowedMethods);
            Collections.sort(that.allowedMethods);
            Collections.sort(this.allowedOrigins);
            Collections.sort(that.allowedOrigins);
            Collections.sort(this.exposedHeaders);
            Collections.sort(that.exposedHeaders);
            return this.preflightMaxAgeInSeconds == that.preflightMaxAgeInSeconds && this.allowCredentials == that.allowCredentials && Objects.equals(this.allowedHeaders, that.allowedHeaders) && Objects.equals(this.allowedMethods, that.allowedMethods) && Objects.equals(this.allowedOrigins, that.allowedOrigins) && Objects.equals(this.exposedHeaders, that.exposedHeaders);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.allowedHeaders, this.allowedMethods, this.allowedOrigins, this.exposedHeaders, this.preflightMaxAgeInSeconds, this.allowCredentials);
        }

        public void normalize() {
            HashSet<HTTPMethod> methods = new HashSet<HTTPMethod>(this.allowedMethods);
            this.allowedMethods.clear();
            this.allowedMethods.addAll(methods);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class AuditLogConfiguration {
        public DeleteConfiguration delete = new DeleteConfiguration();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuditLogConfiguration)) {
                return false;
            }
            AuditLogConfiguration that = (AuditLogConfiguration)o;
            return Objects.equals(this.delete, that.delete);
        }

        public int hashCode() {
            return Objects.hash(this.delete);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

