/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.UserActionLog;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class UserComment
implements Buildable<UserComment> {
    public String comment;
    public UUID commenterId;
    public ZonedDateTime createInstant;
    public UUID id;
    public UUID userId;

    public UserComment() {
    }

    public UserComment(String comment, ZonedDateTime createInstant, UUID id, UUID userId, UUID commenterId) {
        this.comment = comment;
        this.createInstant = createInstant;
        this.id = id;
        this.userId = userId;
        this.commenterId = commenterId;
    }

    public static UserActionLog toUserActionLog(UserComment userComment) {
        return new UserActionLog().with(l -> {
            l.actioneeUserId = userComment.userId;
        }).with(l -> {
            l.actionerUserId = userComment.commenterId;
        }).with(l -> {
            l.comment = userComment.comment;
        }).with(l -> {
            l.createInstant = userComment.createInstant;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserComment)) {
            return false;
        }
        UserComment that = (UserComment)o;
        return Objects.equals(this.comment, that.comment) && Objects.equals(this.commenterId, that.commenterId) && Objects.equals(this.createInstant, that.createInstant) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.commenterId, this.createInstant, this.userId);
    }

    public void normalize() {
        this.comment = Normalizer.trim(this.comment);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

