/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.ApplicationEvent;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;

public class JWTRefreshTokenRevokeEvent
extends BaseEvent
implements Buildable<JWTRefreshTokenRevokeEvent>,
ApplicationEvent {
    public UUID applicationId;
    public Map<UUID, Integer> applicationTimeToLiveInSeconds = new TreeMap<UUID, Integer>();
    public User user;
    public UUID userId;

    @JacksonConstructor
    public JWTRefreshTokenRevokeEvent() {
    }

    public JWTRefreshTokenRevokeEvent(User user, UUID applicationId, int timeToLiveInSeconds) {
        this.applicationId = applicationId;
        this.applicationTimeToLiveInSeconds.put(applicationId, timeToLiveInSeconds);
        this.user = user;
        this.userId = user == null ? null : user.id;
    }

    public JWTRefreshTokenRevokeEvent(User user, Map<UUID, Integer> applicationTimeToLiveInSeconds) {
        this.applicationTimeToLiveInSeconds.putAll(applicationTimeToLiveInSeconds);
        this.user = user;
        this.userId = user == null ? null : user.id;
    }

    public List<UUID> applicationIds() {
        return new ArrayList<UUID>(this.applicationTimeToLiveInSeconds.keySet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTRefreshTokenRevokeEvent that = (JWTRefreshTokenRevokeEvent)o;
        return super.equals(o) && Objects.equals(this.applicationTimeToLiveInSeconds, that.applicationTimeToLiveInSeconds) && Objects.equals(this.user, that.user) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public EventType getType() {
        return EventType.JWTRefreshTokenRevoke;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationTimeToLiveInSeconds, this.user, this.userId);
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

